/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.generation.feature.tree;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public abstract class TreeFeatureBDB
extends Feature<NoneFeatureConfiguration> {
    public TreeFeatureBDB(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    protected abstract boolean createTree(WorldGenLevel var1, RandomSource var2, BlockPos var3, BiConsumer<BlockPos, BlockState> var4, BiConsumer<BlockPos, BlockState> var5);

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < world.m_151558_() && this.canBeReplacedByTree((LevelSimulatedReader)world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isBlockWater(BlockState state) {
        return state.m_60713_(Blocks.f_49990_);
    }

    public boolean isAirOrLeaves(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_13035_);
    }

    private boolean isReplaceablePlant(BlockState state) {
        return state.m_204336_(BlockTags.f_278411_);
    }

    public boolean canBeReplacedByTree(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> this.canBeReplacedByLogs((BlockState)state));
    }

    protected boolean canBeReplacedByLeaves(BlockState state) {
        return this.isAirOrLeaves(state) || this.isBlockWater(state) || this.isReplaceablePlant(state);
    }

    protected boolean canBeReplacedByLogs(BlockState state) {
        return this.canBeReplacedByLeaves(state) || state.m_204336_(BlockTags.f_13106_);
    }

    private static void setBlockKnownShape(LevelWriter world, BlockPos p_67258_, BlockState p_67259_) {
        world.m_7731_(p_67258_, p_67259_, 19);
    }

    protected void placeBlock(WorldGenLevel world, BlockPos pos, BlockState blockState) {
        TreeFeatureBDB.setBlockKnownShape((LevelWriter)world, pos, blockState);
    }

    protected void tryPlaceLog(WorldGenLevel world, BlockPos logPos, BlockState logState) {
        if (this.canBeReplacedByLogs(world.m_8055_(logPos))) {
            this.placeBlock(world, logPos, logState);
        }
    }

    protected void tryPlaceLeaves(WorldGenLevel world, BlockPos leavesPos, BlockState leavesState) {
        if (this.canBeReplacedByLeaves(world.m_8055_(leavesPos))) {
            this.placeBlock(world, leavesPos, leavesState);
        }
    }

    public final boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureContext) {
        WorldGenLevel worldgenlevel = featureContext.m_159774_();
        RandomSource random = featureContext.m_225041_();
        BlockPos blockpos = featureContext.m_159777_();
        HashSet posLogs = Sets.newHashSet();
        HashSet posLeaves = Sets.newHashSet();
        HashSet posDecorators = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> logConsumer = (logPos, logState) -> {
            posLogs.add(logPos.m_7949_());
            this.tryPlaceLog(worldgenlevel, (BlockPos)logPos, (BlockState)logState);
        };
        BiConsumer<BlockPos, BlockState> leavesConsumer = (leavesPos, leavesState) -> {
            posLeaves.add(leavesPos.m_7949_());
            this.tryPlaceLeaves(worldgenlevel, (BlockPos)leavesPos, (BlockState)leavesState);
        };
        boolean createTree = this.createTree(worldgenlevel, random, blockpos, logConsumer, leavesConsumer);
        if (!(!createTree || posLogs.isEmpty() && posLeaves.isEmpty())) {
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)posLogs, (Iterable)posLeaves, (Iterable)posDecorators)).map(boundingBox -> {
                DiscreteVoxelShape discretevoxelshape = TreeFeatureBDB.updateLeaves((LevelAccessor)worldgenlevel, boundingBox, posLogs, posDecorators);
                StructureTemplate.m_74510_((LevelAccessor)worldgenlevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)boundingBox.m_162395_(), (int)boundingBox.m_162396_(), (int)boundingBox.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor p_67203_, BoundingBox p_67204_, Set<BlockPos> p_67205_, Set<BlockPos> p_67206_) {
        ArrayList<HashSet> list = new ArrayList<HashSet>();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(p_67204_.m_71056_(), p_67204_.m_71057_(), p_67204_.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - p_67204_.m_162395_(), blockpos.m_123342_() - p_67204_.m_162396_(), blockpos.m_123343_() - p_67204_.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - p_67204_.m_162395_(), blockpos1.m_123342_() - p_67204_.m_162396_(), blockpos1.m_123343_() - p_67204_.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                if (p_67205_.contains(blockpos$mutableblockpos) || !(blockstate = p_67203_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.m_7949_());
                TreeFeatureBDB.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.m_71051_((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_67204_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_67204_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_67204_.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (p_67204_.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - p_67204_.m_162395_(), blockpos2.m_123342_() - p_67204_.m_162396_(), blockpos2.m_123343_() - p_67204_.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_67203_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    TreeFeatureBDB.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (p_67204_.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_67204_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_67204_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_67204_.m_162398_());
                    }
                    set1.add(blockpos$mutableblockpos.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }
}

