/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.generation.feature.tree;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.data.BDBTags;
import xratedjunior.betterdefaultbiomes.util.BDBMathUtil;
import xratedjunior.betterdefaultbiomes.world.generation.feature.tree.TreeFeatureBDB;

public class SwampWillowTreeFeature
extends TreeFeatureBDB {
    protected BlockState log = ((Block)BDBBlocks.SWAMP_WILLOW_LOG.get()).m_49966_();
    protected BlockState leaves = ((Block)BDBBlocks.SWAMP_WILLOW_LEAVES.get()).m_49966_();
    protected int minTreeHeight = 8;
    protected int maxTreeHeight = 12;

    public SwampWillowTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    protected boolean createTree(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        int height = BDBMathUtil.nextIntBetween(random, this.minTreeHeight, this.maxTreeHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        if (height < 6) {
            return false;
        }
        BlockPos pos = startPos;
        if (!this.checkSpace(world, pos, height, 1)) {
            return false;
        }
        this.generateTrunk(world, logs, pos);
        this.generateLeavesTop(leaves, pos);
        this.addVines(world, random, startPos, heightMinusTop, height, 6, 10);
        this.replaceGround((LevelAccessor)world, pos);
        return true;
    }

    private void generateTrunk(WorldGenLevel world, BiConsumer<BlockPos, BlockState> logs, BlockPos pos) {
        BlockPos logPos;
        int height;
        int left = 1;
        int right = -1;
        int front = -1;
        int back = 1;
        for (int y = 0; y > -8; --y) {
            BlockPos posY = pos.m_7918_(right, y, front);
            if (!world.m_8055_(posY).m_60815_()) {
                logs.accept(posY, this.log);
            }
            if (!world.m_8055_(posY = pos.m_7918_(left, y, front)).m_60815_()) {
                logs.accept(posY, this.log);
            }
            if (!world.m_8055_(posY = pos.m_7918_(left, y + 1, 0)).m_60815_()) {
                logs.accept(posY, this.log);
            }
            if (!world.m_8055_(posY = pos.m_7918_(0, y + 2, back)).m_60815_()) {
                logs.accept(posY, this.log);
            }
            if (!world.m_8055_(posY = pos.m_7918_(right * 2, y, back * 2)).m_60815_()) {
                logs.accept(posY, this.log);
            }
            if (world.m_8055_(posY = pos.m_7918_(right, y + 1, back)).m_60815_()) break;
            logs.accept(posY, this.log);
        }
        for (height = 0; height <= 3; ++height) {
            logPos = pos.m_6630_(height);
            logs.accept(logPos, this.log);
        }
        for (height = 3; height <= 5; ++height) {
            logPos = pos.m_6630_(height).m_7918_(right, 0, 0);
            logs.accept(logPos, this.log);
        }
        for (height = 5; height <= 8; ++height) {
            logPos = pos.m_6630_(height).m_7918_(right, 0, front);
            logs.accept(logPos, this.log);
        }
        int topHeight = 8;
        BlockPos topPos = pos.m_7918_(right, topHeight, front);
        logs.accept(topPos.m_7918_(0, 0, front), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(0, 0, front * 2), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(right, -1, front * 3), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(right, -1, front * 4), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(right, -2, front * 5), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(left, 0, 0), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(left * 2, 0, 0), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(left * 3, 0, front), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(left * 4, 0, front), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(left * 5, -1, front * 2), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(left, 0, back), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(left, 0, back * 2), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(left * 2, 0, back * 3), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(left * 2, 0, back * 4), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(left * 2, -1, back * 5), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z));
        logs.accept(topPos.m_7918_(right, 0, 0), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(right * 2, 0, 0), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(right * 3, 0, back), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(right * 4, 0, back), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
        logs.accept(topPos.m_7918_(right * 5, -1, back), (BlockState)this.log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X));
    }

    private void generateLeavesTop(BiConsumer<BlockPos, BlockState> leaves, BlockPos pos) {
        int x;
        int x2;
        int x3;
        int left = 1;
        int right = -1;
        int front = -1;
        int back = 1;
        int leavesHeight = 9;
        BlockPos topPos1 = pos.m_7918_(right, leavesHeight, front);
        leaves.accept(topPos1.m_7918_(0, 0, 0), this.leaves);
        leaves.accept(topPos1.m_7918_(0, 0, front), this.leaves);
        leaves.accept(topPos1.m_7918_(0, 0, front * 2), this.leaves);
        leaves.accept(topPos1.m_7918_(left, 0, 0), this.leaves);
        leaves.accept(topPos1.m_7918_(left * 2, 0, 0), this.leaves);
        leaves.accept(topPos1.m_7918_(left * 3, 0, front), this.leaves);
        leaves.accept(topPos1.m_7918_(left * 4, 0, front), this.leaves);
        leaves.accept(topPos1.m_7918_(0, 0, back), this.leaves);
        leaves.accept(topPos1.m_7918_(0, 0, back * 2), this.leaves);
        leaves.accept(topPos1.m_7918_(0, 0, back * 3), this.leaves);
        leaves.accept(topPos1.m_7918_(left, 0, back), this.leaves);
        leaves.accept(topPos1.m_7918_(left, 0, back * 2), this.leaves);
        leaves.accept(topPos1.m_7918_(left, 0, back * 3), this.leaves);
        leaves.accept(topPos1.m_7918_(left * 2, 0, back * 3), this.leaves);
        leaves.accept(topPos1.m_7918_(left * 2, 0, back * 4), this.leaves);
        leaves.accept(topPos1.m_7918_(right, 0, 0), this.leaves);
        leaves.accept(topPos1.m_7918_(right * 2, 0, 0), this.leaves);
        leaves.accept(topPos1.m_7918_(right * 2, 0, back), this.leaves);
        leaves.accept(topPos1.m_7918_(right * 3, 0, back), this.leaves);
        leaves.accept(topPos1.m_7918_(right * 4, 0, back), this.leaves);
        leaves.accept(topPos1.m_7918_(right, 0, back), this.leaves);
        leaves.accept(topPos1.m_7918_(right, 0, back * 2), this.leaves);
        leaves.accept(topPos1.m_7918_(right, 0, front), this.leaves);
        leaves.accept(topPos1.m_7918_(right, 0, front * 2), this.leaves);
        BlockPos topPos2 = pos.m_7918_(right, leavesHeight - 1, front);
        leaves.accept(topPos2.m_7918_(left, 0, back * 3), this.leaves);
        leaves.accept(topPos2.m_7918_(left, 0, back * 4), this.leaves);
        for (x3 = 1; x3 <= 4; ++x3) {
            leaves.accept(topPos2.m_7918_(0, 0, back * x3), this.leaves);
        }
        for (x3 = 1; x3 <= 3; ++x3) {
            leaves.accept(topPos2.m_7918_(right, 0, back * x3), this.leaves);
        }
        leaves.accept(topPos2.m_7918_(right * 2, 0, back), this.leaves);
        leaves.accept(topPos2.m_7918_(right * 2, 0, back * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(right * 3, 0, back * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(right * 4, 0, back * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(right * 3, 0, 0), this.leaves);
        leaves.accept(topPos2.m_7918_(right * 4, 0, 0), this.leaves);
        leaves.accept(topPos2.m_7918_(right * 5, 0, back), this.leaves);
        leaves.accept(topPos2.m_7918_(right * 2, 0, front), this.leaves);
        leaves.accept(topPos2.m_7918_(right * 2, 0, front * 2), this.leaves);
        for (x3 = 1; x3 <= 4; ++x3) {
            leaves.accept(topPos2.m_7918_(right, 0, front * x3), this.leaves);
        }
        leaves.accept(topPos2.m_7918_(0, 0, front * 3), this.leaves);
        leaves.accept(topPos2.m_7918_(left, 0, front), this.leaves);
        leaves.accept(topPos2.m_7918_(left, 0, front * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 2, 0, front), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 3, 0, front * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 4, 0, front * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 5, 0, front * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 5, 0, front), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 3, 0, 0), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 4, 0, 0), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 2, 0, back), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 2, 0, back * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 3, 0, back * 2), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 3, 0, back * 3), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 3, 0, back * 4), this.leaves);
        leaves.accept(topPos2.m_7918_(left * 2, 0, back * 5), this.leaves);
        BlockPos topPos3 = pos.m_7918_(right, leavesHeight - 2, front);
        for (x2 = 1; x2 <= 4; ++x2) {
            leaves.accept(topPos3.m_7918_(0, 0, back * x2), this.leaves);
        }
        for (x2 = -2; x2 <= 4; ++x2) {
            leaves.accept(topPos3.m_7918_(right, 0, back * x2), this.leaves);
        }
        for (x2 = -4; x2 <= 3; ++x2) {
            leaves.accept(topPos3.m_7918_(right * 2, 0, back * x2), this.leaves);
        }
        for (x2 = -1; x2 <= 2; ++x2) {
            leaves.accept(topPos3.m_7918_(right * 3, 0, back * x2), this.leaves);
        }
        for (x2 = 0; x2 <= 2; ++x2) {
            leaves.accept(topPos3.m_7918_(right * 4, 0, back * x2), this.leaves);
        }
        leaves.accept(topPos3.m_7918_(right * 5, 0, 0), this.leaves);
        leaves.accept(topPos3.m_7918_(right * 5, 0, back * 2), this.leaves);
        leaves.accept(topPos3.m_7918_(right * 6, 0, back), this.leaves);
        for (x2 = 1; x2 <= 4; ++x2) {
            leaves.accept(topPos3.m_7918_(0, 0, front * x2), this.leaves);
        }
        leaves.accept(topPos3.m_7918_(right, 0, front * 5), this.leaves);
        leaves.accept(topPos3.m_7918_(left, 0, front * 2), this.leaves);
        for (x2 = 2; x2 <= 5; ++x2) {
            leaves.accept(topPos3.m_7918_(left * x2, 0, front), this.leaves);
        }
        leaves.accept(topPos3.m_7918_(left * 3, 0, front * 2), this.leaves);
        leaves.accept(topPos3.m_7918_(left * 4, 0, front * 2), this.leaves);
        leaves.accept(topPos3.m_7918_(left * 6, 0, front * 2), this.leaves);
        leaves.accept(topPos3.m_7918_(left * 5, 0, front * 3), this.leaves);
        leaves.accept(topPos3.m_7918_(left, 0, 0), this.leaves);
        leaves.accept(topPos3.m_7918_(left * 2, 0, 0), this.leaves);
        leaves.accept(topPos3.m_7918_(left * 4, 0, 0), this.leaves);
        for (x2 = 1; x2 <= 5; ++x2) {
            leaves.accept(topPos3.m_7918_(left * 3, 0, back * x2), this.leaves);
        }
        for (x2 = 1; x2 <= 4; ++x2) {
            leaves.accept(topPos3.m_7918_(left * 2, 0, back * x2), this.leaves);
        }
        leaves.accept(topPos3.m_7918_(left * 2, 0, back * 6), this.leaves);
        for (x2 = 1; x2 <= 5; ++x2) {
            leaves.accept(topPos3.m_7918_(left, 0, back * x2), this.leaves);
        }
        BlockPos topPos4 = pos.m_7918_(right, leavesHeight - 3, front);
        leaves.accept(topPos4.m_7918_(right, 0, 0), this.leaves);
        for (x = 0; x >= -3; --x) {
            leaves.accept(topPos4.m_7918_(right, x, back * 4), this.leaves);
        }
        leaves.accept(topPos4.m_7918_(right, 0, back * 3), this.leaves);
        leaves.accept(topPos4.m_7918_(right * 2, 0, back * 2), this.leaves);
        leaves.accept(topPos4.m_7918_(right * 2, 0, back * 3), this.leaves);
        leaves.accept(topPos4.m_7918_(right * 2, -1, back * 3), this.leaves);
        for (x = 0; x <= 3; ++x) {
            leaves.accept(topPos4.m_7918_(right * 3, 0, back * x), this.leaves);
        }
        leaves.accept(topPos4.m_7918_(right * 3, -1, back * 2), this.leaves);
        leaves.accept(topPos4.m_7918_(right * 3, -1, 0), this.leaves);
        leaves.accept(topPos4.m_7918_(right * 4, -1, back), this.leaves);
        for (x = 0; x <= 2; ++x) {
            leaves.accept(topPos4.m_7918_(right * 4, 0, back * x), this.leaves);
        }
        for (x = 0; x >= -3; --x) {
            leaves.accept(topPos4.m_7918_(right * 5, x, 0), this.leaves);
        }
        for (x = 0; x >= -3; --x) {
            leaves.accept(topPos4.m_7918_(right * 6, x, back), this.leaves);
        }
        for (x = 0; x >= -2; --x) {
            leaves.accept(topPos4.m_7918_(right * 5, x, back * 2), this.leaves);
        }
        for (x = 0; x >= -2; --x) {
            leaves.accept(topPos4.m_7918_(right * 2, x, front), this.leaves);
        }
        for (x = 0; x >= -3; --x) {
            leaves.accept(topPos4.m_7918_(right * 2, x, front * 3), this.leaves);
        }
        for (x = 0; x >= -1; --x) {
            leaves.accept(topPos4.m_7918_(right * 2, x, front * 4), this.leaves);
        }
        for (x = 0; x >= -3; --x) {
            leaves.accept(topPos4.m_7918_(right * 2, x, front * 5), this.leaves);
        }
        for (x = 0; x >= -4; --x) {
            leaves.accept(topPos4.m_7918_(right, x, front * 6), this.leaves);
        }
        for (x = 0; x >= -2; --x) {
            leaves.accept(topPos4.m_7918_(right, x, front * 4), this.leaves);
        }
        for (x = 0; x >= -1; --x) {
            leaves.accept(topPos4.m_7918_(right, x, front * 2), this.leaves);
        }
        leaves.accept(topPos4.m_7918_(0, 0, front * 3), this.leaves);
        for (x = 0; x >= -1; --x) {
            leaves.accept(topPos4.m_7918_(0, x, front * 4), this.leaves);
        }
        for (x = 0; x >= -2; --x) {
            leaves.accept(topPos4.m_7918_(0, x, front * 5), this.leaves);
        }
        leaves.accept(topPos4.m_7918_(left, 0, front * 2), this.leaves);
        for (x = 0; x >= -2; --x) {
            leaves.accept(topPos4.m_7918_(left * 2, x, front), this.leaves);
        }
        for (x = 0; x >= -1; --x) {
            leaves.accept(topPos4.m_7918_(left * 3, x, front * 2), this.leaves);
        }
        leaves.accept(topPos4.m_7918_(left * 4, 0, front * 2), this.leaves);
        for (x = 0; x >= -2; --x) {
            leaves.accept(topPos4.m_7918_(left * 4, x, front * 3), this.leaves);
        }
        for (x = 0; x >= -1; --x) {
            leaves.accept(topPos4.m_7918_(left * 5, x, front * 3), this.leaves);
        }
        for (x = 0; x >= -2; --x) {
            leaves.accept(topPos4.m_7918_(left * 6, x, front * 2), this.leaves);
        }
        for (x = 0; x >= -3; --x) {
            leaves.accept(topPos4.m_7918_(left * 5, x, front), this.leaves);
        }
        leaves.accept(topPos4.m_7918_(left * 4, 0, 0), this.leaves);
        for (x = 0; x <= 5; ++x) {
            leaves.accept(topPos4.m_7918_(left, 0, back * x), this.leaves);
        }
        for (x = 0; x >= -1; --x) {
            leaves.accept(topPos4.m_7918_(left * 3, x, back), this.leaves);
        }
        leaves.accept(topPos4.m_7918_(left * 3, 0, back * 3), this.leaves);
        for (x = 0; x >= -1; --x) {
            leaves.accept(topPos4.m_7918_(left * 3, x, back * 4), this.leaves);
        }
        for (x = 0; x >= -2; --x) {
            leaves.accept(topPos4.m_7918_(left * 3, x, back * 5), this.leaves);
        }
        for (x = 0; x >= -3; --x) {
            leaves.accept(topPos4.m_7918_(left * 2, x, back * 6), this.leaves);
        }
        leaves.accept(topPos4.m_7918_(left * 2, 0, back * 4), this.leaves);
        leaves.accept(topPos4.m_7918_(left, -1, back), this.leaves);
        leaves.accept(topPos4.m_7918_(left, -1, back * 3), this.leaves);
        leaves.accept(topPos4.m_7918_(left, -1, back * 5), this.leaves);
        leaves.accept(topPos4.m_7918_(0, 0, back * 4), this.leaves);
    }

    private void addVines(WorldGenLevel world, RandomSource rand, BlockPos startPos, int baseHeight, int height, int leavesRadius, int generationAttempts) {
        block0: for (int i = 0; i < generationAttempts; ++i) {
            Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
            Direction back = direction.m_122424_();
            Direction sideways = direction.m_122427_();
            BlockPos pos = startPos.m_6630_(BDBMathUtil.nextIntBetween(rand, baseHeight + 1, height)).m_5484_(direction, leavesRadius + 1).m_5484_(sideways, BDBMathUtil.nextIntBetween(rand, -leavesRadius, leavesRadius));
            for (int l = 0; l < leavesRadius; ++l) {
                if (world.m_8055_(pos.m_5484_(back, 1 + l)) != this.leaves) continue;
                this.setVine((LevelAccessor)world, rand, pos.m_5484_(back, l), back, 4);
                continue block0;
            }
        }
    }

    private boolean setVine(LevelAccessor world, RandomSource rand, BlockPos pos, Direction side, int length) {
        BlockState vineBlockState = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(side == Direction.NORTH))).m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(side == Direction.EAST))).m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(side == Direction.SOUTH))).m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(side == Direction.WEST));
        boolean generateVine = false;
        while (world.m_8055_(pos).m_60795_() && length > 0 && rand.m_188503_(12) > 0) {
            this.m_5974_((LevelWriter)world, pos, vineBlockState);
            generateVine = true;
            --length;
            pos = pos.m_7495_();
        }
        return generateVine;
    }

    private void replaceGround(LevelAccessor world, BlockPos pos) {
        int radius = 3;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos changedPosition = pos.m_7918_(x, -1 + y, z);
                    if (!world.m_8055_(changedPosition).m_204336_(BDBTags.Blocks.SWAMP_WILLOW_TREE_REPLACEABLES)) continue;
                    int randomChance = (Math.abs(x) + Math.abs(z)) / 2 + 1;
                    if (world.m_213780_().m_188503_(randomChance) == 0) {
                        world.m_7731_(changedPosition, Blocks.f_50546_.m_49966_(), 19);
                    }
                    if (world.m_213780_().m_188503_(randomChance * 4) != 0) continue;
                    world.m_7731_(changedPosition, Blocks.f_50599_.m_49966_(), 19);
                }
            }
        }
    }
}

