/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.generation.feature.tree;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.util.BDBMathUtil;
import xratedjunior.betterdefaultbiomes.world.generation.feature.tree.TreeFeatureBDB;

public class PalmTreeFeature
extends TreeFeatureBDB {
    protected BlockState log = ((Block)BDBBlocks.PALM_LOG.get()).m_49966_();
    protected BlockState leaves = ((Block)BDBBlocks.PALM_LEAVES.get()).m_49966_();
    protected int minTreeHeight = 8;
    protected int maxTreeHeight = 12;

    public PalmTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    protected boolean createTree(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> logs, BiConsumer<BlockPos, BlockState> leaves) {
        int height = BDBMathUtil.nextIntBetween(random, this.minTreeHeight, this.maxTreeHeight);
        int leavesRadius = 1;
        int heightMinusTop = height - leavesRadius - 1;
        boolean slant = true;
        Direction direction = Direction.m_235672_((RandomSource)random);
        if (direction == Direction.DOWN || direction == Direction.UP) {
            slant = false;
        }
        double baseSlant = (double)random.m_188503_(35) / 100.0;
        double slantMultiplier = 1.3;
        if (height < 6) {
            return false;
        }
        BlockPos pos = startPos;
        if (!this.checkSpace(world, pos, height, 1)) {
            return false;
        }
        double slantOffset = baseSlant;
        for (int step = 0; step <= heightMinusTop; ++step) {
            BlockPos offsetPos = pos.m_6630_(step);
            if (slant) {
                offsetPos = pos.m_6630_(step).m_5484_(direction, (int)Math.floor(slantOffset));
            }
            if (step == heightMinusTop) {
                logs.accept(offsetPos, this.log);
                this.generateLeavesTop(leaves, offsetPos);
                break;
            }
            logs.accept(offsetPos, this.log);
            slantOffset *= slantMultiplier;
        }
        return true;
    }

    private void generateLeavesTop(BiConsumer<BlockPos, BlockState> leaves, BlockPos pos) {
        leaves.accept(pos.m_7918_(0, 1, 0), this.leaves);
        leaves.accept(pos.m_7918_(1, 1, 0), this.leaves);
        leaves.accept(pos.m_7918_(-1, 1, 0), this.leaves);
        leaves.accept(pos.m_7918_(0, 1, 1), this.leaves);
        leaves.accept(pos.m_7918_(0, 1, -1), this.leaves);
        leaves.accept(pos.m_7918_(1, 0, 0), this.leaves);
        leaves.accept(pos.m_7918_(-1, 0, 0), this.leaves);
        leaves.accept(pos.m_7918_(0, 0, 1), this.leaves);
        leaves.accept(pos.m_7918_(0, 0, -1), this.leaves);
        leaves.accept(pos.m_7918_(1, 0, 1), this.leaves);
        leaves.accept(pos.m_7918_(1, 0, -1), this.leaves);
        leaves.accept(pos.m_7918_(-1, 0, 1), this.leaves);
        leaves.accept(pos.m_7918_(-1, 0, -1), this.leaves);
        leaves.accept(pos.m_7918_(2, 0, 0), this.leaves);
        leaves.accept(pos.m_7918_(-2, 0, 0), this.leaves);
        leaves.accept(pos.m_7918_(0, 0, 2), this.leaves);
        leaves.accept(pos.m_7918_(0, 0, -2), this.leaves);
        leaves.accept(pos.m_7918_(3, 0, 0), this.leaves);
        leaves.accept(pos.m_7918_(-3, 0, 0), this.leaves);
        leaves.accept(pos.m_7918_(0, 0, 3), this.leaves);
        leaves.accept(pos.m_7918_(0, 0, -3), this.leaves);
        leaves.accept(pos.m_7918_(4, -1, 0), this.leaves);
        leaves.accept(pos.m_7918_(-4, -1, 0), this.leaves);
        leaves.accept(pos.m_7918_(0, -1, 4), this.leaves);
        leaves.accept(pos.m_7918_(0, -1, -4), this.leaves);
        leaves.accept(pos.m_7918_(2, 0, 2), this.leaves);
        leaves.accept(pos.m_7918_(2, 0, -2), this.leaves);
        leaves.accept(pos.m_7918_(-2, 0, 2), this.leaves);
        leaves.accept(pos.m_7918_(-2, 0, -2), this.leaves);
        leaves.accept(pos.m_7918_(3, -1, 3), this.leaves);
        leaves.accept(pos.m_7918_(3, -1, -3), this.leaves);
        leaves.accept(pos.m_7918_(-3, -1, 3), this.leaves);
        leaves.accept(pos.m_7918_(-3, -1, -3), this.leaves);
    }
}

