/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.generation.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.block.block.SmallRockBlock;
import xratedjunior.betterdefaultbiomes.world.generation.feature.configurations.SmallRockConfiguration;

public class SmallRockFeature
extends Feature<SmallRockConfiguration> {
    public SmallRockFeature(Codec<SmallRockConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SmallRockConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        if (!worldgenlevel.m_46859_(pos) && !worldgenlevel.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        return this.placeSmallRock(worldgenlevel, (SmallRockConfiguration)context.m_159778_(), context.m_225041_(), pos);
    }

    protected boolean placeSmallRock(WorldGenLevel world, SmallRockConfiguration config, RandomSource rand, BlockPos blockpos) {
        if (config.getAllPossibleVariants().isEmpty()) {
            return false;
        }
        Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(rand);
        int randomRockSize = rand.m_188503_(2) + 1;
        boolean waterlogged = false;
        Block floorBlock = world.m_8055_(blockpos.m_7495_()).m_60734_();
        BlockState smallRockBlock = SmallRockFeature.getMatchingRockVariant(floorBlock, config).m_49966_();
        if (smallRockBlock.m_60734_() == SmallRockBlock.RockVariant.DEFAULT_VARIANT.getSmallRockBlock() && rand.m_188503_(5) == 0 && SmallRockBlock.RockVariant.STONE_VARIANTS.length != 0) {
            smallRockBlock = SmallRockFeature.getRandomStoneVariant(rand, config).m_49966_();
        }
        if (smallRockBlock.m_60710_((LevelReader)world, blockpos)) {
            if (world.m_8055_(blockpos).m_60713_(Blocks.f_49990_)) {
                if (rand.m_188503_(3) == 0) {
                    smallRockBlock = ((Block)BDBBlocks.SMALL_ROCK_MOSSY.get()).m_49966_();
                }
                waterlogged = true;
            } else if (!world.m_46859_(blockpos)) {
                return false;
            }
            world.m_7731_(blockpos, (BlockState)((BlockState)((BlockState)smallRockBlock.m_61124_((Property)SmallRockBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_((Property)SmallRockBlock.f_54117_, (Comparable)randomDirection)).m_61124_((Property)SmallRockBlock.ROCK_SIZE, (Comparable)Integer.valueOf(randomRockSize)), 2);
            return true;
        }
        return false;
    }

    private static Block getRandomStoneVariant(RandomSource rand, SmallRockConfiguration config) {
        return ((SmallRockBlock.RockVariant)((Object)Util.m_214621_(config.getPossibleStoneVariants(), (RandomSource)rand))).getSmallRockBlock();
    }

    private static Block getMatchingRockVariant(Block groundBlock, SmallRockConfiguration config) {
        List<Block> matchingVariants = SmallRockFeature.getMatchingRockVariants(groundBlock, config);
        RandomSource random = RandomSource.m_216327_();
        return !matchingVariants.isEmpty() ? (Block)Util.m_214621_(matchingVariants, (RandomSource)random) : config.getDefaultVariant().getSmallRockBlock();
    }

    private static List<Block> getMatchingRockVariants(Block groundBlock, SmallRockConfiguration config) {
        ArrayList<Block> matchingVariants = new ArrayList<Block>();
        for (SmallRockBlock.RockVariant variant : config.getAllPossibleVariants()) {
            if (!groundBlock.m_49966_().m_204336_(variant.getPossibleFloorBlocks())) continue;
            matchingVariants.add(variant.getSmallRockBlock());
        }
        return matchingVariants;
    }
}

