/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.biomemodifier;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.configuration.DebugConfig;
import xratedjunior.betterdefaultbiomes.configuration.MobSpawningConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.DuckConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.FrozenZombieConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.MuddyPigConfig;
import xratedjunior.betterdefaultbiomes.util.BDBHelper;
import xratedjunior.betterdefaultbiomes.world.BDBBiomeModifiers;

public record RemoveSpawnsWithConfig() implements BiomeModifier
{
    public static final Codec<RemoveSpawnsWithConfig> CODEC = Codec.unit(RemoveSpawnsWithConfig::new);
    private static Boolean REMOVE_SPAWNS_LOGGER = false;

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.REMOVE) {
            REMOVE_SPAWNS_LOGGER = (Boolean)DebugConfig.remove_vanilla_spawn_logger.get();
            MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
            for (MobCategory category : MobCategory.values()) {
                List spawns = spawnBuilder.getSpawner(category);
                spawns.removeIf(spawnerData -> {
                    if (RemoveSpawnsWithConfig.removeSpawn(biome, spawnerData, EntityType.f_20501_, (Boolean)FrozenZombieConfig.remove_vanilla_zombies.get(), (Boolean)MobSpawningConfig.spawn_frozen_zombie.get(), (List)FrozenZombieConfig.spawn_biomes.get(), REMOVE_SPAWNS_LOGGER)) {
                        return true;
                    }
                    if (RemoveSpawnsWithConfig.removeSpawn(biome, spawnerData, EntityType.f_20510_, (Boolean)MuddyPigConfig.remove_vanilla_pigs.get(), (Boolean)MobSpawningConfig.spawn_muddy_pig.get(), (List)MuddyPigConfig.spawn_biomes.get(), REMOVE_SPAWNS_LOGGER)) {
                        return true;
                    }
                    return RemoveSpawnsWithConfig.removeSpawn(biome, spawnerData, EntityType.f_20555_, (Boolean)DuckConfig.remove_vanilla_chickens.get(), (Boolean)MobSpawningConfig.spawn_duck.get(), (List)DuckConfig.spawn_biomes.get(), REMOVE_SPAWNS_LOGGER);
                });
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)BDBBiomeModifiers.REMOVE_SPAWNS_CODEC.get();
    }

    private static boolean removeSpawn(Holder<Biome> biome, MobSpawnSettings.SpawnerData spawnerData, EntityType<?> entityType, boolean removeMob, boolean spawnBDB, List<String> spawn_biomes, boolean logger) {
        return RemoveSpawnsWithConfig.removeMobSpawn(biome, spawnerData, entityType, removeMob, spawnBDB, spawn_biomes, logger);
    }

    private static boolean removeMobSpawn(Holder<Biome> biome, MobSpawnSettings.SpawnerData spawnerData, EntityType<?> entityType, boolean removeMob, boolean spawnBDB, List<String> spawn_biomes, boolean logger) {
        if (removeMob && spawnBDB && BDBHelper.matchBiomeOrTag(biome, spawn_biomes) && entityType.equals(((Holder)ForgeRegistries.ENTITY_TYPES.getHolder((Object)spawnerData.f_48404_).get()).get())) {
            if (logger) {
                String entityName = entityType.m_147048_().toUpperCase();
                BetterDefaultBiomes.LOGGER.info("Removed \"" + entityName.toUpperCase() + "\" Spawning in: " + ((ResourceKey)biome.m_203543_().get()).m_135782_().toString());
            }
            return true;
        }
        return false;
    }
}

