/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.hostile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditEntity;

public abstract class AbstractHostileHumanoid
extends Monster
implements RangedAttackMob,
CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CROSSBOW_CHARGING_STATE = SynchedEntityData.m_135353_(AbstractHostileHumanoid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float CROSSBOW_POWER = 1.6f;
    protected final RangedBowAttackGoal<AbstractHostileHumanoid> bowGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f);
    protected final RangedCrossbowAttackGoal<AbstractHostileHumanoid> crossbowGoal = new RangedCrossbowAttackGoal((Monster)this, 1.0, 8.0f);
    protected final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false);

    protected AbstractHostileHumanoid(EntityType<? extends AbstractHostileHumanoid> type, Level worldIn) {
        super(type, worldIn);
        this.reassessCombatGoal();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CROSSBOW_CHARGING_STATE, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.reassessCombatGoal();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{DesertBanditEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void reassessWeaponGoal(int hardDifficultyAttackInterval, int attackInterval) {
        if (this.m_9236_() != null && !this.m_9236_().m_5776_()) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            this.f_21345_.m_25363_(this.crossbowGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (itemstack.m_150930_(Items.f_42411_)) {
                int ticksInterval = hardDifficultyAttackInterval;
                if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                    ticksInterval = attackInterval;
                }
                this.bowGoal.m_25797_(ticksInterval);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else if (this.m_21093_(itemStack -> itemStack.m_41720_() instanceof CrossbowItem)) {
                this.f_21345_.m_25352_(4, this.crossbowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    public void reassessCombatGoal() {
        this.reassessWeaponGoal(20, 40);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.m_21093_(itemStack -> itemStack.m_41720_() instanceof CrossbowItem)) {
            this.m_32336_((LivingEntity)this, 1.6f);
        } else {
            ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
            AbstractArrow abstractarrowentity = this.getArrow(itemstack, distanceFactor);
            if (this.m_21205_().m_41720_() instanceof BowItem) {
                abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
            }
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - abstractarrowentity.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_9236_().m_7967_((Entity)abstractarrowentity);
        }
    }

    public boolean m_5886_(ProjectileWeaponItem itemInHand) {
        return itemInHand instanceof CrossbowItem || itemInHand instanceof BowItem;
    }

    protected abstract AbstractArrow getArrow(ItemStack var1, float var2);

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == this.m_6336_()) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_5811_(LivingEntity livingEntity, ItemStack itemStack, Projectile projectileEntity, float p_230284_4_) {
        this.m_32322_((LivingEntity)this, livingEntity, projectileEntity, p_230284_4_, 1.6f);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6136_(boolean isCharging) {
        this.f_19804_.m_135381_(DATA_CROSSBOW_CHARGING_STATE, (Object)isCharging);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CROSSBOW_CHARGING_STATE);
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.m_20202_() instanceof PathfinderMob) {
            PathfinderMob creatureentity = (PathfinderMob)this.m_20202_();
            this.f_20883_ = creatureentity.f_20883_;
        }
    }

    public static AttributeSupplier.Builder createHumanoidAttributes() {
        return AbstractHostileHumanoid.m_33035_().m_22268_(Attributes.f_22279_, 0.25);
    }

    public abstract MobType m_6336_();

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.74f;
    }

    public double m_6049_() {
        return -0.7f;
    }

    public static boolean checkHostileSpawnRules(EntityType<? extends AbstractHostileHumanoid> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Monster.m_219019_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_213945_(worldIn.m_213780_(), difficultyIn);
        this.m_213946_(worldIn.m_213780_(), difficultyIn);
        this.reassessCombatGoal();
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * difficultyIn.m_19057_());
        return spawnDataIn;
    }

    protected void setDefaultEquipmentAndEnchants(DifficultyInstance difficulty) {
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.setDefaultEquipmentAndEnchants(difficulty);
        super.m_213945_(random, difficulty);
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        super.m_8061_(slotIn, stack);
        if (!this.m_9236_().m_5776_()) {
            this.reassessCombatGoal();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArmPose getArmPose() {
        if (this.m_21205_().m_41720_() instanceof BowItem && this.m_5912_()) {
            return ArmPose.BOW_AND_ARROW;
        }
        if (this.isChargingCrossbow()) {
            return ArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_21055_(Items.f_42717_)) {
            return ArmPose.CROSSBOW_HOLD;
        }
        return this.m_5912_() ? ArmPose.ATTACKING : ArmPose.NEUTRAL;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12624_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose {
        CROSSED,
        NEUTRAL,
        ATTACKING,
        BOW_AND_ARROW,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        SPELLCASTING,
        CELEBRATING;

    }
}

