/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.client.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.entity.client.model.util.BDBModelPart;

@OnlyIn(value=Dist.CLIENT)
public abstract class BDBEntityModel<E extends Entity>
extends EntityModel<E> {
    protected List<BDBModelPart> modelParts = new ArrayList<BDBModelPart>();

    public BDBEntityModel(Function<ResourceLocation, RenderType> renderType) {
        super(renderType);
    }

    protected BDBModelPart createModelPart(EntityModel<E> entityModel, ModelPart root, String partName) {
        return new BDBModelPart(this, root.m_171324_(partName));
    }

    protected BDBModelPart createModelPart(EntityModel<E> entityModel, BDBModelPart root, String partName) {
        return this.createModelPart(entityModel, root.getModelPart(), partName);
    }

    public void addModelPart(BDBModelPart modelPart) {
        this.modelParts.add(modelPart);
    }

    public void setDefaultModelValues() {
        this.modelParts.forEach(rendererModel -> {
            if (rendererModel instanceof BDBModelPart) {
                rendererModel.setDefaultModelValues();
            }
        });
    }

    public void revertToDefaultModelValues() {
        this.modelParts.forEach(rendererModel -> {
            if (rendererModel instanceof BDBModelPart) {
                rendererModel.getDefaultModelValues();
            }
        });
    }

    protected boolean isWalking(E entity) {
        return ((Entity)entity).f_19854_ != entity.m_20185_() || ((Entity)entity).f_19855_ != entity.m_20186_() || ((Entity)entity).f_19856_ != entity.m_20189_();
    }

    public void setRotationAngle(ModelPart modelPart, float xRot, float yRot, float zRot) {
        modelPart.f_104203_ = xRot;
        modelPart.f_104204_ = yRot;
        modelPart.f_104205_ = zRot;
    }

    protected float calculateRotationAngle(float speed, float degree, boolean invert, float delay, float limbSwing, float limbSwingAmount) {
        if (invert) {
            float rotation = Mth.m_14089_((float)(limbSwing * speed + ((float)Math.PI + delay))) * degree * limbSwingAmount;
            return rotation;
        }
        float rotation = Mth.m_14089_((float)(limbSwing * speed + delay)) * degree * limbSwingAmount;
        return rotation;
    }

    protected void rotateX(BDBModelPart modelPart, float speed, float degree, boolean invert, float delay, float limbSwing, float limbSwingAmount) {
        modelPart.getModelPart().f_104203_ += this.calculateRotationAngle(speed, degree, invert, delay, limbSwing, limbSwingAmount);
    }

    protected void rotateXPositive(BDBModelPart modelPart, float speed, float degree, boolean invert, float delay, float limbSwing, float limbSwingAmount) {
        modelPart.getModelPart().f_104203_ += Mth.m_14154_((float)this.calculateRotationAngle(speed, degree, invert, delay, limbSwing, limbSwingAmount));
    }

    public void rotateZ(BDBModelPart modelPart, float speed, float degree, boolean invert, float delay, float limbSwing, float limbSwingAmount) {
        modelPart.getModelPart().f_104205_ += this.calculateRotationAngle(speed, degree, invert, delay, limbSwing, limbSwingAmount);
    }

    public void shake(BDBModelPart modelPart, float speed, float degree, boolean invert, float delay, float weight, float limbSwing, float limbSwingAmount) {
        modelPart.getModelPart().f_104204_ += this.calculateRotationAngle(speed, degree, invert, delay, limbSwing, limbSwingAmount);
    }

    protected void bounce(BDBModelPart modelPart, float speed, float height, float delay, float limbSwing, float limbSwingAmount) {
        float bounce = (float)(Math.sin(limbSwing * speed + delay) * (double)limbSwingAmount * (double)height);
        modelPart.getModelPart().f_104201_ += Mth.m_14154_((float)bounce);
    }
}

