/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.client.model.passive;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.entity.client.model.util.BDBAgeableModel;
import xratedjunior.betterdefaultbiomes.entity.client.model.util.BDBModelPart;
import xratedjunior.betterdefaultbiomes.entity.passive.FrogEntity;

@OnlyIn(value=Dist.CLIENT)
public class FrogModel<E extends FrogEntity>
extends BDBAgeableModel<E> {
    private final BDBModelPart body_rp;
    private final BDBModelPart back_right_leg_rotation_point;
    private final BDBModelPart back_right_foot_rotation_point;
    private final BDBModelPart back_left_leg_rotation_point;
    private final BDBModelPart back_left_foot_rotation_point;
    private final BDBModelPart front_right_leg_rotation_point;
    private final BDBModelPart front_left_leg_rotation_point;
    private final BDBModelPart head_rotation_point;
    private final BDBModelPart tongue_rotation_point;
    private final BDBModelPart mouth_rotation_point;
    private float jumpRotation;

    public FrogModel(ModelPart context) {
        this.body_rp = new BDBModelPart(this, context.m_171324_("body_rp"));
        this.back_right_leg_rotation_point = new BDBModelPart(this, context.m_171324_("back_right_leg_rotation_point"));
        this.back_right_foot_rotation_point = new BDBModelPart(this, this.back_right_leg_rotation_point.getModelPart().m_171324_("back_right_foot_rotation_point"));
        this.back_left_leg_rotation_point = new BDBModelPart(this, context.m_171324_("back_left_leg_rotation_point"));
        this.back_left_foot_rotation_point = new BDBModelPart(this, this.back_left_leg_rotation_point.getModelPart().m_171324_("back_left_foot_rotation_point"));
        this.front_right_leg_rotation_point = new BDBModelPart(this, context.m_171324_("front_right_leg_rotation_point"));
        this.front_left_leg_rotation_point = new BDBModelPart(this, context.m_171324_("front_left_leg_rotation_point"));
        this.head_rotation_point = new BDBModelPart(this, context.m_171324_("head_rotation_point"));
        this.tongue_rotation_point = new BDBModelPart(this, this.head_rotation_point.getModelPart().m_171324_("tongue_rotation_point"));
        this.mouth_rotation_point = new BDBModelPart(this, this.head_rotation_point.getModelPart().m_171324_("mouth_rotation_point"));
        this.setDefaultModelValues();
    }

    public static LayerDefinition createBodyLayer(float scaleIn) {
        CubeDeformation scale = new CubeDeformation(scaleIn);
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body_rp", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -3.0f, -5.0f, 6.0f, 6.0f, 10.0f, scale), PartPose.m_171423_((float)0.0f, (float)19.0094f, (float)0.6577f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition back_right_leg_rotation_point = partdefinition.m_171599_("back_right_leg_rotation_point", CubeListBuilder.m_171558_().m_171514_(47, 24).m_171488_(-2.5f, -2.3095f, -1.8752f, 2.0f, 4.0f, 4.0f, scale), PartPose.m_171423_((float)-1.5f, (float)21.7095f, (float)3.1752f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        back_right_leg_rotation_point.m_171599_("back_right_foot_rotation_point", CubeListBuilder.m_171558_().m_171514_(47, 17).m_171488_(-1.0f, -0.5f, -4.0f, 2.0f, 1.0f, 5.0f, scale), PartPose.m_171423_((float)-1.5f, (float)1.7197f, (float)0.4758f, (float)0.48f, (float)0.3491f, (float)0.1745f));
        PartDefinition back_left_leg_rotation_point = partdefinition.m_171599_("back_left_leg_rotation_point", CubeListBuilder.m_171558_().m_171514_(34, 24).m_171488_(-2.5f, -2.3095f, -1.8752f, 2.0f, 4.0f, 4.0f, scale), PartPose.m_171423_((float)4.5f, (float)21.7095f, (float)3.1752f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        back_left_leg_rotation_point.m_171599_("back_left_foot_rotation_point", CubeListBuilder.m_171558_().m_171514_(32, 17).m_171488_(-1.0f, -0.5f, -4.0f, 2.0f, 1.0f, 5.0f, scale), PartPose.m_171423_((float)-1.5f, (float)1.7197f, (float)0.4758f, (float)0.48f, (float)-0.3491f, (float)-0.1745f));
        PartDefinition head_rotation_point = partdefinition.m_171599_("head_rotation_point", CubeListBuilder.m_171558_().m_171514_(22, 7).m_171488_(-3.5f, -6.0f, -2.5f, 2.0f, 2.0f, 2.0f, scale).m_171514_(2, 7).m_171488_(1.5f, -6.0f, -2.5f, 2.0f, 2.0f, 2.0f, scale).m_171514_(5, 6).m_171488_(-2.5f, -5.0f, -5.0f, 5.0f, 3.0f, 6.0f, scale), PartPose.m_171419_((float)0.0f, (float)19.5f, (float)-4.0f));
        head_rotation_point.m_171599_("tongue_rotation_point", CubeListBuilder.m_171558_().m_171514_(21, 10).m_171488_(-1.0f, 0.0f, -3.5f, 2.0f, 0.0f, 11.0f, scale), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-1.25f));
        head_rotation_point.m_171599_("mouth_rotation_point", CubeListBuilder.m_171558_().m_171514_(37, 10).m_171488_(-2.0f, -0.5f, -3.5f, 4.0f, 1.0f, 5.0f, scale), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-1.25f));
        partdefinition.m_171599_("front_right_leg_rotation_point", CubeListBuilder.m_171558_().m_171514_(1, 18).m_171488_(-0.25f, 0.0f, 0.25f, 2.0f, 5.0f, 2.0f, scale), PartPose.m_171419_((float)-3.0f, (float)19.0f, (float)-5.0f));
        partdefinition.m_171599_("front_left_leg_rotation_point", CubeListBuilder.m_171558_().m_171514_(23, 18).m_171488_(-0.25f, 0.0f, 0.25f, 2.0f, 5.0f, 2.0f, scale), PartPose.m_171419_((float)1.5f, (float)19.0f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
            matrixStack.m_85837_(0.0, 1.0, 0.0);
            ImmutableList.of((Object)this.body_rp, (Object)this.head_rotation_point, (Object)this.back_right_leg_rotation_point, (Object)this.back_left_leg_rotation_point, (Object)this.front_right_leg_rotation_point, (Object)this.front_left_leg_rotation_point).forEach(modelPart -> modelPart.getModelPart().m_104301_(matrixStack, buffer, packedLight, packedOverlay));
            matrixStack.m_85849_();
        } else {
            ImmutableList.of((Object)this.body_rp, (Object)this.head_rotation_point, (Object)this.back_right_leg_rotation_point, (Object)this.back_left_leg_rotation_point, (Object)this.front_right_leg_rotation_point, (Object)this.front_left_leg_rotation_point).forEach(modelPart -> modelPart.getModelPart().m_104301_(matrixStack, buffer, packedLight, packedOverlay));
        }
    }

    public void prepareMobModel(E entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
        this.revertToDefaultModelValues();
        float pi = (float)Math.PI;
        float radian = pi / 180.0f;
        float yawOffset = this.rotlerp(((FrogEntity)((Object)entity)).f_20884_, ((FrogEntity)((Object)entity)).f_20883_, partialTick);
        float yawRotation = this.rotlerp(((FrogEntity)((Object)entity)).f_20886_, ((FrogEntity)((Object)entity)).f_20885_, partialTick);
        float netHeadYaw = yawRotation - yawOffset;
        float headPitch = Mth.m_14179_((float)partialTick, (float)((FrogEntity)((Object)entity)).f_19860_, (float)entity.m_146909_());
        float headPitchDegrees = headPitch * ((float)Math.PI / 180);
        if (limbSwingAmount > 0.2f) {
            headPitchDegrees += Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount;
        }
        this.head_rotation_point.getModelPart().f_104204_ += netHeadYaw * radian / 4.0f;
        this.head_rotation_point.getModelPart().f_104203_ += headPitchDegrees * radian;
        float attackAnimation = Mth.m_14031_((float)(((FrogEntity)((Object)entity)).getAttackCompletion(partialTick) * pi));
        this.tongue_rotation_point.getModelPart().f_104202_ += attackAnimation * -5.0f;
        this.tongue_rotation_point.getModelPart().f_104203_ += attackAnimation * 15.0f * radian;
        this.mouth_rotation_point.getModelPart().f_104203_ += attackAnimation * 20.0f * radian;
        if (this.isWalking(entity)) {
            this.jumpRotation = Mth.m_14031_((float)(((FrogEntity)((Object)entity)).getJumpCompletion(partialTick) * pi));
            this.head_rotation_point.getModelPart().f_104203_ += this.jumpRotation * -5.0f * radian;
            this.mouth_rotation_point.getModelPart().f_104203_ += this.jumpRotation * 5.0f * radian;
            this.back_left_leg_rotation_point.getModelPart().f_104203_ += this.jumpRotation * 50.0f * radian;
            this.back_right_leg_rotation_point.getModelPart().f_104203_ += this.jumpRotation * 50.0f * radian;
            this.back_left_foot_rotation_point.getModelPart().f_104203_ += this.jumpRotation * 50.0f * radian;
            this.back_right_foot_rotation_point.getModelPart().f_104203_ += this.jumpRotation * 50.0f * radian;
            this.front_left_leg_rotation_point.getModelPart().f_104203_ += this.jumpRotation * -40.0f * radian;
            this.front_right_leg_rotation_point.getModelPart().f_104203_ += this.jumpRotation * -40.0f * radian;
        } else {
            limbSwing = ((FrogEntity)((Object)entity)).f_19797_;
            limbSwingAmount = 1.0f;
            float globalSpeed = 0.1f;
            float globalDegree = 0.4f;
            float globalHeight = 1.0f;
            this.bounce(this.body_rp, 0.75f * globalSpeed, 0.1f * globalHeight, 0.0f, limbSwing, limbSwingAmount);
            this.rotateX(this.head_rotation_point, 0.75f * globalSpeed, 0.05f * globalDegree, false, 0.0f, limbSwing, limbSwingAmount);
            this.rotateXPositive(this.mouth_rotation_point, globalSpeed * 0.25f, 0.08f * globalDegree, false, 0.5f, limbSwing, limbSwingAmount);
        }
    }

    @Override
    protected Iterable<ModelPart> headParts() {
        return null;
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return null;
    }
}

