/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.enchantment.enchantment;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import xratedjunior.betterdefaultbiomes.configuration.EnchantmentConfig;
import xratedjunior.betterdefaultbiomes.enchantment.util.CustomEnchantmentType;

public class HorseProtectionEnchantment
extends Enchantment {
    public final Type protectionType;

    public HorseProtectionEnchantment(Type protectionType, Enchantment.Rarity rarity) {
        super(rarity, CustomEnchantmentType.HORSE_ARMOR, new EquipmentSlot[]{EquipmentSlot.CHEST});
        this.protectionType = protectionType;
    }

    public int m_6183_(int enchantmentLevel) {
        return this.protectionType.getMinimalEnchantability() + (enchantmentLevel - 1) * this.protectionType.getEnchantIncreasePerLevel();
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + this.protectionType.getEnchantIncreasePerLevel();
    }

    public int m_6586_() {
        return 4;
    }

    public boolean m_5975_(Enchantment enchantment) {
        if (enchantment instanceof HorseProtectionEnchantment) {
            HorseProtectionEnchantment horseTestEnchantment = (HorseProtectionEnchantment)enchantment;
            if (this.protectionType == horseTestEnchantment.protectionType) {
                return false;
            }
            return this.protectionType == Type.FALL || horseTestEnchantment.protectionType == Type.FALL;
        }
        return super.m_5975_(enchantment);
    }

    public boolean m_6081_(ItemStack stack) {
        return (Boolean)EnchantmentConfig.horse_protection.get() != false && super.m_6081_(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)EnchantmentConfig.horse_protection.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)EnchantmentConfig.horse_protection.get();
    }

    public boolean m_6592_() {
        return (Boolean)EnchantmentConfig.horse_protection.get();
    }

    public static enum Type {
        ALL("all", 1, 11),
        FIRE("fire", 10, 8),
        FALL("fall", 5, 6),
        EXPLOSION("explosion", 5, 8),
        PROJECTILE("projectile", 3, 6);

        private final String typeName;
        private final int minEnchantability;
        private final int levelCost;

        private Type(String typeName, int minEnchantability, int levelCost) {
            this.typeName = typeName;
            this.minEnchantability = minEnchantability;
            this.levelCost = levelCost;
        }

        public int getMinimalEnchantability() {
            return this.minEnchantability;
        }

        public int getEnchantIncreasePerLevel() {
            return this.levelCost;
        }
    }
}

