/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.datagen.providers;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.block.block.StarfishBlock;

public class BDBBlockStateProvider
extends BlockStateProvider {
    public BDBBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "betterdefaultbiomes", exFileHelper);
    }

    protected void registerStatesAndModels() {
        BetterDefaultBiomes.LOGGER.info("Generating Block States and Models");
        this.generateStarfishBlocks();
    }

    private void generateStarfishBlocks() {
        this.starfishBlock((Block)BDBBlocks.STARFISH_WHITE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_ORANGE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_MAGENTA.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_LIGHT_BLUE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_YELLOW.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_LIME.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_PINK.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_GRAY.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_LIGHT_GRAY.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_CYAN.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_PURPLE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_BLUE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_BROWN.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_GREEN.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_RED.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_BLACK.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_WHITE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_ORANGE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_MAGENTA.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_LIGHT_BLUE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_YELLOW.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_LIME.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_PINK.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_GRAY.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_LIGHT_GRAY.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_CYAN.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_PURPLE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_BLUE.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_BROWN.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_GREEN.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_RED.get());
        this.starfishBlock((Block)BDBBlocks.STARFISH_WALL_BLACK.get());
    }

    private void starfishBlock(Block starfish) {
        String starfishName = ForgeRegistries.BLOCKS.getKey((Object)starfish).m_135815_().replace("wall_", "");
        String starfishColor = starfishName.replace("starfish_", "");
        BlockModelBuilder floor = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.setBlockName(starfishName), this.modLoc("block/starfish_template"))).texture("texture", this.mcLoc("block/" + starfishColor + "_wool"));
        this.makeBlockItemFromExistingModel(starfish, starfishName);
        starfishName = starfishName.replace("starfish_", "starfish_wall_");
        ModelBuilder wall_up = ((BlockModelBuilder)this.models().withExistingParent(this.setBlockName(starfishName.concat("_up")), this.modLoc("block/starfish_template_up"))).texture("texture", this.mcLoc("block/" + starfishColor + "_wool"));
        ModelBuilder wall_right = ((BlockModelBuilder)this.models().withExistingParent(this.setBlockName(starfishName.concat("_right")), this.modLoc("block/starfish_template_right"))).texture("texture", this.mcLoc("block/" + starfishColor + "_wool"));
        ModelBuilder wall_left = ((BlockModelBuilder)this.models().withExistingParent(this.setBlockName(starfishName.concat("_left")), this.modLoc("block/starfish_template_left"))).texture("texture", this.mcLoc("block/" + starfishColor + "_wool"));
        this.getVariantBuilder(starfish).forAllStatesExcept(arg_0 -> BDBBlockStateProvider.lambda$starfishBlock$0((ModelFile)wall_up, (ModelFile)wall_right, (ModelFile)wall_left, floor, arg_0), new Property[]{StarfishBlock.LIT, StarfishBlock.WATERLOGGED});
    }

    private String setBlockName(String blockName) {
        return BetterDefaultBiomes.find("block/" + blockName);
    }

    private void makeBlockItemFromExistingModel(Block block, String name) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc(name));
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$starfishBlock$0(ModelFile wall_up, ModelFile wall_right, ModelFile wall_left, BlockModelBuilder floor, BlockState includeState) {
        AttachFace face = (AttachFace)includeState.m_61143_((Property)StarfishBlock.f_53179_);
        Direction facing = (Direction)includeState.m_61143_((Property)StarfishBlock.f_54117_);
        int y = 0;
        int x = 0;
        switch (face) {
            default: {
                x = 90;
                if (facing.equals((Object)Direction.EAST)) {
                    y = 90;
                    break;
                }
                if (facing.equals((Object)Direction.SOUTH)) {
                    y = 180;
                    break;
                }
                if (!facing.equals((Object)Direction.WEST)) break;
                y = 270;
                break;
            }
            case FLOOR: {
                if (facing.equals((Object)Direction.WEST)) {
                    y = 90;
                    break;
                }
                if (facing.equals((Object)Direction.NORTH)) {
                    y = 180;
                    break;
                }
                if (!facing.equals((Object)Direction.EAST)) break;
                y = 270;
                break;
            }
            case CEILING: {
                x = 180;
                if (facing.equals((Object)Direction.EAST)) {
                    y = 90;
                    break;
                }
                if (facing.equals((Object)Direction.SOUTH)) {
                    y = 180;
                    break;
                }
                if (!facing.equals((Object)Direction.WEST)) break;
                y = 270;
            }
        }
        StarfishBlock.WallFacing wallFacing = (StarfishBlock.WallFacing)((Object)includeState.m_61143_(StarfishBlock.WALL_FACING));
        return ConfiguredModel.builder().modelFile((ModelFile)(wallFacing == StarfishBlock.WallFacing.UP ? wall_up : (wallFacing == StarfishBlock.WallFacing.RIGHT ? wall_right : (wallFacing == StarfishBlock.WallFacing.LEFT ? wall_left : floor)))).rotationY(y).rotationX(x).build();
    }
}

