/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.block.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.sound.BDBSoundEvents;

public class SimpleBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SAND_CASTLE = SimpleBlock.makeSquareShape(2.5, 9.0);
    private static final VoxelShape SEASHELL = SimpleBlock.makeSquareShape(3.5, 1.5);

    public SimpleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected static VoxelShape makeSquareShape(double widthPixelOffset, double yPixelHeight) {
        return Block.m_49796_((double)widthPixelOffset, (double)0.0, (double)widthPixelOffset, (double)(16.0 - widthPixelOffset), (double)yPixelHeight, (double)(16.0 - widthPixelOffset));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        Block block = state.m_60734_();
        if (block == BDBBlocks.SAND_CASTLE.get()) {
            return SAND_CASTLE.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
        }
        return SEASHELL.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos groundPos = pos.m_7495_();
        BlockState groundBlock = worldIn.m_8055_(groundPos);
        return groundBlock.m_60783_((BlockGetter)worldIn, groundPos, Direction.UP);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        blockstate = (BlockState)blockstate.m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (this.m_7898_(blockstate, (LevelReader)context.m_43725_(), context.m_8083_())) {
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean swingArm = false;
        if (player.m_36326_()) {
            Direction blockDirection = (Direction)state.m_61143_((Property)f_54117_);
            this.rotateBlock(state, worldIn, pos, player, blockDirection);
            swingArm = true;
        }
        return swingArm ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private void rotateBlock(BlockState state, Level worldIn, BlockPos pos, Player player, Direction blockDirection) {
        SoundType sound = this.getSoundType(state, (LevelReader)worldIn, pos, (Entity)player);
        worldIn.m_5594_(player, pos, (SoundEvent)BDBSoundEvents.BLOCK_SMALL_ROTATE.get(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        switch (blockDirection) {
            default: {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.EAST));
                break;
            }
            case EAST: {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH));
                break;
            }
            case SOUTH: {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.WEST));
                break;
            }
            case WEST: {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
            }
        }
    }
}

