/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.block;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xratedjunior.betterdefaultbiomes.block.block.DoubleWaterPlantBlockBDB;
import xratedjunior.betterdefaultbiomes.block.block.FlowerBlockBDB;
import xratedjunior.betterdefaultbiomes.block.block.GrassBlockBDB;
import xratedjunior.betterdefaultbiomes.block.block.LeavesBlockBDB;
import xratedjunior.betterdefaultbiomes.block.block.MushroomBlockBDB;
import xratedjunior.betterdefaultbiomes.block.block.PineconeBlock;
import xratedjunior.betterdefaultbiomes.block.block.SaplingBlockBDB;
import xratedjunior.betterdefaultbiomes.block.block.SimpleBlock;
import xratedjunior.betterdefaultbiomes.block.block.SmallCactusBlockBDB;
import xratedjunior.betterdefaultbiomes.block.block.SmallRockBlock;
import xratedjunior.betterdefaultbiomes.block.block.StarfishBlock;
import xratedjunior.betterdefaultbiomes.block.block.StarfishWallBlock;
import xratedjunior.betterdefaultbiomes.block.block.grower.PalmTreeGrower;
import xratedjunior.betterdefaultbiomes.block.block.grower.PineconeTreeGrower;
import xratedjunior.betterdefaultbiomes.block.block.grower.SwampWillowTreeGrower;
import xratedjunior.betterdefaultbiomes.block.property.BDBWoodTypes;
import xratedjunior.betterdefaultbiomes.item.BDBItems;
import xratedjunior.betterdefaultbiomes.item.item.SmallRockItem;
import xratedjunior.betterdefaultbiomes.sound.BDBSoundTypes;
import xratedjunior.betterdefaultbiomes.world.generation.BDBConfiguredFeatures;

@Mod.EventBusSubscriber(modid="betterdefaultbiomes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BDBBlocks {
    public static final DeferredRegister<Block> DEFERRED_BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"betterdefaultbiomes");
    public static final Map<Supplier<Block>, Supplier<Block>> POTTED_PLANTS = Maps.newHashMap();
    public static final List<Supplier<Block>> SMALL_ROCKS = new ArrayList<Supplier<Block>>();
    public static final List<Supplier<Block>> STARFISH = new ArrayList<Supplier<Block>>();
    public static final RegistryObject<Block> PALM_SAPLING = BDBBlocks.registerBlockAndBlockItem("palm_sapling", () -> new SaplingBlockBDB(new PalmTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> PALM_SAPLING_POTTED = BDBBlocks.registerBlock("palm_sapling_potted", () -> BDBBlocks.flowerPot(PALM_SAPLING));
    public static final RegistryObject<Block> PALM_LEAVES = BDBBlocks.registerBlockAndBlockItem("palm_leaves", () -> new LeavesBlockBDB(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)));
    public static final RegistryObject<Block> PALM_LOG = BDBBlocks.registerBlockAndBlockItem("palm_log", () -> BDBBlocks.log(MapColor.f_283825_, MapColor.f_283825_));
    public static final RegistryObject<Block> PALM_WOOD = BDBBlocks.registerBlockAndBlockItem("palm_wood", () -> BDBBlocks.wood(MapColor.f_283825_));
    public static final RegistryObject<Block> PALM_LOG_STRIPPED = BDBBlocks.registerBlockAndBlockItem("palm_log_stripped", () -> BDBBlocks.log(MapColor.f_283825_, MapColor.f_283825_));
    public static final RegistryObject<Block> PALM_WOOD_STRIPPED = BDBBlocks.registerBlockAndBlockItem("palm_wood_stripped", () -> BDBBlocks.wood(MapColor.f_283919_));
    public static final RegistryObject<Block> PALM_PLANKS = BDBBlocks.registerBlockAndBlockItem("palm_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> PALM_STAIRS = BDBBlocks.registerBlockAndBlockItem("palm_stairs", () -> new StairBlock(() -> ((Block)PALM_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PALM_PLANKS.get()))));
    public static final RegistryObject<Block> PALM_SLAB = BDBBlocks.registerBlockAndBlockItem("palm_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PALM_PLANKS.get()))));
    public static final RegistryObject<Block> PALM_FENCE = BDBBlocks.registerBlockAndBlockItem("palm_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PALM_PLANKS.get()))));
    public static final RegistryObject<Block> PALM_FENCE_GATE = BDBBlocks.registerBlockAndBlockItem("palm_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PALM_PLANKS.get())), BDBWoodTypes.PALM));
    public static final RegistryObject<Block> PALM_DOOR = BDBBlocks.registerBlockAndBlockItem("palm_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BDBWoodTypes.PALM.f_271340_()));
    public static final RegistryObject<Block> PALM_TRAPDOOR = BDBBlocks.registerBlockAndBlockItem("palm_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BDBWoodTypes.PALM.f_271340_()));
    public static final RegistryObject<Block> PALM_PRESSURE_PLATE = BDBBlocks.registerBlockAndBlockItem("palm_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BDBWoodTypes.PALM.f_271340_()));
    public static final RegistryObject<Block> PALM_BUTTON = BDBBlocks.registerBlockAndBlockItem("palm_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BDBWoodTypes.PALM.f_271340_(), 30, true));
    public static final RegistryObject<Block> PALM_LADDER = BDBBlocks.registerBlockAndBlockItem("palm_ladder", () -> new LadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)));
    public static final RegistryObject<Block> SWAMP_WILLOW_SAPLING = BDBBlocks.registerBlockAndBlockItem("swamp_willow_sapling", () -> new SaplingBlockBDB(new SwampWillowTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> SWAMP_WILLOW_SAPLING_POTTED = BDBBlocks.registerBlock("swamp_willow_sapling_potted", () -> BDBBlocks.flowerPot(SWAMP_WILLOW_SAPLING));
    public static final RegistryObject<Block> SWAMP_WILLOW_LEAVES = BDBBlocks.registerBlockAndBlockItem("swamp_willow_leaves", () -> new LeavesBlockBDB(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)));
    public static final RegistryObject<Block> SWAMP_WILLOW_LOG = BDBBlocks.registerBlockAndBlockItem("swamp_willow_log", () -> BDBBlocks.log(MapColor.f_283825_, MapColor.f_283825_));
    public static final RegistryObject<Block> SWAMP_WILLOW_WOOD = BDBBlocks.registerBlockAndBlockItem("swamp_willow_wood", () -> BDBBlocks.wood(MapColor.f_283825_));
    public static final RegistryObject<Block> SWAMP_WILLOW_LOG_STRIPPED = BDBBlocks.registerBlockAndBlockItem("swamp_willow_log_stripped", () -> BDBBlocks.log(MapColor.f_283825_, MapColor.f_283825_));
    public static final RegistryObject<Block> SWAMP_WILLOW_WOOD_STRIPPED = BDBBlocks.registerBlockAndBlockItem("swamp_willow_wood_stripped", () -> BDBBlocks.wood(MapColor.f_283919_));
    public static final RegistryObject<Block> SWAMP_WILLOW_PLANKS = BDBBlocks.registerBlockAndBlockItem("swamp_willow_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> SWAMP_WILLOW_STAIRS = BDBBlocks.registerBlockAndBlockItem("swamp_willow_stairs", () -> new StairBlock(() -> ((Block)SWAMP_WILLOW_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SWAMP_WILLOW_PLANKS.get()))));
    public static final RegistryObject<Block> SWAMP_WILLOW_SLAB = BDBBlocks.registerBlockAndBlockItem("swamp_willow_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SWAMP_WILLOW_PLANKS.get()))));
    public static final RegistryObject<Block> SWAMP_WILLOW_FENCE = BDBBlocks.registerBlockAndBlockItem("swamp_willow_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SWAMP_WILLOW_PLANKS.get()))));
    public static final RegistryObject<Block> SWAMP_WILLOW_FENCE_GATE = BDBBlocks.registerBlockAndBlockItem("swamp_willow_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SWAMP_WILLOW_PLANKS.get())), BDBWoodTypes.SWAMP_WILLOW));
    public static final RegistryObject<Block> SWAMP_WILLOW_DOOR = BDBBlocks.registerBlockAndBlockItem("swamp_willow_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BDBWoodTypes.SWAMP_WILLOW.f_271340_()));
    public static final RegistryObject<Block> SWAMP_WILLOW_TRAPDOOR = BDBBlocks.registerBlockAndBlockItem("swamp_willow_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BDBWoodTypes.SWAMP_WILLOW.f_271340_()));
    public static final RegistryObject<Block> SWAMP_WILLOW_PRESSURE_PLATE = BDBBlocks.registerBlockAndBlockItem("swamp_willow_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BDBWoodTypes.SWAMP_WILLOW.f_271340_()));
    public static final RegistryObject<Block> SWAMP_WILLOW_BUTTON = BDBBlocks.registerBlockAndBlockItem("swamp_willow_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BDBWoodTypes.SWAMP_WILLOW.f_271340_(), 30, true));
    public static final RegistryObject<Block> SWAMP_WILLOW_LADDER = BDBBlocks.registerBlockAndBlockItem("swamp_willow_ladder", () -> new LadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)));
    public static final RegistryObject<Block> WHITE_MUSHROOM = BDBBlocks.registerBlockAndBlockItem("white_mushroom", () -> new MushroomBlockBDB(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50072_).m_284180_(MapColor.f_283761_), BDBConfiguredFeatures.BIG_WHITE_MUSHROOM));
    public static final RegistryObject<Block> YELLOW_MUSHROOM = BDBBlocks.registerBlockAndBlockItem("yellow_mushroom", () -> new MushroomBlockBDB(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50072_).m_284180_(MapColor.f_283757_), BDBConfiguredFeatures.BIG_YELLOW_MUSHROOM));
    public static final RegistryObject<Block> GRAY_MUSHROOM = BDBBlocks.registerBlockAndBlockItem("gray_mushroom", () -> new MushroomBlockBDB(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50072_).m_284180_(MapColor.f_283744_), BDBConfiguredFeatures.BIG_GRAY_MUSHROOM));
    public static final RegistryObject<Block> POTTED_WHITE_MUSHROOM = BDBBlocks.registerBlock("potted_white_mushroom", () -> BDBBlocks.flowerPot(WHITE_MUSHROOM));
    public static final RegistryObject<Block> POTTED_YELLOW_MUSHROOM = BDBBlocks.registerBlock("potted_yellow_mushroom", () -> BDBBlocks.flowerPot(YELLOW_MUSHROOM));
    public static final RegistryObject<Block> POTTED_GRAY_MUSHROOM = BDBBlocks.registerBlock("potted_gray_mushroom", () -> BDBBlocks.flowerPot(GRAY_MUSHROOM));
    public static final RegistryObject<Block> WHITE_MUSHROOM_BLOCK = BDBBlocks.registerBlockAndBlockItem("white_mushroom_block", () -> new HugeMushroomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50180_).m_284180_(MapColor.f_283761_)));
    public static final RegistryObject<Block> YELLOW_MUSHROOM_BLOCK = BDBBlocks.registerBlockAndBlockItem("yellow_mushroom_block", () -> new HugeMushroomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50180_).m_284180_(MapColor.f_283843_)));
    public static final RegistryObject<Block> GRAY_MUSHROOM_BLOCK = BDBBlocks.registerBlockAndBlockItem("gray_mushroom_block", () -> new HugeMushroomBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50180_).m_284180_(MapColor.f_283744_)));
    public static final RegistryObject<Block> PURPLE_VERBENA = BDBBlocks.registerBlockAndBlockItem("purple_verbena", () -> BDBBlocks.flower(MobEffects.f_19618_, 7, MapColor.f_283889_));
    public static final RegistryObject<Block> BLUE_POPPY = BDBBlocks.registerBlockAndBlockItem("blue_poppy", () -> BDBBlocks.flower(MobEffects.f_19606_, 7, MapColor.f_283869_));
    public static final RegistryObject<Block> DARK_VIOLET = BDBBlocks.registerBlockAndBlockItem("dark_violet", () -> BDBBlocks.flower(MobEffects.f_19608_, 7, MapColor.f_283892_));
    public static final RegistryObject<Block> PINK_CACTUS_FLOWER = BDBBlocks.registerBlockAndBlockItem("pink_cactus_flower", () -> new SmallCactusBlockBDB(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> POTTED_PURPLE_VERBENA = BDBBlocks.registerBlock("potted_purple_verbena", () -> BDBBlocks.flowerPot(PURPLE_VERBENA));
    public static final RegistryObject<Block> POTTED_BLUE_POPPY = BDBBlocks.registerBlock("potted_blue_poppy", () -> BDBBlocks.flowerPot(BLUE_POPPY));
    public static final RegistryObject<Block> POTTED_DARK_VIOLET = BDBBlocks.registerBlock("potted_dark_violet", () -> BDBBlocks.flowerPot(DARK_VIOLET));
    public static final RegistryObject<Block> POTTED_PINK_CACTUS_FLOWER = BDBBlocks.registerBlock("potted_pink_cactus_flower", () -> BDBBlocks.flowerPot(PINK_CACTUS_FLOWER));
    public static final RegistryObject<Block> FEATHER_REED_GRASS = BDBBlocks.registerBlockAndBlockItem("feather_reed_grass", () -> BDBBlocks.grass(MapColor.f_283761_));
    public static final RegistryObject<Block> DEAD_GRASS = BDBBlocks.registerBlockAndBlockItem("dead_grass", () -> BDBBlocks.grass(MapColor.f_283825_));
    public static final RegistryObject<Block> SHORT_GRASS = BDBBlocks.registerBlockAndBlockItem("short_grass", () -> BDBBlocks.grass(MapColor.f_283824_));
    public static final RegistryObject<Block> DUNE_GRASS = BDBBlocks.registerBlockAndBlockItem("dune_grass", () -> BDBBlocks.grass(MapColor.f_283824_));
    public static final RegistryObject<Block> TALL_WATER_REEDS = BDBBlocks.registerBlockAndBlockItem("tall_water_reeds", () -> new DoubleWaterPlantBlockBDB(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60910_().m_60966_().m_60918_(SoundType.f_56752_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> POTTED_FEATHER_REED_GRASS = BDBBlocks.registerBlock("potted_feather_reed_grass", () -> BDBBlocks.flowerPot(FEATHER_REED_GRASS));
    public static final RegistryObject<Block> POTTED_DEAD_GRASS = BDBBlocks.registerBlock("potted_dead_grass", () -> BDBBlocks.flowerPot(DEAD_GRASS));
    public static final RegistryObject<Block> POTTED_SHORT_GRASS = BDBBlocks.registerBlock("potted_short_grass", () -> BDBBlocks.flowerPot(SHORT_GRASS));
    public static final RegistryObject<Block> POTTED_DUNE_GRASS = BDBBlocks.registerBlock("potted_dune_grass", () -> BDBBlocks.flowerPot(DUNE_GRASS));
    public static final RegistryObject<Block> SAND_CASTLE = BDBBlocks.registerBlockAndBlockItem("sand_castle", () -> new SimpleBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60918_(SoundType.f_56746_).m_222979_(BlockBehaviour.OffsetType.XZ).m_60978_(0.5f).m_60955_().m_60999_().m_60988_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> PINECONE = BDBBlocks.registerBlockAndBlockItem("pinecone", () -> new PineconeBlock(new PineconeTreeGrower(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(BDBSoundTypes.SMALL_BLOCK).m_222979_(BlockBehaviour.OffsetType.XZ).m_60910_().m_60966_().m_60955_().m_278183_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> SEASHELL = BDBBlocks.registerBlockAndBlockItem("seashell", () -> new SimpleBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_).m_60918_(BDBSoundTypes.SMALL_BLOCK).m_222979_(BlockBehaviour.OffsetType.XZ).m_60910_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> SMALL_ROCK_STONE = BDBBlocks.registerSmallRock("small_rock_stone");
    public static final RegistryObject<Block> SMALL_ROCK_COBBLE = BDBBlocks.registerSmallRock("small_rock_cobble");
    public static final RegistryObject<Block> SMALL_ROCK_MOSSY = BDBBlocks.registerSmallRock("small_rock_mossy");
    public static final RegistryObject<Block> SMALL_ROCK_ANDESITE = BDBBlocks.registerSmallRock("small_rock_andesite");
    public static final RegistryObject<Block> SMALL_ROCK_DIORITE = BDBBlocks.registerSmallRock("small_rock_diorite");
    public static final RegistryObject<Block> SMALL_ROCK_GRANITE = BDBBlocks.registerSmallRock("small_rock_granite");
    public static final RegistryObject<Block> SMALL_ROCK_SANDSTONE = BDBBlocks.registerSmallRock("small_rock_sandstone");
    public static final RegistryObject<Block> SMALL_ROCK_RED_SANDSTONE = BDBBlocks.registerSmallRock("small_rock_red_sandstone");
    public static final RegistryObject<Block> SMALL_ROCK_DEEPSLATE = BDBBlocks.registerSmallRock("small_rock_deepslate");
    public static final RegistryObject<Block> SMALL_ROCK_COBBLED_DEEPSLATE = BDBBlocks.registerSmallRock("small_rock_cobbled_deepslate");
    public static final RegistryObject<Block> STARFISH_WHITE = BDBBlocks.registerBlockAndBlockItem("starfish_white", () -> BDBBlocks.starfishBlock(DyeColor.WHITE, MapColor.f_283811_));
    public static final RegistryObject<Block> STARFISH_ORANGE = BDBBlocks.registerBlockAndBlockItem("starfish_orange", () -> BDBBlocks.starfishBlock(DyeColor.ORANGE, MapColor.f_283750_));
    public static final RegistryObject<Block> STARFISH_MAGENTA = BDBBlocks.registerBlockAndBlockItem("starfish_magenta", () -> BDBBlocks.starfishBlock(DyeColor.MAGENTA, MapColor.f_283931_));
    public static final RegistryObject<Block> STARFISH_LIGHT_BLUE = BDBBlocks.registerBlockAndBlockItem("starfish_light_blue", () -> BDBBlocks.starfishBlock(DyeColor.LIGHT_BLUE, MapColor.f_283869_));
    public static final RegistryObject<Block> STARFISH_YELLOW = BDBBlocks.registerBlockAndBlockItem("starfish_yellow", () -> BDBBlocks.starfishBlock(DyeColor.YELLOW, MapColor.f_283832_));
    public static final RegistryObject<Block> STARFISH_LIME = BDBBlocks.registerBlockAndBlockItem("starfish_lime", () -> BDBBlocks.starfishBlock(DyeColor.LIME, MapColor.f_283916_));
    public static final RegistryObject<Block> STARFISH_PINK = BDBBlocks.registerBlockAndBlockItem("starfish_pink", () -> BDBBlocks.starfishBlock(DyeColor.PINK, MapColor.f_283765_));
    public static final RegistryObject<Block> STARFISH_GRAY = BDBBlocks.registerBlockAndBlockItem("starfish_gray", () -> BDBBlocks.starfishBlock(DyeColor.GRAY, MapColor.f_283818_));
    public static final RegistryObject<Block> STARFISH_LIGHT_GRAY = BDBBlocks.registerBlockAndBlockItem("starfish_light_gray", () -> BDBBlocks.starfishBlock(DyeColor.LIGHT_GRAY, MapColor.f_283779_));
    public static final RegistryObject<Block> STARFISH_CYAN = BDBBlocks.registerBlockAndBlockItem("starfish_cyan", () -> BDBBlocks.starfishBlock(DyeColor.CYAN, MapColor.f_283772_));
    public static final RegistryObject<Block> STARFISH_PURPLE = BDBBlocks.registerBlockAndBlockItem("starfish_purple", () -> BDBBlocks.starfishBlock(DyeColor.PURPLE, MapColor.f_283889_));
    public static final RegistryObject<Block> STARFISH_BLUE = BDBBlocks.registerBlockAndBlockItem("starfish_blue", () -> BDBBlocks.starfishBlock(DyeColor.BLUE, MapColor.f_283743_));
    public static final RegistryObject<Block> STARFISH_BROWN = BDBBlocks.registerBlockAndBlockItem("starfish_brown", () -> BDBBlocks.starfishBlock(DyeColor.BROWN, MapColor.f_283748_));
    public static final RegistryObject<Block> STARFISH_GREEN = BDBBlocks.registerBlockAndBlockItem("starfish_green", () -> BDBBlocks.starfishBlock(DyeColor.GREEN, MapColor.f_283784_));
    public static final RegistryObject<Block> STARFISH_RED = BDBBlocks.registerBlockAndBlockItem("starfish_red", () -> BDBBlocks.starfishBlock(DyeColor.RED, MapColor.f_283913_));
    public static final RegistryObject<Block> STARFISH_BLACK = BDBBlocks.registerBlockAndBlockItem("starfish_black", () -> BDBBlocks.starfishBlock(DyeColor.BLACK, MapColor.f_283927_));
    public static final RegistryObject<Block> STARFISH_WALL_WHITE = BDBBlocks.registerBlock("starfish_wall_white", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.WHITE));
    public static final RegistryObject<Block> STARFISH_WALL_ORANGE = BDBBlocks.registerBlock("starfish_wall_orange", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.ORANGE));
    public static final RegistryObject<Block> STARFISH_WALL_MAGENTA = BDBBlocks.registerBlock("starfish_wall_magenta", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.MAGENTA));
    public static final RegistryObject<Block> STARFISH_WALL_LIGHT_BLUE = BDBBlocks.registerBlock("starfish_wall_light_blue", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.LIGHT_BLUE));
    public static final RegistryObject<Block> STARFISH_WALL_YELLOW = BDBBlocks.registerBlock("starfish_wall_yellow", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.YELLOW));
    public static final RegistryObject<Block> STARFISH_WALL_LIME = BDBBlocks.registerBlock("starfish_wall_lime", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.LIME));
    public static final RegistryObject<Block> STARFISH_WALL_PINK = BDBBlocks.registerBlock("starfish_wall_pink", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.PINK));
    public static final RegistryObject<Block> STARFISH_WALL_GRAY = BDBBlocks.registerBlock("starfish_wall_gray", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.GRAY));
    public static final RegistryObject<Block> STARFISH_WALL_LIGHT_GRAY = BDBBlocks.registerBlock("starfish_wall_light_gray", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.LIGHT_GRAY));
    public static final RegistryObject<Block> STARFISH_WALL_CYAN = BDBBlocks.registerBlock("starfish_wall_cyan", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.CYAN));
    public static final RegistryObject<Block> STARFISH_WALL_PURPLE = BDBBlocks.registerBlock("starfish_wall_purple", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.PURPLE));
    public static final RegistryObject<Block> STARFISH_WALL_BLUE = BDBBlocks.registerBlock("starfish_wall_blue", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.BLUE));
    public static final RegistryObject<Block> STARFISH_WALL_BROWN = BDBBlocks.registerBlock("starfish_wall_brown", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.BROWN));
    public static final RegistryObject<Block> STARFISH_WALL_GREEN = BDBBlocks.registerBlock("starfish_wall_green", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.GREEN));
    public static final RegistryObject<Block> STARFISH_WALL_RED = BDBBlocks.registerBlock("starfish_wall_red", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.RED));
    public static final RegistryObject<Block> STARFISH_WALL_BLACK = BDBBlocks.registerBlock("starfish_wall_black", () -> BDBBlocks.registerStarfishWallBlock(DyeColor.BLACK));

    private static RotatedPillarBlock log(MapColor innerColor, MapColor outerColor) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? innerColor : outerColor));
    }

    private static RotatedPillarBlock wood(MapColor mapColor) {
        return BDBBlocks.log(mapColor, mapColor);
    }

    private static FlowerBlockBDB flower(MobEffect suspiciousStewEffect, int effectDuration, MapColor mapColor) {
        return new FlowerBlockBDB(() -> suspiciousStewEffect, effectDuration, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_).m_284180_(mapColor));
    }

    private static GrassBlockBDB grass(MapColor mapColor) {
        return new GrassBlockBDB(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_).m_284180_(mapColor));
    }

    private static FlowerPotBlock flowerPot(Supplier<Block> blockSupplier) {
        FlowerPotBlock pottedPlant = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, blockSupplier, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50232_));
        POTTED_PLANTS.put(blockSupplier, () -> pottedPlant);
        return pottedPlant;
    }

    private static Block starfishBlock(DyeColor dyeColor, MapColor mapColor) {
        StarfishBlock starfishBlock = new StarfishBlock(dyeColor, BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_60910_().m_60966_().m_60918_(SoundType.f_56742_).m_222979_(BlockBehaviour.OffsetType.XZ).m_60953_(BDBBlocks.getLightValueLit(8)).m_278166_(PushReaction.DESTROY));
        STARFISH.add(() -> starfishBlock);
        return starfishBlock;
    }

    private static Block registerStarfishWallBlock(DyeColor dyeColor) {
        Supplier<Block> parentStarfish = () -> StarfishBlock.getBlockByColor(dyeColor);
        return new StarfishWallBlock(dyeColor, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)parentStarfish.get())).m_222979_(BlockBehaviour.OffsetType.NONE).lootFrom(() -> (Block)parentStarfish.get()));
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    private static RegistryObject<Block> registerSmallRock(@Nonnull String registryName) {
        RegistryObject<Block> registryBlock = BDBBlocks.registerBlock(registryName, () -> new SmallRockBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_222979_(BlockBehaviour.OffsetType.XZ).m_60910_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY)));
        SMALL_ROCKS.add((Supplier<Block>)registryBlock);
        BDBItems.registerItem(registryName, () -> new SmallRockItem((Block)registryBlock.get(), new Item.Properties()));
        return registryBlock;
    }

    private static <B extends Block> RegistryObject<Block> registerBlockAndBlockItem(@Nonnull String registryName, Supplier<B> blockSupplier) {
        RegistryObject<Block> registryBlock = BDBBlocks.registerBlock(registryName, blockSupplier);
        BDBItems.registerItem(registryName, () -> new BlockItem((Block)registryBlock.get(), new Item.Properties()));
        return registryBlock;
    }

    private static <B extends Block> RegistryObject<Block> registerBlock(@Nonnull String registryName, Supplier<B> blockSupplier) {
        return DEFERRED_BLOCKS.register(registryName, blockSupplier);
    }
}

