/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render.layer;

import forge.net.mca.client.gui.immersive_library.SkinCache;
import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.render.layer.VillagerLayer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ClothingLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends VillagerLayer<T, M> {
    private final String variant;

    public ClothingLayer(RenderLayerParent<T, M> renderer, M model, String variant) {
        super(renderer, model);
        this.variant = variant;
    }

    @Override
    public ResourceLocation getSkin(T villager) {
        String v = CommonVillagerModel.getVillager(villager).isBurned() ? "burnt" : this.variant;
        String identifier = CommonVillagerModel.getVillager(villager).getClothes();
        if (identifier.startsWith("immersive_library:")) {
            return SkinCache.getTextureIdentifier(Integer.parseInt(identifier.substring(18)));
        }
        return this.cached(identifier + v, clothes -> {
            ResourceLocation id = new ResourceLocation(CommonVillagerModel.getVillager((Entity)villager).getClothes());
            ResourceLocation idNew = new ResourceLocation(id.m_135827_(), id.m_135815_().replace("normal", v));
            if (this.canUse(idNew)) {
                return idNew;
            }
            return id;
        });
    }
}

