/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server.world.data.villageComponents;

import fabric.net.mca.Config;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.Memories;
import fabric.net.mca.server.world.data.Village;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class VillageMarriageManager {
    private final Village village;

    public VillageMarriageManager(Village village) {
        this.village = village;
    }

    public void marry(class_3218 world) {
        if (world.field_9229.method_43057() >= Config.getInstance().marriageChancePerMinute) {
            return;
        }
        List<VillagerEntityMCA> allVillagers = this.village.getResidents(world);
        List availableVillagers = allVillagers.stream().filter(v -> !v.method_6109()).filter(v -> !v.getRelationships().isMarried()).filter(v -> !v.getRelationships().isEngaged()).filter(v -> !v.getRelationships().isPromised()).collect(Collectors.toList());
        if (availableVillagers.size() <= 1 || (double)availableVillagers.size() <= (double)allVillagers.size() * (1.0 - (double)this.village.getMarriageThreshold())) {
            return;
        }
        availableVillagers.sort(Comparator.comparingInt(a -> a.getVillagerBrain().getMemories().values().stream().map(Memories::getHearts).max(Integer::compare).orElse(0)));
        VillagerEntityMCA suitor = (VillagerEntityMCA)availableVillagers.remove(0);
        availableVillagers.stream().filter(suitor::canBeAttractedTo).filter(i -> !suitor.getRelationships().getFamilyEntry().isRelative(i.method_5667())).findFirst().ifPresent(mate -> {
            suitor.getRelationships().marry((class_1297)mate);
            mate.getRelationships().marry((class_1297)suitor);
            if (Config.getInstance().villagerMarriageNotification) {
                this.village.broadCastMessage(world, "events.marry", suitor, (VillagerEntityMCA)mate);
            }
            this.village.getCivilRegistry().ifPresent(r -> r.addText((class_2561)class_2561.method_43469((String)"events.marry", (Object[])new Object[]{suitor.method_5477(), mate.method_5477()})));
        });
    }
}

