/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.network.c2s;

import fabric.net.mca.cobalt.network.Message;
import fabric.net.mca.server.world.data.Building;
import fabric.net.mca.server.world.data.Village;
import fabric.net.mca.server.world.data.VillageManager;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ReportBuildingMessage
implements Message {
    private static final long serialVersionUID = 3510050513221709603L;
    private final Action action;
    private final String data;

    public ReportBuildingMessage(Action action, String data) {
        this.action = action;
        this.data = data;
    }

    public ReportBuildingMessage(Action action) {
        this(action, null);
    }

    @Override
    public void receive(class_3222 player) {
        VillageManager villages = VillageManager.get(player.method_51469());
        switch (this.action) {
            case ADD: 
            case ADD_ROOM: {
                Building.validationResult result = villages.processBuilding(player.method_24515(), true, this.action == Action.ADD_ROOM);
                player.method_7353((class_2561)class_2561.method_43471((String)("blueprint.scan." + result.name().toLowerCase(Locale.ENGLISH))), true);
                break;
            }
            case AUTO_SCAN: {
                villages.findNearestVillage((class_1297)player).ifPresent(Village::toggleAutoScan);
                break;
            }
            case FULL_SCAN: {
                villages.findNearestVillage((class_1297)player).ifPresent(buildings -> buildings.getBuildings().values().stream().toList().forEach(b -> villages.processBuilding(b.getCenter(), true, b.isStrictScan())));
                break;
            }
            case FORCE_TYPE: 
            case REMOVE: {
                Optional<Village> village = villages.findNearestVillage((class_1297)player);
                Optional building = village.flatMap(v -> v.getBuildings().values().stream().filter(b -> b.containsPos((class_2382)player.method_24515())).filter(b -> this.action != Action.FORCE_TYPE || !b.getBuildingType().grouped()).findAny());
                building.ifPresentOrElse(b -> {
                    if (this.action == Action.FORCE_TYPE) {
                        if (b.getType().equals(this.data)) {
                            b.setTypeForced(false);
                            b.determineType();
                        } else {
                            b.setTypeForced(true);
                            b.setType(this.data);
                        }
                    } else {
                        ((Village)village.get()).removeBuilding(b.getId());
                    }
                }, () -> player.method_7353((class_2561)class_2561.method_43471((String)"blueprint.noBuilding"), true));
            }
        }
    }

    public static enum Action {
        AUTO_SCAN,
        ADD_ROOM,
        ADD,
        REMOVE,
        FORCE_TYPE,
        FULL_SCAN;

    }
}

