/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.entities.StalactiteEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class ReflectionNecklaceItem
extends RelicItem
implements IRenderableCurio {
    public static final String TAG_CHARGE = "charge";
    public static final String TAG_TIME = "time";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("explode").stat(StatData.builder("capacity").initialValue(20.0, 60.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.35).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("damage").initialValue(0.25, 0.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> MathUtils.round(value, 2)).build()).stat(StatData.builder("stun").initialValue(0.05, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 2)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-16729345).borderBottom(-16740183).textured(true).build()).build()).loot(LootData.builder().entry(LootCollections.NETHER).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block10: {
            block9: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block9;
                player = (Player)livingEntity;
                if (player.f_19797_ % 20 == 0) break block10;
            }
            return;
        }
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        double charge = NBTUtils.getDouble(stack, TAG_CHARGE, 0.0);
        if (time > 0 && charge < this.getAbilityValue(stack, "explode", "capacity")) {
            NBTUtils.setInt(stack, TAG_TIME, --time);
        } else if (charge > 0.0) {
            Level level = player.m_9236_();
            RandomSource random = player.m_217043_();
            float size = (float)(Math.log(charge) * (double)0.6f);
            float speed = (float)((double)0.35f + charge * (double)0.001f);
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (random.m_188500_() - random.m_188500_());
                        double d4 = (double)i + (random.m_188500_() - random.m_188500_());
                        double d5 = (double)k + (random.m_188500_() - random.m_188500_());
                        double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / (double)speed + random.m_188583_();
                        Vec3 motion = new Vec3(d3 / d6, d4 / d6, d5 / d6);
                        float mul = player.m_20206_() / 1.5f;
                        Vec3 pos = player.m_20182_().m_82520_(0.0, (double)mul, 0.0).m_82549_(motion.m_82541_().m_82542_((double)mul, (double)mul, (double)mul));
                        if (level.m_8055_(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_)).m_280555_()) continue;
                        StalactiteEntity stalactite = new StalactiteEntity(level, (float)(charge * this.getAbilityValue(stack, "explode", "damage")), (float)(charge * this.getAbilityValue(stack, "explode", "stun")));
                        stalactite.m_5602_((Entity)player);
                        stalactite.m_146884_(pos);
                        stalactite.m_20256_(motion);
                        level.m_7967_((Entity)stalactite);
                    }
                }
            }
            this.spreadExperience((LivingEntity)player, stack, (int)Math.floor(charge / 10.0));
            NBTUtils.setDouble(stack, TAG_CHARGE, 0.0);
            NBTUtils.setInt(stack, TAG_TIME, 0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        model.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, 0.0f, -4.15f, 16.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)).m_171514_(0, 0).m_171488_(-1.5f, 5.125f, -5.15f, 3.0f, 5.0f, 1.0f, new CubeDeformation(-0.075f)).m_171514_(0, 15).m_171488_(-1.0f, 6.375f, -5.775f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        bone.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(6, 15).m_171488_(-0.675f, -1.325f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.475f, (float)-4.65f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class ReflectionNecklaceServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.REFLECTION_NECKLACE.get());
            Item item = stack.m_41720_();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            double charge = NBTUtils.getDouble(stack, ReflectionNecklaceItem.TAG_CHARGE, 0.0);
            double capacity = relic.getAbilityValue(stack, "explode", "capacity");
            if (charge < capacity) {
                NBTUtils.setDouble(stack, ReflectionNecklaceItem.TAG_CHARGE, Math.min(capacity, charge + (double)event.getAmount()));
                NBTUtils.setInt(stack, ReflectionNecklaceItem.TAG_TIME, 5);
            }
        }
    }
}

