/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class BlazingFlaskItem
extends RelicItem {
    public static final String TAG_POSITION = "pos";
    public static final String TAG_COUNT = "count";
    public static final String TAG_RADIUS = "radius";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("bonfire").stat(StatData.builder("step").initialValue(1.0, 2.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("speed").initialValue(0.01, 0.05).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 1.9).formatValue(value -> MathUtils.round(value * 8.0, 1)).build()).stat(StatData.builder("height").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.NETHER).build()).build();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level world = player.m_20193_();
        int fire = this.getFireAround(stack, world);
        if (fire <= 0) {
            NBTUtils.clearTag(stack, TAG_POSITION);
            NBTUtils.clearTag(stack, TAG_COUNT);
        } else {
            NBTUtils.setInt(stack, TAG_COUNT, fire);
        }
        Vec3 center = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
        if (center != null) {
            double radius = NBTUtils.getDouble(stack, TAG_RADIUS, 0.0);
            if (!(player.m_7500_() || player.m_5833_() || player.m_150110_().f_35935_ || player.m_150110_().f_35936_)) {
                Vec3 vec3 = new Vec3(player.m_20185_(), center.m_7098_(), player.m_20189_());
                if (vec3.m_82554_(center) <= radius + 0.5) {
                    player.f_19789_ = 0.0f;
                    if (player.f_19797_ % 100 == 0) {
                        this.spreadExperience((LivingEntity)player, stack, 1);
                    }
                    double speed = this.getAbilityValue(stack, "bonfire", "speed");
                    if (world.m_5776_()) {
                        if (!(player.m_20096_() || player.f_20902_ == 0.0f && player.f_20900_ == 0.0f)) {
                            player.m_6478_(MoverType.SELF, player.m_20184_().m_82542_(speed, 0.0, speed));
                        }
                        if (player instanceof LocalPlayer) {
                            LocalPlayer localPlayer = (LocalPlayer)player;
                            if (localPlayer.f_108618_.f_108572_ && WorldUtils.getGroundHeight((Entity)player, player.m_20182_(), 64) + this.getAbilityValue(stack, "bonfire", "height") - player.m_20186_() > 0.0) {
                                Vec3 motion = player.m_20184_();
                                if (motion.m_7098_() < 0.0) {
                                    player.m_20334_(motion.m_7096_(), motion.m_7098_() * (double)0.9f, motion.m_7094_());
                                }
                                player.m_20256_(player.m_20184_().m_82520_(0.0, (double)0.1f, 0.0));
                            }
                        }
                    }
                }
            }
            double size = (double)NBTUtils.getInt(stack, TAG_COUNT, 0) * this.getAbilityValue(stack, "bonfire", "step");
            double step = 0.1;
            int time = 0;
            if (radius < size) {
                radius = radius + step < size ? (radius += step) : size;
                time = 10;
                NBTUtils.setDouble(stack, TAG_RADIUS, radius);
            }
            if (radius > size) {
                radius = radius - step > size ? (radius -= step) : size;
                time = 10;
                NBTUtils.setDouble(stack, TAG_RADIUS, radius);
            }
            if (radius <= step) {
                ParticleUtils.createBall(ParticleUtils.constructSimpleSpark(new Color(255, 100, 0), 0.3f, 20, 0.9f), center, level, 3, 0.2f);
            }
            ParticleUtils.createCyl(ParticleUtils.constructSimpleSpark(new Color(255, 100, 0), 0.2f, time, 0.8f), center, level, radius, 0.15f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        float distance;
        ItemStack stack = player.m_21120_(hand);
        Vec3 view = player.m_20252_(0.0f);
        Vec3 eyeVec = player.m_20299_(0.0f);
        Vec3 end = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (double)(distance = (float)(8.0 + this.getAbilityValue(stack, "bonfire", "height"))), view.f_82480_ * (double)distance, view.f_82481_ * (double)distance), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82450_();
        if (this.getFireAround(stack, end, level) > 0) {
            Vec3 center = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
            double radius = NBTUtils.getDouble(stack, TAG_RADIUS, 0.0);
            NBTUtils.setDouble(stack, TAG_RADIUS, center != null && end.m_82554_(center) <= radius ? radius - center.m_82554_(end) : 0.0);
            NBTUtils.setString(stack, TAG_POSITION, NBTUtils.writePosition(end));
            player.m_36335_().m_41524_((Item)this, 20);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public int getFireAround(ItemStack stack, Level level) {
        Vec3 center = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
        if (center == null) {
            return 0;
        }
        return this.getFireAround(stack, center, level);
    }

    public int getFireAround(ItemStack stack, Vec3 center, Level level) {
        List<BlockPos> positions = WorldUtils.getBlockSphere(new BlockPos((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_), this.getAbilityValue(stack, "bonfire", "step")).stream().filter(pos -> level.m_8055_(pos).m_60734_() instanceof BaseFireBlock).toList();
        return positions.size();
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }
}

