/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.config.data;

import it.hurts.octostudios.octolib.modules.config.annotations.Prop;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollection;
import java.util.Map;

public class LootConfigData {
    @Prop(comment="List of key-value pairs where the key is a textual identifier for the loot table (supporting regular expressions) and the value represents the probability of generating the relic within the specified bounds")
    private Map<String, Float> entries;

    public LootData toData(IRelicItem relic) {
        LootData data = relic.getLootData();
        data.setCollection(LootCollection.builder().entries(this.entries).build());
        return data;
    }

    public Map<String, Float> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<String, Float> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootConfigData)) {
            return false;
        }
        LootConfigData other = (LootConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Float> this$entries = this.getEntries();
        Map<String, Float> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootConfigData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Float> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public String toString() {
        return "LootConfigData(entries=" + this.getEntries() + ")";
    }

    public LootConfigData() {
    }

    public LootConfigData(Map<String, Float> entries) {
        this.entries = entries;
    }
}

