/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.block;

import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.world.block.GlowShroomRingBlock;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.MiscUtil;

public class HugeGlowShroomBlock
extends HugeMushroomBlock
implements IZetaBlock {
    private final ZetaModule module;
    private final boolean glowing;

    public HugeGlowShroomBlock(String name, ZetaModule module, boolean glowing) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50181_).m_60953_(b -> glowing ? 12 : 0).m_60982_((a, b, c) -> glowing).m_60991_((a, b, c) -> glowing).m_60977_().m_60955_());
        this.module = module;
        this.glowing = glowing;
        module.zeta.registry.registerBlock((Block)this, name, true);
        CreativeTabManager.addToCreativeTab((ResourceKey)CreativeModeTabs.f_256776_, (ItemLike)this);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public int getFlammabilityZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 0;
    }

    public int getFireSpreadSpeedZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 0;
    }

    public void m_214162_(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.m_214162_(stateIn, worldIn, pos, rand);
        BlockState below = worldIn.m_8055_(pos.m_7495_());
        if (this.glowing && rand.m_188503_(10) == 0 && (below.m_60795_() || below.m_60734_() == GlimmeringWealdModule.glow_shroom_ring)) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_(), (double)pos.m_123343_() + rand.m_188500_(), 0.0, -0.05 - Math.random() * 0.05, 0.0);
        }
    }

    public static boolean place(LevelAccessor worldIn, RandomSource rand, BlockPos pos) {
        int i;
        int i2;
        Block block = worldIn.m_8055_(pos.m_7495_()).m_60734_();
        if (block != Blocks.f_152550_) {
            return false;
        }
        BlockPos placePos = pos;
        BlockState stem = GlimmeringWealdModule.glow_shroom_stem.m_49966_();
        BlockState ring = GlimmeringWealdModule.glow_shroom_ring.m_49966_();
        BlockState cap = (BlockState)GlimmeringWealdModule.glow_shroom_block.m_49966_().m_61124_((Property)f_54132_, (Comparable)Boolean.valueOf(false));
        int stemHeight1 = 2;
        int stemHeight2 = rand.m_188503_(4);
        boolean hasBigCap = rand.m_188500_() < 0.6;
        int totalHeight = stemHeight1 + stemHeight2 + (hasBigCap ? 2 : 1);
        int horizCheck = 2;
        for (i2 = -horizCheck; i2 < horizCheck + 1; ++i2) {
            for (int j = -horizCheck; j < horizCheck + 1; ++j) {
                for (int k = 1; k < totalHeight; ++k) {
                    if (worldIn.m_8055_(placePos.m_7918_(i2, k, j)).m_60795_()) continue;
                    return false;
                }
            }
        }
        for (i2 = 0; i2 < stemHeight1; ++i2) {
            worldIn.m_7731_(placePos, stem, 2);
            placePos = placePos.m_7494_();
        }
        if (stemHeight2 > 0) {
            Direction dir = MiscUtil.HORIZONTALS[rand.m_188503_(MiscUtil.HORIZONTALS.length)];
            placePos = placePos.m_121945_(dir);
        }
        for (int i3 = 0; i3 < stemHeight2; ++i3) {
            worldIn.m_7731_(placePos, stem, 2);
            placePos = placePos.m_7494_();
        }
        int ringHeight = Math.min(2, stemHeight2);
        for (i = 0; i < ringHeight; ++i) {
            for (Direction ringDir : MiscUtil.HORIZONTALS) {
                worldIn.m_7731_(placePos.m_121945_(ringDir).m_5484_(Direction.DOWN, i + 1), (BlockState)ring.m_61124_((Property)GlowShroomRingBlock.FACING, (Comparable)ringDir), 2);
            }
        }
        for (i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                worldIn.m_7731_(placePos.m_7918_(i, 0, j), cap, 2);
            }
        }
        if (hasBigCap) {
            worldIn.m_7731_(placePos.m_7494_(), cap, 2);
        }
        return true;
    }

    public ZetaModule getModule() {
        return this.module;
    }

    public IZetaBlock setCondition(BooleanSupplier condition) {
        return this;
    }

    public boolean doesConditionApply() {
        return true;
    }
}

