/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.FakePlayer;
import org.violetmoon.quark.addons.oddities.block.MatrixEnchantingTableBlock;
import org.violetmoon.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import org.violetmoon.quark.addons.oddities.client.render.be.MatrixEnchantingTableRenderer;
import org.violetmoon.quark.addons.oddities.client.screen.MatrixEnchantingScreen;
import org.violetmoon.quark.addons.oddities.inventory.MatrixEnchantingMenu;
import org.violetmoon.quark.addons.oddities.util.CustomInfluence;
import org.violetmoon.quark.addons.oddities.util.Influence;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.ZBlock;
import org.violetmoon.zeta.event.play.ZItemTooltip;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerInteract;
import org.violetmoon.zeta.event.play.loading.ZGatherHints;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.ItemNBTHelper;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="oddities")
public class MatrixEnchantingModule
extends ZetaModule {
    public static BlockEntityType<MatrixEnchantingTableBlockEntity> blockEntityType;
    public static MenuType<MatrixEnchantingMenu> menuType;
    @Config(description="The maximum enchanting power the matrix enchanter can accept")
    public static int maxBookshelves;
    @Config(description="Should this be X, the price of a piece increase by 1 every X pieces you generate")
    public static int piecePriceScale;
    @Config(description="The higher this is, the better enchantments you'll get on books")
    public static int bookEnchantability;
    @Config(description="How many pieces you can generate without any bookshelves")
    public static int baseMaxPieceCount;
    @Config(description="How many pieces you can generate without any bookshelves (for Books)")
    public static int baseMaxPieceCountBook;
    @Config(description="At which piece count the calculation for the min level should default to increasing one per piece rather than using the scale factor")
    public static int minLevelCutoff;
    @Config(description="How many pieces a single Lapis can generate")
    public static int chargePerLapis;
    @Config(description="How much the min level requirement for adding a new piece should increase for each piece added (up until the value of Min Level Cutoff)")
    public static double minLevelScaleFactor;
    @Config(description="How much the min level requirement for adding a new piece to a book should increase per each bookshelf being used")
    public static double minLevelScaleFactorBook;
    @Config(description="How much to multiply the frequency of pieces where at least one of the same type has been generated")
    public static double dupeMultiplier;
    @Config(description="How much to multiply the frequency of pieces where incompatible pieces have been generated")
    public static double incompatibleMultiplier;
    @Config(description="Set to false to disable the ability to create Enchanted Books")
    public static boolean allowBooks;
    @Config(description="Set this to true to allow treasure enchantments to be rolled as pieces")
    public static boolean allowTreasures;
    @Config(description="Any treasure enchantment IDs here will be able to appear in books in matrix enchanting")
    public static List<String> treasureWhitelist;
    @Config(description="Set to false to disable the tooltip for items with pending enchantments")
    public static boolean showTooltip;
    @Config(description="By default, enchantment rarities are fuzzed a bit to feel better with the new system. Set this to false to override this behaviour.")
    public static boolean normalizeRarity;
    @Config(description="Matrix Enchanting can be done with water instead of air around the enchanting table. Set this to false to disable this behaviour.")
    public static boolean allowUnderwaterEnchanting;
    @Config(description="Matrix Enchanting can be done with short (<= 3px blocks) instead of air around the enchanting table. Set this to false to disable this behaviour.")
    public static boolean allowShortBlockEnchanting;
    @Config(description="Candles with soul sand below them or below the bookshelves dampen enchantments instead of influence them.")
    public static boolean soulCandlesInvert;
    @Config(description="A list of enchantment IDs you don't want the enchantment table to be able to create")
    public static List<String> disallowedEnchantments;
    @Config(description="An array of influences each candle should apply. This list must be 16 elements long, and is in order of wool colors.\nA minus sign before an enchantment will make the influence decrease the probability of that enchantment.")
    private static List<String> influencesList;
    @Config(description="An array of influences that other blocks should apply.\nFormat is: \"blockstate;strength;color;enchantments\", i.e. \"minecraft:sea_pickle[pickles=1,waterlogged=false];1;#008000;minecraft:aqua_affinity,minecraft:depth_strider,minecraft:riptide\" (etc) or \"minecraft:anvil[facing=north];#808080;-minecraft:thorns,minecraft:unbreaking\" (etc)")
    private static List<String> statesToInfluences;
    @Config(description="Set to false to disable the ability to influence enchantment outcomes with candles", flag="candle_influencing")
    public static boolean allowInfluencing;
    public static boolean candleInfluencingFailed;
    @Config(description="The max amount of candles that can influence a single enchantment")
    public static int influenceMax;
    @Config(description="How much each candle influences an enchantment. This works as a multiplier to its weight")
    public static double influencePower;
    @Config(description="If you set this to false, the vanilla Enchanting Table will no longer automatically convert to the Matrix Enchanting table. You'll have to add a recipe for the Matrix Enchanting Table to make use of this.", flag="matrix_enchanting_autoconvert")
    public static boolean automaticallyConvert;
    public static Map<DyeColor, Influence> candleInfluences;
    public static Map<BlockState, CustomInfluence> customInfluences;
    public static Block matrixEnchanter;
    public static ManualTrigger influenceTrigger;

    @LoadEvent
    public final void register(ZRegister event) {
        matrixEnchanter = new MatrixEnchantingTableBlock(this);
        menuType = IForgeMenuType.create(MatrixEnchantingMenu::fromNetwork);
        Quark.ZETA.registry.register(menuType, "matrix_enchanting", Registries.f_256798_);
        blockEntityType = BlockEntityType.Builder.m_155273_(MatrixEnchantingTableBlockEntity::new, (Block[])new Block[]{matrixEnchanter}).m_58966_(null);
        Quark.ZETA.registry.register(blockEntityType, "matrix_enchanting", Registries.f_256922_);
        influenceTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("influence");
    }

    @PlayEvent
    public void addAdditionalHints(ZGatherHints event) {
        MutableComponent comp = Component.m_237115_((String)"quark.jei.hint.matrix_enchanting");
        if (allowInfluencing) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.matrix_influencing"));
        }
        event.accept((ItemLike)Items.f_42100_, (Component)comp);
        event.accept((ItemLike)matrixEnchanter.m_5456_(), (Component)comp);
    }

    @LoadEvent
    public final void clientSetup(ZClientSetup event) {
        MenuScreens.m_96206_(menuType, MatrixEnchantingScreen::new);
        BlockEntityRenderers.m_173590_(blockEntityType, MatrixEnchantingTableRenderer::new);
    }

    @PlayEvent
    public void onBlockPlaced(ZBlock.EntityPlace event) {
        if (event.getPlacedBlock().m_60734_().equals(Blocks.f_50201_) && automaticallyConvert) {
            event.getLevel().m_7731_(event.getPos(), matrixEnchanter.m_49966_(), 3);
        }
    }

    @PlayEvent
    public void onRightClick(ZPlayerInteract.RightClickBlock event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        if (event.getLevel().m_8055_(event.getPos()).m_60734_() == Blocks.f_50201_ && automaticallyConvert) {
            event.getLevel().m_7731_(event.getPos(), matrixEnchanter.m_49966_(), 3);
        }
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        this.parseInfluences();
    }

    private Influence parseEnchantmentList(String enchantmentList) {
        String[] enchantments;
        ArrayList<Enchantment> boost = new ArrayList<Enchantment>();
        ArrayList<Enchantment> dampen = new ArrayList<Enchantment>();
        for (String enchStr : enchantments = enchantmentList.split(",")) {
            Enchantment ench;
            boolean damp = enchStr.startsWith("-");
            if (damp) {
                enchStr = enchStr.substring(1);
            }
            if ((ench = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation(enchStr))) != null) {
                if (damp) {
                    dampen.add(ench);
                    continue;
                }
                boost.add(ench);
                continue;
            }
            Quark.LOG.error("Matrix Enchanting Influencing: Enchantment " + enchStr + " does not exist!");
        }
        return new Influence(boost, dampen);
    }

    private void parseInfluences() {
        candleInfluences.clear();
        customInfluences.clear();
        for (String influence : statesToInfluences) {
            int color;
            int strength;
            String[] split = influence.split(";");
            if (split.length != 4) continue;
            BlockState state = MiscUtil.fromString((String)split[0]);
            try {
                strength = Integer.parseInt(split[1]);
                color = Integer.parseInt(split[2], 16);
            }
            catch (NumberFormatException e) {
                continue;
            }
            Influence boosts = this.parseEnchantmentList(split[3]);
            customInfluences.put(state, new CustomInfluence(strength, color, boosts));
        }
        if (influencesList.size() < 16) {
            new IllegalArgumentException("Matrix Enchanting Influences must be of at least size 16, please fix this in the config.").printStackTrace();
            candleInfluencingFailed = true;
        } else {
            for (int i = 0; i < influencesList.size(); ++i) {
                if (i >= DyeColor.values().length) continue;
                candleInfluences.put(DyeColor.values()[i], this.parseEnchantmentList(influencesList.get(i)));
            }
        }
    }

    static {
        maxBookshelves = 15;
        piecePriceScale = 9;
        bookEnchantability = 12;
        baseMaxPieceCount = 3;
        baseMaxPieceCountBook = 1;
        minLevelCutoff = 8;
        chargePerLapis = 4;
        minLevelScaleFactor = 1.2;
        minLevelScaleFactorBook = 2.0;
        dupeMultiplier = 1.4;
        incompatibleMultiplier = 0.0;
        allowBooks = true;
        allowTreasures = false;
        treasureWhitelist = Lists.newArrayList();
        showTooltip = true;
        normalizeRarity = true;
        allowUnderwaterEnchanting = true;
        allowShortBlockEnchanting = true;
        soulCandlesInvert = true;
        disallowedEnchantments = Lists.newArrayList();
        influencesList = Lists.newArrayList((Object[])new String[]{"minecraft:unbreaking", "minecraft:fire_protection", "minecraft:knockback,minecraft:punch", "minecraft:feather_falling", "minecraft:looting,minecraft:fortune,minecraft:luck_of_the_sea", "minecraft:blast_protection", "minecraft:silk_touch,minecraft:channeling", "minecraft:bane_of_arthropods", "minecraft:protection", "minecraft:respiration,minecraft:loyalty,minecraft:infinity", "minecraft:sweeping,minecraft:multishot", "minecraft:efficiency,minecraft:sharpness,minecraft:lure,minecraft:power,minecraft:impaling,minecraft:quick_charge", "minecraft:aqua_affinity,minecraft:depth_strider,minecraft:riptide", "minecraft:thorns,minecraft:piercing", "minecraft:fire_aspect,minecraft:flame", "minecraft:smite,minecraft:projectile_protection"});
        statesToInfluences = Lists.newArrayList();
        allowInfluencing = true;
        candleInfluencingFailed = false;
        influenceMax = 4;
        influencePower = 0.125;
        automaticallyConvert = true;
        candleInfluences = new HashMap<DyeColor, Influence>();
        customInfluences = new HashMap<BlockState, CustomInfluence>();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends MatrixEnchantingModule {
        @PlayEvent
        public void onTooltip(ZItemTooltip event) {
            ItemStack stack = event.getItemStack();
            if (showTooltip && ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"quark:enchantingMatrix")) {
                event.getToolTip().add(Component.m_237115_((String)"quark.gui.enchanting.pending").m_130940_(ChatFormatting.AQUA));
            }
        }
    }
}

