/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.api.common.ai.witherstorm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.fml.ModLoader;
import nonamecrackers2.witherstormmod.api.common.ai.witherstorm.RegisterWorldInteractionsEvent;
import nonamecrackers2.witherstormmod.api.common.ai.witherstorm.clustersource.BlockClusterSource;
import nonamecrackers2.witherstormmod.api.common.ai.witherstorm.pullbehavior.WitherStormPullBehavior;

public class WitherStormWorldInteractions {
    @Nullable
    private static WitherStormWorldInteractions instance;
    private final Map<EntityType<?>, WitherStormPullBehavior<?>> pullBehaviors;
    private final List<BlockClusterSource> sources;

    private WitherStormWorldInteractions(Map<EntityType<?>, WitherStormPullBehavior<?>> pullBehaviors, List<BlockClusterSource> sources) {
        this.pullBehaviors = pullBehaviors;
        this.sources = sources;
    }

    public <T extends Entity> WitherStormPullBehavior<T> getPullBehavior(EntityType<?> type) {
        return Objects.requireNonNull(this.pullBehaviors.get(type), "Pull behavior does not exist for entity!");
    }

    public boolean hasPullBehavior(EntityType<?> type) {
        return this.pullBehaviors.containsKey(type);
    }

    public List<BlockClusterSource> getClusterSources() {
        return this.sources;
    }

    public static void initialize() {
        if (instance != null) {
            throw new IllegalStateException("Cluster interactions have already been initialized!");
        }
        ArrayList postedEvents = Lists.newArrayList();
        ImmutableMap.Builder pullBehaviors = ImmutableMap.builder();
        ImmutableList.Builder sources = ImmutableList.builder();
        ModLoader.get().runEventGenerator(mod -> {
            RegisterWorldInteractionsEvent event = new RegisterWorldInteractionsEvent();
            postedEvents.add(event);
            return event;
        });
        for (RegisterWorldInteractionsEvent event : postedEvents) {
            pullBehaviors.putAll(event.pullBehaviors);
            sources.addAll(event.sources);
        }
        instance = new WitherStormWorldInteractions((Map<EntityType<?>, WitherStormPullBehavior<?>>)pullBehaviors.buildKeepingLast(), (List<BlockClusterSource>)sources.build());
    }

    public static WitherStormWorldInteractions getInstance() {
        return Objects.requireNonNull(instance, "Cluster interactions have not been initialized yet");
    }
}

