/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.compat.create;

import com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import earth.terrarium.adastra.common.blocks.LaunchPadBlock;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import earth.terrarium.adastra.common.registry.ModBlocks;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchPadInteractionPoint
extends ArmInteractionPointType {
    public LaunchPadInteractionPoint(ResourceLocation id) {
        super(id);
    }

    public boolean canCreatePoint(Level level, BlockPos blockPos, BlockState blockState) {
        return blockState.m_60713_((Block)ModBlocks.LAUNCH_PAD.get());
    }

    @Nullable
    public ArmInteractionPoint createPoint(Level level, BlockPos blockPos, BlockState blockState) {
        return new Point(this, level, blockPos, blockState);
    }

    public static class Point
    extends AllArmInteractionPointTypes.DepositOnlyArmInteractionPoint {
        private Optional<Rocket> locateRocket() {
            Block block = this.cachedState.m_60734_();
            if (!(block instanceof LaunchPadBlock)) {
                return Optional.empty();
            }
            LaunchPadBlock pad = (LaunchPadBlock)block;
            BlockPos controller = pad.getController(this.cachedState, this.pos);
            return this.level.m_6443_(Rocket.class, new AABB(controller).m_82400_(1.0), it -> !it.isLaunching() && !it.hasLaunched()).stream().findAny();
        }

        public Point(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        public void updateCachedState() {
            super.updateCachedState();
            this.cachedHandler = this.locateRocket().map(ItemHandler::new).map(it -> LazyOptional.of(() -> it)).orElseGet(LazyOptional::empty);
        }
    }

    public static class ItemHandler
    implements IItemHandler {
        private final Rocket rocket;

        public ItemHandler(Rocket rocket) {
            this.rocket = rocket;
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int i) {
            return ItemStack.f_41583_;
        }

        private Optional<FluidHolder> getFuel(ItemStack arg) {
            if (!FluidContainer.holdsFluid((ItemStack)arg)) {
                return Optional.empty();
            }
            ItemFluidContainer container = FluidContainer.of((ItemStackHolder)new ItemStackHolder(arg));
            return Optional.of(container.getFirstFluid()).filter(it -> it.is(ModFluidTags.FUEL));
        }

        @NotNull
        public ItemStack insertItem(int i, @NotNull ItemStack arg, boolean bl) {
            if (!this.isItemValid(i, arg)) {
                return arg;
            }
            this.getFuel(arg).ifPresent(fluid -> this.rocket.fluidContainer().insertFluid(fluid, bl));
            return arg.getCraftingRemainingItem();
        }

        @NotNull
        public ItemStack extractItem(int i, int j, boolean bl) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int i) {
            return 1;
        }

        public boolean isItemValid(int i, @NotNull ItemStack arg) {
            return arg.m_41613_() == 1 && this.getFuel(arg).filter(it -> it.getFluidAmount() + this.rocket.fluid().getFluidAmount() <= this.rocket.fluidContainer().getTankCapacity(0)).isPresent();
        }
    }
}

