/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.stats.ToolType;

public class MomentumModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ConditionalStatModifierHook,
BlockBreakModifierHook,
BreakSpeedModifierHook,
TooltipModifierHook {
    private static final Component SPEED = TConstruct.makeTranslation("modifier", "momentum.speed");

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.BLOCK_BREAK, ModifierHooks.BREAK_SPEED, ModifierHooks.TOOLTIP);
    }

    @Override
    public int getPriority() {
        return 75;
    }

    private static float getBonus(LivingEntity living, ToolType type, ModifierEntry modifier) {
        return modifier.getEffectiveLevel() * (float)(((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get((Enum)type))).getLevel(living) + 1);
    }

    private static void applyEffect(LivingEntity living, ToolType type, int duration, int maxLevel) {
        TinkerEffect effect = (TinkerEffect)((Object)TinkerModifiers.momentumEffect.get((Enum)type));
        effect.apply(living, duration, Math.min(maxLevel, effect.getLevel(living) + 1), true);
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + MomentumModifier.getBonus((LivingEntity)event.getEntity(), ToolType.HARVEST, modifier) / 128.0f));
        }
    }

    @Override
    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        if (context.canHarvest() && context.isEffective() && !context.isAOE()) {
            int duration = (int)(10.0f / tool.getStats().get(ToolStats.MINING_SPEED).floatValue() * 1.5f * 20.0f);
            MomentumModifier.applyEffect(context.getLiving(), ToolType.HARVEST, duration, 31);
        }
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_())) {
            MomentumModifier.applyEffect(shooter, ToolType.RANGED, 100, 15);
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.DRAW_SPEED) {
            return baseValue * (1.0f + MomentumModifier.getBonus(living, ToolType.RANGED, modifier) / 64.0f);
        }
        return baseValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        ToolType type = ToolType.from(tool.getItem(), ToolType.NO_MELEE);
        if (type != null) {
            float bonus;
            if (player != null && key == TooltipKey.SHIFT) {
                float f = MomentumModifier.getBonus((LivingEntity)player, type, modifier);
                bonus = f / (switch (type) {
                    default -> 128.0f;
                    case ToolType.RANGED -> 64.0f;
                    case ToolType.ARMOR -> 4.0f;
                });
            } else {
                bonus = modifier.getEffectiveLevel();
                if (type != ToolType.ARMOR) {
                    bonus *= 0.25f;
                }
            }
            if (bonus > 0.0f) {
                if (type == ToolType.ARMOR) {
                    ProtectionModule.addResistanceTooltip(tool, this, bonus * 2.5f, player, tooltip);
                } else {
                    TooltipModifierHook.addPercentBoost(this, SPEED, bonus, tooltip);
                }
            }
        }
    }
}

