/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.sling;

import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.modifiers.ability.sling.SlingModifier;

public class BonkingModifier
extends SlingModifier
implements MeleeHitModifierHook,
MeleeDamageModifierHook {
    private static final float RANGE = 5.0f;
    private static boolean isBonking = false;

    @Override
    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook(this, ModifierHooks.MELEE_HIT);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!tool.isBroken() && source == InteractionSource.RIGHT_CLICK) {
            float speed = ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.DRAW_SPEED);
            if (tool.hasTag(TinkerTags.Items.MELEE_WEAPON)) {
                speed *= tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue();
            }
            tool.getPersistentData().putInt(GeneralInteractionModifierHook.KEY_DRAWTIME, (int)Math.ceil(30.0f / speed));
            GeneralInteractionModifierHook.startUsing(tool, modifier.getId(), (LivingEntity)player, hand);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        if (isBonking) {
            knockback = 0.0f;
        }
        return knockback;
    }

    @Override
    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        if (isBonking) {
            damage *= 1.5f;
        }
        return damage;
    }

    @Override
    public void onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        super.onStoppedUsing(tool, modifier, entity, timeLeft);
        Level level = entity.m_9236_();
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            float f = this.getForce(tool, modifier, (LivingEntity)player, timeLeft, true);
            if (f > 0.0f) {
                AABB bb;
                Vec3 start = player.m_20299_(1.0f);
                Vec3 look = player.m_20154_();
                Vec3 direction = start.m_82520_(look.f_82479_ * 5.0, look.f_82480_ * 5.0, look.f_82481_ * 5.0);
                EntityHitResult hit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)start, (Vec3)direction, (AABB)(bb = player.m_20191_().m_82363_(look.f_82479_ * 5.0, look.f_82480_ * 5.0, look.f_82481_ * 5.0).m_82363_(1.0, 1.0, 1.0)), e -> e instanceof LivingEntity);
                if (hit != null) {
                    LivingEntity target = (LivingEntity)hit.m_82443_();
                    double targetDist = start.m_82557_(target.m_20299_(1.0f));
                    BlockHitResult mop = ModifiableItem.blockRayTrace(level, player, ClipContext.Fluid.NONE);
                    if (mop.m_6662_() != HitResult.Type.BLOCK || targetDist < mop.m_82425_().m_203193_((Position)start)) {
                        if (tool.hasTag(TinkerTags.Items.MELEE)) {
                            isBonking = true;
                            InteractionHand hand = player.m_7655_();
                            ToolAttackUtil.attackEntity(tool, entity, hand, (Entity)target, () -> Math.min(1.0f, f), true);
                            isBonking = false;
                        }
                        float inaccuracy = ModifierUtil.getInaccuracy(tool, (LivingEntity)player) * 0.0075f;
                        RandomSource random = player.m_217043_();
                        target.m_147240_((double)(f * 3.0f), -look.f_82479_ + random.m_188583_() * (double)inaccuracy, -look.f_82481_ + random.m_188583_() * (double)inaccuracy);
                        ToolAttackUtil.spawnAttackParticle((ParticleOptions)TinkerTools.bonkAttackParticle.get(), (Entity)player, 0.6);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer playerMP = (ServerPlayer)player;
                            TinkerNetwork.getInstance().sendVanillaPacket((Packet)new ClientboundSetEntityMotionPacket((Entity)player), (Entity)playerMP);
                        }
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), Sounds.BONK.getSound(), player.m_5720_(), 1.0f, 0.5f);
                        player.m_36399_(0.2f);
                        player.m_36335_().m_41524_(tool.getItem(), 3);
                        ToolDamageUtil.damageAnimated(tool, 1, entity);
                        return;
                    }
                }
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), Sounds.BONK.getSound(), player.m_5720_(), 1.0f, 1.0f);
        }
    }
}

