/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class DoubleJumpModifier
extends Modifier {
    private static final ResourceLocation JUMPS = TConstruct.getResource("jumps");
    private static final TinkerDataCapability.TinkerDataKey<Integer> EXTRA_JUMPS = TConstruct.createKey("extra_jumps");
    private Component levelOneName = null;
    private Component levelTwoName = null;

    public DoubleJumpModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, DoubleJumpModifier::onLand);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(new ArmorLevelModule(EXTRA_JUMPS, false, null));
    }

    @Override
    public Component getDisplayName(int level) {
        if (level == 1) {
            if (this.levelOneName == null) {
                this.levelOneName = this.applyStyle(Component.m_237115_((String)(this.getTranslationKey() + ".double")));
            }
            return this.levelOneName;
        }
        if (level == 2) {
            if (this.levelTwoName == null) {
                this.levelTwoName = this.applyStyle(Component.m_237115_((String)(this.getTranslationKey() + ".triple")));
            }
            return this.levelTwoName;
        }
        return super.getDisplayName(level);
    }

    public static boolean extraJump(Player entity) {
        int maxJumps;
        if (!(entity.m_20096_() || entity.m_6147_() || entity.m_20072_() || (maxJumps = entity.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> data.get(EXTRA_JUMPS)).orElse(0).intValue()) <= 0)) {
            return entity.getCapability(PersistentDataCapability.CAPABILITY).filter(data -> {
                int jumps = data.getInt(JUMPS);
                if (jumps < maxJumps) {
                    entity.m_6135_();
                    RandomSource random = entity.m_20193_().m_213780_();
                    for (int i = 0; i < 4; ++i) {
                        entity.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_() - 0.25 + (double)(random.m_188501_() * 0.5f), entity.m_20186_(), entity.m_20189_() - 0.25 + (double)(random.m_188501_() * 0.5f), 0.0, 0.0, 0.0);
                    }
                    entity.m_5496_(Sounds.EXTRA_JUMP.getSound(), 0.5f, 0.5f);
                    data.putInt(JUMPS, jumps + 1);
                    return true;
                }
                return false;
            }).isPresent();
        }
        return false;
    }

    private static void onLand(LivingFallEvent event) {
        event.getEntity().getCapability(PersistentDataCapability.CAPABILITY).ifPresent(data -> data.remove(JUMPS));
    }
}

