/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.utils.GenericTagUtil;

public class UpdateMaterialsPacket
implements IThreadsafePacket {
    private final Map<MaterialId, IMaterial> materials;
    private final Map<MaterialId, MaterialId> redirects;
    private final Map<TagKey<IMaterial>, List<IMaterial>> tags;

    public UpdateMaterialsPacket(FriendlyByteBuf buffer) {
        int materialCount = buffer.readInt();
        ImmutableMap.Builder materials = ImmutableMap.builder();
        for (int i = 0; i < materialCount; ++i) {
            MaterialId id2 = new MaterialId(buffer.m_130281_());
            int tier = buffer.m_130242_();
            int sortOrder = buffer.m_130242_();
            boolean craftable = buffer.readBoolean();
            boolean hidden = buffer.readBoolean();
            materials.put((Object)id2, (Object)new Material(id2, tier, sortOrder, craftable, hidden));
        }
        this.materials = materials.build();
        int redirectCount = buffer.m_130242_();
        if (redirectCount == 0) {
            this.redirects = Collections.emptyMap();
        } else {
            this.redirects = new HashMap<MaterialId, MaterialId>(redirectCount);
            for (int i = 0; i < redirectCount; ++i) {
                this.redirects.put(new MaterialId(buffer.m_130277_()), new MaterialId(buffer.m_130277_()));
            }
        }
        this.tags = GenericTagUtil.decodeTags(buffer, MaterialManager.REGISTRY_KEY, id -> this.materials.get(new MaterialId((ResourceLocation)id)));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.materials.size());
        this.materials.values().forEach(material -> {
            buffer.m_130085_((ResourceLocation)material.getIdentifier());
            buffer.m_130130_(material.getTier());
            buffer.m_130130_(material.getSortOrder());
            buffer.writeBoolean(material.isCraftable());
            buffer.writeBoolean(material.isHidden());
        });
        buffer.m_130130_(this.redirects.size());
        this.redirects.forEach((key, value) -> {
            buffer.m_130070_(key.toString());
            buffer.m_130070_(value.toString());
        });
        GenericTagUtil.encodeTags(buffer, IMaterial::getIdentifier, this.tags);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        MaterialRegistry.updateMaterialsFromServer(this);
    }

    public Map<MaterialId, IMaterial> getMaterials() {
        return this.materials;
    }

    public Map<MaterialId, MaterialId> getRedirects() {
        return this.redirects;
    }

    public Map<TagKey<IMaterial>, List<IMaterial>> getTags() {
        return this.tags;
    }

    public UpdateMaterialsPacket(Map<MaterialId, IMaterial> materials, Map<MaterialId, MaterialId> redirects, Map<TagKey<IMaterial>, List<IMaterial>> tags) {
        this.materials = materials;
        this.redirects = redirects;
        this.tags = tags;
    }
}

