/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.IdParser;
import slimeknights.tconstruct.library.utils.ResourceId;

public final class MaterialId
extends ResourceId
implements MaterialVariantId {
    public static final IdParser<MaterialId> PARSER = new IdParser<MaterialId>(MaterialId::new, "Material");

    public MaterialId(String resourceName) {
        super(resourceName);
    }

    public MaterialId(String namespaceIn, String pathIn) {
        super(namespaceIn, pathIn);
    }

    public MaterialId(ResourceLocation location) {
        super(location);
    }

    private MaterialId(String namespace, String path, @Nullable ResourceLocation.Dummy pDummy) {
        super(namespace, path, pDummy);
    }

    public boolean matches(IMaterial material) {
        return this.equals(material.getIdentifier());
    }

    public boolean matches(ItemStack stack) {
        return !stack.m_41619_() && this.equals(IMaterialItem.getMaterialFromStack(stack));
    }

    @Override
    public MaterialId getId() {
        return this;
    }

    @Override
    public String getVariant() {
        return "";
    }

    @Override
    public boolean hasVariant() {
        return false;
    }

    @Override
    public ResourceLocation getLocation(char separator) {
        return this;
    }

    @Override
    public String getSuffix() {
        return this.m_135827_() + "_" + this.m_135815_();
    }

    @Override
    public boolean matchesVariant(MaterialVariantId other) {
        return this.equals(other.getId());
    }

    @Nullable
    public static MaterialId tryParse(String string) {
        return MaterialId.tryParse(string, (namespace, path) -> new MaterialId((String)namespace, (String)path, null));
    }

    @Nullable
    public static MaterialId tryBuild(String namespace, String path) {
        return MaterialId.tryBuild(namespace, path, (n, p) -> new MaterialId(namespace, path, null));
    }
}

