/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.mantle.registration.deferred.BlockEntityTypeDeferredRegister;
import slimeknights.mantle.registration.deferred.EntityTypeDeferredRegister;
import slimeknights.mantle.registration.deferred.FluidDeferredRegister;
import slimeknights.mantle.registration.deferred.MenuTypeDeferredRegister;
import slimeknights.mantle.registration.deferred.SynchronizedDeferredRegister;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.registration.BlockDeferredRegisterExtension;
import slimeknights.tconstruct.common.registration.EnumDeferredRegister;
import slimeknights.tconstruct.common.registration.ItemDeferredRegisterExtension;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;

public abstract class TinkerModule {
    protected static final BlockDeferredRegisterExtension BLOCKS = new BlockDeferredRegisterExtension("tconstruct");
    protected static final ItemDeferredRegisterExtension ITEMS = new ItemDeferredRegisterExtension("tconstruct");
    protected static final FluidDeferredRegister FLUIDS = new FluidDeferredRegister("tconstruct");
    protected static final EnumDeferredRegister<MobEffect> MOB_EFFECTS = new EnumDeferredRegister(Registries.f_256929_, "tconstruct");
    protected static final SynchronizedDeferredRegister<ParticleType<?>> PARTICLE_TYPES = SynchronizedDeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"tconstruct");
    protected static final SynchronizedDeferredRegister<EntityDataSerializer<?>> DATA_SERIALIZERS = SynchronizedDeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"tconstruct");
    protected static final SynchronizedDeferredRegister<CreativeModeTab> CREATIVE_TABS = SynchronizedDeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"tconstruct");
    protected static final BlockEntityTypeDeferredRegister BLOCK_ENTITIES = new BlockEntityTypeDeferredRegister("tconstruct");
    protected static final EntityTypeDeferredRegister ENTITIES = new EntityTypeDeferredRegister("tconstruct");
    protected static final MenuTypeDeferredRegister MENUS = new MenuTypeDeferredRegister("tconstruct");
    protected static final SynchronizedDeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = SynchronizedDeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"tconstruct");
    protected static final SynchronizedDeferredRegister<Codec<? extends IGlobalLootModifier>> GLOBAL_LOOT_MODIFIERS = SynchronizedDeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"tconstruct");
    protected static final SynchronizedDeferredRegister<LootItemConditionType> LOOT_CONDITIONS = SynchronizedDeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"tconstruct");
    protected static final SynchronizedDeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS = SynchronizedDeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"tconstruct");
    protected static final SynchronizedDeferredRegister<LootPoolEntryType> LOOT_ENTRIES = SynchronizedDeferredRegister.create((ResourceKey)Registries.f_257032_, (String)"tconstruct");
    protected static final Item.Properties ITEM_PROPS = new Item.Properties();
    protected static final Item.Properties UNSTACKABLE_PROPS = new Item.Properties().m_41487_(1);
    protected static final Function<Block, ? extends BlockItem> BLOCK_ITEM = b -> new BlockItem(b, ITEM_PROPS);
    protected static final Function<Block, ? extends BlockItem> TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, ITEM_PROPS);
    protected static final Function<Block, ? extends BlockItem> UNSTACKABLE_BLOCK_ITEM = b -> new BlockTooltipItem(b, UNSTACKABLE_PROPS);
    protected static final Supplier<Item> TOOLTIP_ITEM = () -> new TooltipItem(ITEM_PROPS);

    protected TinkerModule() {
        TConstruct.sealTinkersClass(this, "TinkerModule", "This is a bug with the mod containing that class, they should create their own deferred registers.");
    }

    public static void initRegisters() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        FLUIDS.register(bus);
        MOB_EFFECTS.register(bus);
        PARTICLE_TYPES.register(bus);
        DATA_SERIALIZERS.register(bus);
        CREATIVE_TABS.register(bus);
        BLOCK_ENTITIES.register(bus);
        ENTITIES.register(bus);
        MENUS.register(bus);
        RECIPE_SERIALIZERS.register(bus);
        GLOBAL_LOOT_MODIFIERS.register(bus);
        LOOT_CONDITIONS.register(bus);
        LOOT_FUNCTIONS.register(bus);
        LOOT_ENTRIES.register(bus);
        TinkerRecipeTypes.init(bus);
    }

    protected static BlockBehaviour.Properties builder(SoundType soundType) {
        return BlockBehaviour.Properties.m_284310_().m_60918_(soundType);
    }

    protected static BlockBehaviour.Properties builder(MapColor color, SoundType soundType) {
        return TinkerModule.builder(soundType).m_284180_(color);
    }

    protected static BlockBehaviour.Properties metalBuilder(MapColor color) {
        return TinkerModule.builder(color, SoundType.f_56743_).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60978_(5.0f);
    }

    protected static BlockBehaviour.Properties glassBuilder(MapColor color) {
        return TinkerModule.builder(color, SoundType.f_56744_).m_280658_(NoteBlockInstrument.HAT).m_60978_(0.3f).m_60955_().m_60922_(Blocks::m_50778_).m_60924_(Blocks::m_50805_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_);
    }

    protected static BlockBehaviour.Properties woodBuilder(MapColor color) {
        return TinkerModule.builder(color, SoundType.f_56736_).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 7.0f).m_278183_();
    }

    protected static <T> ResourceKey<T> key(ResourceKey<? extends Registry<T>> registry, String name) {
        return ResourceKey.m_135785_(registry, (ResourceLocation)TConstruct.getResource(name));
    }

    protected static void accept(CreativeModeTab.Output output, EnumObject<?, ? extends ItemLike> items, CreativeModeTab.TabVisibility visibility) {
        items.forEach(item -> output.m_245282_(item, visibility));
    }

    protected static void accept(CreativeModeTab.Output output, EnumObject<?, ? extends ItemLike> items) {
        TinkerModule.accept(output, items, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    protected static void accept(CreativeModeTab.Output output, BuildingBlockObject object, CreativeModeTab.TabVisibility visibility) {
        object.forEach(item -> output.m_245282_(item, visibility));
    }

    protected static void accept(CreativeModeTab.Output output, BuildingBlockObject object) {
        TinkerModule.accept(output, object, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    protected static boolean acceptIfTag(CreativeModeTab.Output output, ItemLike item, CreativeModeTab.TabVisibility visibility, TagKey<Item> tagCondition) {
        Optional tag = BuiltInRegistries.f_257033_.m_203431_(tagCondition);
        if (tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0) {
            output.m_245282_(item, visibility);
            return true;
        }
        return false;
    }

    protected static boolean acceptIfTag(CreativeModeTab.Output output, ItemLike item, TagKey<Item> tagCondition) {
        return TinkerModule.acceptIfTag(output, item, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, tagCondition);
    }
}

