/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.registry;

import com.mojang.serialization.Codec;
import com.teamabnormals.neapolitan.common.levelgen.feature.AdzukiSproutsFeature;
import com.teamabnormals.neapolitan.common.levelgen.feature.BananaPlantFeature;
import com.teamabnormals.neapolitan.common.levelgen.feature.MintPondFeature;
import com.teamabnormals.neapolitan.common.levelgen.feature.StrawberryBushFeature;
import com.teamabnormals.neapolitan.common.levelgen.feature.VanillaPatchFeature;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class NeapolitanFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"neapolitan");
    public static final RegistryObject<Feature<SimpleBlockConfiguration>> STRAWBERRY_BUSH = FEATURES.register("strawberry_bush", () -> new StrawberryBushFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.f_68068_));
    public static final RegistryObject<Feature<RandomPatchConfiguration>> VANILLA_VINE_PATCH = FEATURES.register("vanilla_patch", () -> new VanillaPatchFeature((Codec<RandomPatchConfiguration>)RandomPatchConfiguration.f_67902_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> BANANA_PLANT = FEATURES.register("banana_plant", () -> new BananaPlantFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<SimpleBlockConfiguration>> ADZUKI_SPROUTS = FEATURES.register("adzuki_sprouts", () -> new AdzukiSproutsFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.f_68068_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> MINT_POND = FEATURES.register("mint_pond", () -> new MintPondFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public static final class NeapolitanPlacedFeatures {
        public static final ResourceKey<PlacedFeature> PATCH_STRAWBERRY_BUSH = NeapolitanPlacedFeatures.createKey("patch_strawberry_bush");
        public static final ResourceKey<PlacedFeature> PATCH_VANILLA_VINE = NeapolitanPlacedFeatures.createKey("patch_vanilla_vine");
        public static final ResourceKey<PlacedFeature> PATCH_ADZUKI_SPROUTS = NeapolitanPlacedFeatures.createKey("patch_adzuki_sprouts");
        public static final ResourceKey<PlacedFeature> MINT_POND = NeapolitanPlacedFeatures.createKey("mint_pond");
        public static final ResourceKey<PlacedFeature> BANANA_PLANT_COMMON = NeapolitanPlacedFeatures.createKey("banana_plant_common");
        public static final ResourceKey<PlacedFeature> BANANA_PLANT_UNCOMMON = NeapolitanPlacedFeatures.createKey("banana_plant_uncommon");
        public static final ResourceKey<PlacedFeature> BANANA_PLANT_RARE = NeapolitanPlacedFeatures.createKey("banana_plant_rare");

        public static void bootstrap(BootstapContext<PlacedFeature> context) {
            NeapolitanPlacedFeatures.register(context, PATCH_STRAWBERRY_BUSH, NeapolitanConfiguredFeatures.PATCH_STRAWBERRY_BUSH, new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
            NeapolitanPlacedFeatures.register(context, PATCH_VANILLA_VINE, NeapolitanConfiguredFeatures.PATCH_VANILLA_VINE, new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
            NeapolitanPlacedFeatures.register(context, PATCH_ADZUKI_SPROUTS, NeapolitanConfiguredFeatures.PATCH_ADZUKI_SPROUTS, new PlacementModifier[]{RarityFilter.m_191900_((int)128), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
            NeapolitanPlacedFeatures.register(context, MINT_POND, NeapolitanConfiguredFeatures.MINT_POND, new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
            NeapolitanPlacedFeatures.register(context, BANANA_PLANT_COMMON, NeapolitanConfiguredFeatures.BANANA_PLANT, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.25f, (int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
            NeapolitanPlacedFeatures.register(context, BANANA_PLANT_UNCOMMON, NeapolitanConfiguredFeatures.BANANA_PLANT, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
            NeapolitanPlacedFeatures.register(context, BANANA_PLANT_RARE, NeapolitanConfiguredFeatures.BANANA_PLANT, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.05f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        }

        public static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("neapolitan", name));
        }

        public static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureHolder, PlacementModifier ... modifiers) {
            context.m_255272_(key, (Object)new PlacedFeature((Holder)context.m_255420_(Registries.f_256911_).m_255043_(configuredFeatureHolder), List.of(modifiers)));
        }
    }

    public static final class NeapolitanConfiguredFeatures {
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_STRAWBERRY_BUSH = NeapolitanConfiguredFeatures.createKey("patch_strawberry_bush");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_VANILLA_VINE = NeapolitanConfiguredFeatures.createKey("patch_vanilla_vine");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_ADZUKI_SPROUTS = NeapolitanConfiguredFeatures.createKey("patch_adzuki_sprouts");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MINT_POND = NeapolitanConfiguredFeatures.createKey("mint_pond");
        public static final ResourceKey<ConfiguredFeature<?, ?>> BANANA_PLANT = NeapolitanConfiguredFeatures.createKey("banana_plant");

        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
            NeapolitanConfiguredFeatures.register(context, PATCH_STRAWBERRY_BUSH, Feature.f_65763_, new RandomPatchConfiguration(512, 5, 3, PlacementUtils.m_206498_((Feature)((Feature)STRAWBERRY_BUSH.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)NeapolitanBlocks.STRAWBERRY_BUSH.get()).m_49966_())), (BlockPredicate)NeapolitanConfiguredFeatures.simplePatchPredicate(List.of(Blocks.f_50440_, Blocks.f_50546_)))));
            NeapolitanConfiguredFeatures.register(context, PATCH_VANILLA_VINE, (Feature)VANILLA_VINE_PATCH.get(), new RandomPatchConfiguration(64, 7, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)NeapolitanBlocks.VANILLA_VINE.get()).m_49966_())), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190419_(), (BlockPredicate)BlockPredicate.f_190393_))));
            NeapolitanConfiguredFeatures.register(context, PATCH_ADZUKI_SPROUTS, Feature.f_65763_, new RandomPatchConfiguration(256, 3, 2, PlacementUtils.m_206498_((Feature)((Feature)ADZUKI_SPROUTS.get()), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)NeapolitanBlocks.ADZUKI_SPROUTS.get()).m_49966_())), (BlockPredicate)NeapolitanConfiguredFeatures.simplePatchPredicate(List.of(Blocks.f_50440_)))));
            NeapolitanConfiguredFeatures.register(context, MINT_POND, (Feature)MINT_POND.get(), FeatureConfiguration.f_67737_);
            NeapolitanConfiguredFeatures.register(context, BANANA_PLANT, (Feature)BANANA_PLANT.get(), FeatureConfiguration.f_67737_);
        }

        private static BlockPredicate simplePatchPredicate(List<Block> matchBlocks) {
            BlockPredicate blockpredicate = !matchBlocks.isEmpty() ? BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.f_190393_, (BlockPredicate)BlockPredicate.m_224771_((Vec3i)Direction.DOWN.m_122436_(), matchBlocks)) : BlockPredicate.f_190393_;
            return blockpredicate;
        }

        public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("neapolitan", name));
        }

        public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
            context.m_255272_(key, (Object)new ConfiguredFeature(feature, config));
        }
    }
}

