/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.betterarcheology.block.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.Pandarix.betterarcheology.block.custom.FossilBaseBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SheepFossilBlock
extends FossilBaseBlock {
    public static final BooleanProperty PLAYING = BooleanProperty.m_61465_((String)"playing");
    private static final int playCooldown = 80;
    public static final IntegerProperty HORN_SOUND = IntegerProperty.m_61631_((String)"horn_sound", (int)0, (int)7);
    private static final Map<Direction, VoxelShape> SHEEP_SHAPES_FOR_DIRECTION = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)17.75, (double)19.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)9.0, (double)0.0, (double)12.0, (double)17.75, (double)4.0), Block.m_49796_((double)3.75, (double)14.0, (double)-7.5, (double)12.0, (double)25.0, (double)5.0)}), (Object)Direction.SOUTH, (Object)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)-3.0, (double)12.0, (double)17.75, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)9.0, (double)12.0, (double)12.0, (double)17.75, (double)16.0), Block.m_49796_((double)4.0, (double)14.0, (double)11.0, (double)12.25, (double)25.0, (double)23.5)}), (Object)Direction.EAST, (Object)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)-3.0, (double)0.0, (double)4.0, (double)12.0, (double)17.75, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)9.0, (double)4.0, (double)16.0, (double)17.75, (double)12.0), Block.m_49796_((double)11.0, (double)14.0, (double)3.75, (double)23.5, (double)25.0, (double)12.0)}), (Object)Direction.WEST, (Object)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)19.0, (double)17.75, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)9.0, (double)4.0, (double)4.0, (double)17.75, (double)12.0), Block.m_49796_((double)-7.5, (double)14.0, (double)4.0, (double)5.0, (double)25.0, (double)12.25)}));

    public SheepFossilBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORN_SOUND, (Comparable)Integer.valueOf(0))).m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHEEP_SHAPES_FOR_DIRECTION.get(pState.m_61143_((Property)FACING));
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean powered = level.m_276867_(pos) || level.m_276867_(pos.m_7494_());
        boolean playing = (Boolean)state.m_61143_((Property)PLAYING);
        if (powered && !playing) {
            if (!level.m_5776_()) {
                level.m_247517_(null, pos, (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(((Integer)state.m_61143_((Property)HORN_SOUND)).intValue())).m_203334_(), SoundSource.BLOCKS);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(true)), 3);
            level.m_186460_(pos, (Block)this, 80);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (((Boolean)pState.m_61143_((Property)PLAYING)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (!pLevel.m_5776_()) {
            if ((Integer)pState.m_61143_((Property)HORN_SOUND) + 1 <= 7) {
                pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)HORN_SOUND, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)HORN_SOUND) + 1))).m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)HORN_SOUND, (Comparable)Integer.valueOf(0))).m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(true)), 3);
            }
            pLevel.m_247517_(null, pPos, (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(((Integer)pLevel.m_8055_(pPos).m_61143_((Property)HORN_SOUND)).intValue())).m_203334_(), SoundSource.BLOCKS);
            pLevel.m_186460_(pPos, (Block)this, 80);
        } else {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.5, (double)pPos.m_123343_() + 0.5, 0.0, 0.2, 0.0);
        }
        return InteractionResult.SUCCESS;
    }

    @ParametersAreNonnullByDefault
    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(false)), 3);
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{HORN_SOUND, PLAYING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@NotNull ItemStack stack, BlockGetter getter, List<Component> component, @NotNull TooltipFlag flag) {
        component.add((Component)Component.m_237115_((String)"block.betterarcheology.sheep_fossil_tooltip").m_130940_(ChatFormatting.GRAY));
        super.m_5871_(stack, getter, component, flag);
    }
}

