/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.integration.rei.baking_mat.forge;

import com.chefmooon.ubesdelight.common.crafting.forge.BakingMatRecipeImpl;
import com.chefmooon.ubesdelight.integration.rei.forge.REICategoryIdentifiersImpl;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class BakingMatRecipeDisplay
extends BasicDisplay {
    private EntryIngredient toolInput;
    private List<Pair<EntryIngredient, Float>> chanceOutputs;
    private final List<EntryIngredient> mandatoryOutputs;
    private final List<EntryIngredient> processStages;

    public BakingMatRecipeDisplay(BakingMatRecipeImpl recipe) {
        this(EntryIngredients.ofIngredients(recipe.m_7527_()), recipe.getResultList().stream().map(EntryIngredients::of).toList(), Optional.of(recipe.m_6423_()), EntryIngredients.ofIngredient((Ingredient)recipe.getTool()), EntryIngredients.ofIngredients(recipe.getProcessStages()), recipe.getMandatoryResults().stream().map(EntryIngredients::of).toList(), recipe.getVariableResult().stream().map(result -> Pair.of((Object)EntryIngredients.of((ItemStack)result.stack()), (Object)Float.valueOf(result.chance()))).toList());
    }

    public BakingMatRecipeDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location, CompoundTag compoundTag) {
        this(inputs, outputs, location, EntryIngredient.of((EntryStack)EntryStack.read((CompoundTag)compoundTag.m_128469_("tool"))), BakingMatRecipeDisplay.deserializeProcessingStages(compoundTag), BakingMatRecipeDisplay.deserializeMandatoryResults(compoundTag), BakingMatRecipeDisplay.deserializeChanceResults(compoundTag));
    }

    public BakingMatRecipeDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location, EntryIngredient tool, List<EntryIngredient> processStages, List<EntryIngredient> mandatoryOutputs, List<Pair<EntryIngredient, Float>> chanceOutputs) {
        super(inputs, outputs, location);
        this.toolInput = tool;
        this.mandatoryOutputs = mandatoryOutputs;
        this.chanceOutputs = chanceOutputs;
        this.processStages = processStages;
    }

    public static Point getItemOffset(int x, int y, int index) {
        int xOffset = 17;
        int yOffset = 17;
        Point[] points = new Point[]{new Point(x, y), new Point(x + 17, y), new Point(x - 17, y), new Point(x, y - 17), new Point(x, y + 17), new Point(x + 17, y - 17), new Point(x - 17, y - 17), new Point(x + 17, y + 17), new Point(x - 17, y + 17)};
        return points[index];
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REICategoryIdentifiersImpl.BAKING_MAT;
    }

    public List<EntryIngredient> getRequiredEntries() {
        ArrayList<EntryIngredient> requiredEntries = new ArrayList<EntryIngredient>(super.getRequiredEntries());
        requiredEntries.add(this.getToolInput());
        return ImmutableList.copyOf(requiredEntries);
    }

    public List<EntryIngredient> getInputEntries() {
        ArrayList<EntryIngredient> inputEntryList = new ArrayList<EntryIngredient>(super.getInputEntries());
        inputEntryList.add(this.getToolInput());
        inputEntryList.addAll(this.getProcessStages());
        return ImmutableList.copyOf(inputEntryList);
    }

    public List<EntryIngredient> getOutputEntries() {
        ArrayList<EntryIngredient> outputEntryList = new ArrayList<EntryIngredient>(super.getOutputEntries());
        outputEntryList.addAll(this.getProcessStages());
        return ImmutableList.copyOf(outputEntryList);
    }

    public List<EntryIngredient> getIngredientEntries() {
        return super.getInputEntries();
    }

    public EntryIngredient getToolInput() {
        return this.toolInput;
    }

    public List<Pair<EntryIngredient, Float>> getChanceOutputs() {
        return this.chanceOutputs;
    }

    public List<EntryIngredient> getMandatoryOutputs() {
        return this.mandatoryOutputs;
    }

    public List<EntryIngredient> getProcessStages() {
        return this.processStages;
    }

    private static List<Pair<EntryIngredient, Float>> deserializeChanceResults(CompoundTag tag) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ListTag innerTag = tag.m_128437_("chance_results", 10);
        for (int i = 0; i < innerTag.size(); ++i) {
            CompoundTag entry = innerTag.m_128728_(i);
            builder.add((Object)Pair.of((Object)EntryIngredient.of((EntryStack)EntryStack.read((CompoundTag)entry.m_128469_("stack"))), (Object)Float.valueOf(entry.m_128457_("chance"))));
        }
        return builder.build();
    }

    private static List<EntryIngredient> deserializeProcessingStages(CompoundTag tag) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ListTag innerTag = tag.m_128437_("processing_stages", 10);
        for (int i = 0; i < innerTag.size(); ++i) {
            CompoundTag entry = innerTag.m_128728_(i);
            builder.add((Object)EntryIngredient.of((EntryStack)EntryStack.read((CompoundTag)entry.m_128469_("stack"))));
        }
        return builder.build();
    }

    private static List<EntryIngredient> deserializeMandatoryResults(CompoundTag tag) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ListTag innerTag = tag.m_128437_("mandatory_results", 10);
        for (int i = 0; i < innerTag.size(); ++i) {
            CompoundTag entry = innerTag.m_128728_(i);
            builder.add((Object)EntryIngredient.of((EntryStack)EntryStack.read((CompoundTag)entry.m_128469_("stack"))));
        }
        return builder.build();
    }

    public static BasicDisplay.Serializer<BakingMatRecipeDisplay> serializer() {
        return BasicDisplay.Serializer.of(BakingMatRecipeDisplay::new, (display, tag) -> {
            display.toolInput = EntryIngredient.of((EntryStack)EntryStack.read((CompoundTag)tag.m_128469_("tool")));
            display.chanceOutputs = BakingMatRecipeDisplay.deserializeChanceResults(tag);
        });
    }
}

