/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.crafting.forge;

import com.chefmooon.ubesdelight.common.crafting.BakingMatRecipe;
import com.chefmooon.ubesdelight.common.crafting.ingredient.ChanceResult;
import com.chefmooon.ubesdelight.common.registry.forge.UbesDelightRecipeSerializersImpl;
import com.chefmooon.ubesdelight.common.registry.forge.UbesDelightRecipeTypesImpl;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BakingMatRecipeImpl
extends BakingMatRecipe
implements Recipe<RecipeWrapper> {
    public BakingMatRecipeImpl(ResourceLocation id, String group, NonNullList<Ingredient> ingredientList, NonNullList<Ingredient> processStages, Ingredient tool, NonNullList<ChanceResult> resultList, String soundEvent) {
        super(id, group, ingredientList, processStages, tool, resultList, soundEvent);
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredientList;
    }

    public NonNullList<Ingredient> getProcessStages() {
        return this.processStages;
    }

    public NonNullList<Ingredient> getIngredientsAndTool() {
        NonNullList ingredientTool = NonNullList.m_122779_();
        ingredientTool.addAll((Collection)this.ingredientList);
        ingredientTool.add((Object)this.tool);
        return this.ingredientList;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ((ChanceResult)this.resultList.get(0)).stack();
    }

    public List<ItemStack> getResultList() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public ItemStack getMandatoryResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).findFirst().get();
    }

    public List<ItemStack> getMandatoryResults() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).toList();
    }

    public List<ChanceResult> getVariableResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() != 1.0f).toList();
    }

    public NonNullList<ChanceResult> getRollableResults() {
        return this.resultList;
    }

    public String getSoundEventID() {
        return this.soundEvent;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        boolean inputMatch;
        boolean processMatch = false;
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            ++i;
            inputList.add(itemStack);
        }
        boolean bl = inputMatch = i == this.ingredientList.size() && RecipeMatcher.findMatches(inputList, (List)this.ingredientList) != null;
        if (this.processStages.size() > 0 && inputList.size() > 0) {
            for (Ingredient ingredient : this.processStages) {
                if (!Arrays.stream(ingredient.m_43908_()).findFirst().get().m_150930_(((ItemStack)inputList.get(0)).m_41720_())) continue;
                processMatch = true;
            }
        }
        return inputMatch || processMatch;
    }

    public ItemStack assemble(RecipeWrapper container, RegistryAccess registryAccess) {
        return ((ChanceResult)this.resultList.get(0)).stack().m_41777_();
    }

    public List<ItemStack> getRollResults(RandomSource rand, int fortuneLevel) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            ItemStack stack = output.chance() == 1.0f ? output.rollOutput(rand, fortuneLevel) : output.rollStackOutput(rand, fortuneLevel);
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        return results;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredientList.size();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)UbesDelightRecipeSerializersImpl.BAKING_MAT.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)UbesDelightRecipeTypesImpl.BAKING_MAT.get();
    }

    public String getSoundEvent() {
        return this.soundEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakingMatRecipeImpl that = (BakingMatRecipeImpl)o;
        if (!this.m_6423_().equals((Object)that.m_6423_())) {
            return false;
        }
        if (!this.m_6076_().equals(that.m_6076_())) {
            return false;
        }
        if (!this.ingredientList.equals((Object)that.ingredientList)) {
            return false;
        }
        if (!this.processStages.equals((Object)that.processStages)) {
            return false;
        }
        if (!this.getTool().equals(that.getTool())) {
            return false;
        }
        if (!this.getResultList().equals(that.getResultList())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        int result = this.m_6423_().hashCode();
        result = 31 * result + (this.m_6076_() != null ? this.m_6076_().hashCode() : 0);
        result = 31 * result + this.ingredientList.hashCode();
        result = 31 * result + this.processStages.hashCode();
        result = 31 * result + this.getTool().hashCode();
        result = 31 * result + this.getResultList().hashCode();
        result = 31 * result + (this.soundEvent != null ? this.soundEvent.hashCode() : 0);
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<BakingMatRecipeImpl> {
        public BakingMatRecipeImpl fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredientList = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            NonNullList<Ingredient> processingStages = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"processing_stages"));
            Ingredient tool = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"tool"));
            if (ingredientList.isEmpty()) {
                throw new JsonParseException("No ingredients for baking recipe");
            }
            if (tool.m_43947_()) {
                throw new JsonParseException("No tool for baking recipe");
            }
            if (ingredientList.size() > 9) {
                throw new JsonParseException("Too many ingredients for baking recipe! Max ingredients is 9");
            }
            if (processingStages.size() > 5) {
                throw new JsonParseException("Too many processing stages for baking recipe! Max processing stages is 5");
            }
            NonNullList<ChanceResult> results = Serializer.readResults(GsonHelper.m_13933_((JsonObject)json, (String)"result"));
            if (results.size() > 4) {
                throw new JsonParseException("Too many results for baking recipe! The maximum quantity of unique results is 4");
            }
            String soundID = GsonHelper.m_13851_((JsonObject)json, (String)"sound", (String)"");
            return new BakingMatRecipeImpl(id, group, ingredientList, processingStages, tool, results, soundID);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static NonNullList<ChanceResult> readResults(JsonArray resultArray) {
            NonNullList results = NonNullList.m_122779_();
            for (JsonElement result : resultArray) {
                results.add((Object)ChanceResult.deserialize(result));
            }
            return results;
        }

        public BakingMatRecipeImpl fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String groupIn = buf.m_130136_(Short.MAX_VALUE);
            int i = buf.m_130242_();
            NonNullList ingredientList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredientList.size(); ++j) {
                ingredientList.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            int k = buf.m_130242_();
            NonNullList processingStagesList = NonNullList.m_122780_((int)k, (Object)Ingredient.f_43901_);
            for (int l = 0; l < processingStagesList.size(); ++l) {
                processingStagesList.set(l, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int m = buf.m_130242_();
            NonNullList resultsList = NonNullList.m_122780_((int)m, (Object)ChanceResult.EMPTY);
            for (int n = 0; n < resultsList.size(); ++n) {
                resultsList.set(n, (Object)ChanceResult.read(buf));
            }
            String soundID = buf.m_130277_();
            return new BakingMatRecipeImpl(id, groupIn, (NonNullList<Ingredient>)ingredientList, (NonNullList<Ingredient>)processingStagesList, tool, (NonNullList<ChanceResult>)resultsList, soundID);
        }

        public void toNetwork(FriendlyByteBuf buf, BakingMatRecipeImpl recipe) {
            buf.m_130070_(recipe.group);
            buf.m_130130_(recipe.ingredientList.size());
            for (Ingredient ingredient : recipe.ingredientList) {
                ingredient.m_43923_(buf);
            }
            buf.m_130130_(recipe.processStages.size());
            for (Ingredient processingStages : recipe.processStages) {
                processingStages.m_43923_(buf);
            }
            recipe.tool.m_43923_(buf);
            buf.m_130130_(recipe.resultList.size());
            for (ChanceResult result : recipe.resultList) {
                result.write(buf);
            }
            buf.m_130070_(recipe.soundEvent);
        }
    }
}

