/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.state.properties.LeafFeastTypeProperty;
import com.chefmooon.ubesdelight.common.block.state.properties.UbesDelightBlockStateProperties;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightAdvancements;
import com.chefmooon.ubesdelight.common.registry.UbesDelightShapes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface LeafFeastBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final LeafFeastTypeProperty LEAF_FEAST_TYPE = UbesDelightBlockStateProperties.LEAF_FEAST_TYPE;
    public static final int MAX_SERVINGS = 6;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)1, (int)6);
    public static final VoxelShape LEAF_BASE_SHAPE = UbesDelightShapes.LEAF_BASE_SHAPE;
    public static final VoxelShape NORTH_CONNECT_SHAPE = UbesDelightShapes.NORTH_CONNECT_SHAPE;
    public static final VoxelShape LEAF_NORTH_TIP_SHAPE = UbesDelightShapes.LEAF_NORTH_TIP_SHAPE;
    public static final VoxelShape LEAF_NORTH_END_SHAPE = UbesDelightShapes.LEAF_NORTH_END_SHAPE;

    default public boolean placementConnectsTo(Direction direction, BlockState blockState) {
        if (this.validBlock(blockState)) {
            return direction == blockState.m_61143_((Property)FACING);
        }
        return false;
    }

    default public boolean connectsTo(BlockState originState, BlockState state) {
        if (this.validBlock(state) && this.validBlock(originState)) {
            return state.m_61143_((Property)FACING) == originState.m_61143_((Property)FACING);
        }
        return false;
    }

    default public boolean validBlock(BlockState state) {
        return state.m_60734_() instanceof LeafFeastBlock;
    }

    default public VoxelShape getConnectShape(LeafFeastTypes leafFeastType, Pair<Direction, Direction> connectDirections, VoxelShape[] connectShapes) {
        VoxelShape shape = Shapes.m_83040_();
        if (leafFeastType.isRightConnect()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)connectShapes[((Direction)connectDirections.getFirst()).m_122416_()]);
        }
        if (leafFeastType.isLeftConnect()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)connectShapes[((Direction)connectDirections.getSecond()).m_122416_()]);
        }
        return shape;
    }

    default public VoxelShape getBaseShape(LeafFeastTypes leafFeastType, Direction facing, VoxelShape[] tipShapes, VoxelShape[] endShapes, VoxelShape baseShape) {
        VoxelShape shape = Shapes.m_83040_();
        shape = leafFeastType.isRightConnect() && !leafFeastType.isLeftConnect() ? Shapes.m_83110_((VoxelShape)shape, (VoxelShape)tipShapes[facing.m_122416_()]) : (leafFeastType.isLeftConnect() && !leafFeastType.isRightConnect() ? Shapes.m_83110_((VoxelShape)shape, (VoxelShape)endShapes[facing.m_122416_()]) : Shapes.m_83110_((VoxelShape)shape, (VoxelShape)baseShape));
        return shape;
    }

    default public Pair<Direction, Direction> getConnectDirections(Direction facing) {
        return Pair.of((Object)facing.m_122427_(), (Object)facing.m_122427_().m_122424_());
    }

    default public BlockState getTransformState(Block block, BlockState state) {
        return (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)((LeafFeastTypes)((Object)state.m_61143_((Property)LEAF_FEAST_TYPE)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
    }

    default public LeafFeastTypes getLeafFeastType(boolean leftConnect, boolean rightConnect) {
        if (rightConnect && leftConnect) {
            return LeafFeastTypes.MIDDLE;
        }
        if (rightConnect) {
            return LeafFeastTypes.TIP;
        }
        if (leftConnect) {
            return LeafFeastTypes.END;
        }
        return LeafFeastTypes.BASE;
    }

    default public void playAddSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, UbesDelightSounds.BLOCK_LEAF_FEAST_ADD.get(), SoundSource.PLAYERS, 0.6f, 0.75f);
    }

    default public void playRemoveSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, UbesDelightSounds.BLOCK_LEAF_FEAST_REMOVE.get(), SoundSource.PLAYERS, 0.6f, 0.8f);
    }

    public static void triggerConsumeAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            UbesDelightAdvancements.USE_LEAF_FEAST_CONSUME.trigger((ServerPlayer)player);
        }
    }

    public static void triggerInsertAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            UbesDelightAdvancements.USE_LEAF_FEAST_INSERT.trigger((ServerPlayer)player);
        }
    }
}

