/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.leaf_feast.base.BaseLeafFeastBlock;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import com.chefmooon.ubesdelight.common.utility.VoxelShapeUtil;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeLeafFeastBlock
extends BaseLeafFeastBlock {
    public Supplier<Item> servingItem;
    protected final ConcurrentHashMap<LeafFeastTypes, ConcurrentHashMap<Integer, VoxelShape[]>> FEAST_VARIANTS_SERVINGS;
    private static final int MAX_SERVINGS = 3;

    public LargeLeafFeastBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties, ConcurrentHashMap<LeafFeastTypes, ConcurrentHashMap<Integer, VoxelShape>> voxelShapes) {
        super(properties);
        this.servingItem = servingItem;
        this.FEAST_VARIANTS_SERVINGS = VoxelShapeUtil.getRotatedShapes(voxelShapes);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(3)));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (level.m_5776_() && (heldItem.m_41619_() ? this.tryRemoveItem(state, level, pos, player, hand).m_19077_() : this.tryAddItem(state, level, pos, player, hand).m_19077_())) {
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41619_()) {
            return this.tryRemoveItem(state, level, pos, player, hand);
        }
        return this.tryAddItem(state, level, pos, player, hand);
    }

    @Override
    protected InteractionResult tryAddItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack heldItem;
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        if (servings < 3 && (heldItem = player.m_21120_(hand)).m_150930_(this.servingItem.get())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41620_(1);
            }
            this.playAddSound(level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public boolean addItemFromDispenser(ItemStack itemStack, ServerLevel level, BlockPos pos, BlockState state) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        if (servings < 3) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            this.playAddSound((Level)level, pos);
            return true;
        }
        return false;
    }

    @Override
    protected InteractionResult tryRemoveItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        ItemStack itemStack = new ItemStack((ItemLike)this.servingItem.get());
        if (servings > 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
            this.playRemoveSound(level, pos);
            if (!player.m_7500_()) {
                if (player.m_6144_() && (player.m_36324_().m_38721_() || Objects.requireNonNull(itemStack.m_41720_().m_41473_()).m_38747_())) {
                    LargeLeafFeastBlock.tryEat(itemStack, level, pos, player);
                } else if (!player.m_150109_().m_36054_(itemStack)) {
                    player.m_36176_(itemStack, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (servings == 1) {
            Block block = BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST);
            level.m_7731_(pos, this.getTransformState(block, state), 3);
            level.m_46717_(pos, block);
            this.playRemoveSound(level, pos);
            if (!player.m_7500_()) {
                if (player.m_6144_() && (player.m_36324_().m_38721_() || Objects.requireNonNull(itemStack.m_41720_().m_41473_()).m_38747_())) {
                    LargeLeafFeastBlock.tryEat(itemStack, level, pos, player);
                } else if (!player.m_150109_().m_36054_(itemStack)) {
                    player.m_36176_(itemStack, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        LeafFeastTypes leafFeastType = (LeafFeastTypes)((Object)state.m_61143_((Property)LEAF_FEAST_TYPE));
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
            leafFeastType = LeafFeastTypes.MIDDLE;
        }
        VoxelShape servingShape = Shapes.m_83040_();
        if (this.FEAST_VARIANTS_SERVINGS.containsKey((Object)LeafFeastTypes.MIDDLE) && this.FEAST_VARIANTS_SERVINGS.get((Object)LeafFeastTypes.MIDDLE).containsKey(servings)) {
            servingShape = this.FEAST_VARIANTS_SERVINGS.get((Object)LeafFeastTypes.MIDDLE).get(servings)[facing.m_122416_()];
        }
        return Shapes.m_83124_((VoxelShape)this.getConnectShape(leafFeastType, this.getConnectDirections(facing.m_122424_()), this.CONNECT_SHAPES), (VoxelShape[])new VoxelShape[]{this.getBaseShape(leafFeastType, facing, this.TIP_SHAPES, this.END_SHAPES, LEAF_BASE_SHAPE), servingShape});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluid = context.m_43725_().m_6425_(blockPos);
        Level blockGetter = context.m_43725_();
        Direction facing = context.m_8125_();
        Pair connectDirections = this.getConnectDirections(facing.m_122424_());
        BlockState rightBlockState = blockGetter.m_8055_(blockPos.m_121945_((Direction)connectDirections.getSecond()));
        BlockState leftBlockState = blockGetter.m_8055_(blockPos.m_121945_((Direction)connectDirections.getFirst()));
        LeafFeastTypes leafFeastType = this.placementConnectsTo(facing, leftBlockState) || this.placementConnectsTo(facing, rightBlockState) ? LeafFeastTypes.MIDDLE : LeafFeastTypes.BASE;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Pair connectDirections;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction == (connectDirections = this.getConnectDirections(((Direction)state.m_61143_((Property)FACING)).m_122424_())).getFirst() || direction == connectDirections.getSecond()) {
            LeafFeastTypes leafFeastType = this.getLeafFeastType(this.connectsTo(state, level.m_8055_(pos.m_121945_((Direction)connectDirections.getFirst()))), this.connectsTo(state, level.m_8055_(pos.m_121945_((Direction)connectDirections.getSecond()))));
            if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
                return (BlockState)state.m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)LeafFeastTypes.MIDDLE));
            }
            return (BlockState)state.m_61124_((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
        }
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return LargeLeafFeastBlock.getOutputSignal((Integer)state.m_61143_((Property)SERVINGS));
    }

    public static int getOutputSignal(int servings) {
        return servings * 4;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

