/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import com.chefmooon.ubesdelight.common.block.LemongrassStalkCropBlock;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.registry.UbesDelightItems;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LemongrassLeafCropBlock
extends CropBlock {
    public static final IntegerProperty lEMONGRASS_AGE = BlockStateProperties.f_61407_;
    public static final int MAX_AGE = 3;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};

    public LemongrassLeafCropBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_));
    }

    public boolean m_6724_(BlockState state) {
        return !this.m_52307_(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 6 && (age = this.m_52305_(state)) <= this.m_7419_() && random.m_188503_((int)(25.0f / (growthSpeed = LemongrassLeafCropBlock.getGrowthSpeed(level.m_8055_(pos.m_7495_()).m_60734_(), (BlockGetter)level, pos.m_7495_()))) + 1) == 0) {
            if (age == this.m_7419_()) {
                LemongrassLeafCropBlock lemongrassUpper = (LemongrassLeafCropBlock)BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP);
                if (lemongrassUpper.m_49966_().m_60710_((LevelReader)level, pos.m_7494_()) && level.m_46859_(pos.m_7494_())) {
                    level.m_46597_(pos.m_7494_(), lemongrassUpper.m_49966_());
                }
            } else {
                level.m_46597_(pos, this.withAge(age + 1));
            }
        }
    }

    protected static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean northSouth;
        float growthSpeed = 1.0f;
        BlockPos blockPos = pos.m_7495_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                float farmlandBonus = 0.0f;
                BlockState blockStateBelow = level.m_8055_(blockPos.m_7918_(x, 0, y));
                if (blockStateBelow.m_60713_(Blocks.f_50093_)) {
                    farmlandBonus = 1.0f;
                    if (blockStateBelow.m_61138_((Property)FarmBlock.f_53243_) && (Integer)blockStateBelow.m_61143_((Property)FarmBlock.f_53243_) > 0) {
                        farmlandBonus = 3.0f;
                    }
                }
                if (x != 0 || y != 0) {
                    farmlandBonus /= 4.0f;
                }
                growthSpeed += farmlandBonus;
            }
        }
        BlockPos blockPosNorth = pos.m_122012_();
        BlockPos blockPosSouth = pos.m_122019_();
        BlockPos blockPosWest = pos.m_122024_();
        BlockPos blockPosEast = pos.m_122029_();
        boolean eastWest = level.m_8055_(blockPosWest).m_60713_(block) || level.m_8055_(blockPosEast).m_60713_(block);
        boolean bl = northSouth = level.m_8055_(blockPosNorth).m_60713_(block) || level.m_8055_(blockPosSouth).m_60713_(block);
        if (eastWest && northSouth) {
            growthSpeed /= 2.0f;
        } else {
            boolean diagonal;
            boolean bl2 = diagonal = level.m_8055_(blockPosWest.m_122012_()).m_60713_(block) || level.m_8055_(blockPosEast.m_122012_()).m_60713_(block) || level.m_8055_(blockPosEast.m_122019_()).m_60713_(block) || level.m_8055_(blockPosWest.m_122019_()).m_60713_(block);
            if (diagonal) {
                growthSpeed /= 2.0f;
            }
        }
        return growthSpeed;
    }

    public IntegerProperty m_7959_() {
        return lEMONGRASS_AGE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.m_7959_())];
    }

    public int m_7419_() {
        return 3;
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age));
    }

    protected ItemLike m_6404_() {
        return BuiltInRegistryUtil.getItem(UbesDelightItems.LEMONGRASS);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{lEMONGRASS_AGE});
    }

    protected int m_7125_(Level level) {
        return super.m_7125_(level) / 2;
    }

    public boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_STALK_CROP));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockStateBelow = level.m_8055_(pos.m_7495_());
        Block block = blockStateBelow.m_60734_();
        if (block instanceof LemongrassStalkCropBlock) {
            LemongrassStalkCropBlock lemongrassStalkCropBlock = (LemongrassStalkCropBlock)block;
            return lemongrassStalkCropBlock.m_52307_(blockStateBelow) && (level.m_45524_(pos, 0) >= 6 || level.m_45527_(pos));
        }
        return super.m_7898_(state, level, pos);
    }
}

