/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import com.chefmooon.ubesdelight.common.utility.TagUtils;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LecheFlanFeastBlock
extends Block {
    public static final int MAX_BITES = 5;
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)4);
    public final Supplier<Item> serving;
    protected static VoxelShape[] BITES_TO_SHAPE = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.m_49796_((double)5.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.m_49796_((double)7.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.m_49796_((double)9.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.m_49796_((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0)};

    public LecheFlanFeastBlock(Supplier<Item> serving) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_));
        this.serving = serving;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BITES_TO_SHAPE[(Integer)state.m_61143_((Property)BITES)];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (heldStack.m_204117_(TagUtils.getKifeItemTag()) && this.cutSlice(level, pos, state).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.consumeBite(level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        if (heldStack.m_204117_(TagUtils.getKifeItemTag())) {
            return this.cutSlice(level, pos, state);
        }
        return this.consumeBite(level, pos, state, player);
    }

    public ItemStack getCakeSliceStack() {
        return new ItemStack((ItemLike)this.serving.get());
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player player) {
        int bites;
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack cakeSlice = this.getCakeSliceStack();
        FoodProperties slice = cakeSlice.m_41720_().m_41473_();
        player.m_36220_(Stats.f_12942_);
        level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        player.m_36324_().m_38712_(cakeSlice.m_41720_(), cakeSlice);
        if (cakeSlice.m_41614_() && slice != null) {
            for (Pair pair : slice.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) < 4) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
            level.m_142346_((Entity)player, GameEvent.f_157794_, pos);
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites < 4) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            level.m_142346_(null, GameEvent.f_157792_, pos);
        } else {
            level.m_7471_(pos, false);
            level.m_142346_(null, GameEvent.f_157794_, pos);
        }
        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.getCakeSliceStack());
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.BLOCKS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return LecheFlanFeastBlock.getOutputSignal((Integer)state.m_61143_((Property)BITES));
    }

    public static int getOutputSignal(int eaten) {
        return (5 - eaten) * 2;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

