/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.data.tag;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBiomes;
import com.crypticmushroom.minecraft.registry.data.registry.TagRegistry;
import com.crypticmushroom.minecraft.registry.data.tag.CrypticTagClass;
import com.crypticmushroom.minecraft.registry.directory.RegistryDirectory;
import com.crypticmushroom.minecraft.registry.directory.RegistryInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.Tags;

public final class MnBiomeTags
extends CrypticTagClass<Biome> {
    private static final MnBiomeTags INSTANCE = new MnBiomeTags();
    public static final TagKey<Biome> IS_COASTAL = MnBiomeTags.get().tag("is_coastal");
    public static final TagKey<Biome> IS_FOREST = MnBiomeTags.get().tag("is_forest");
    public static final TagKey<Biome> IS_PLAINS = MnBiomeTags.get().tag("is_plains");
    public static final TagKey<Biome> IS_WETLAND = MnBiomeTags.get().tag("is_wetland");
    public static final TagKey<Biome> IS_EVIL = MnBiomeTags.get().tag("is_evil");
    public static final TagKey<Biome> IS_UNDERGROUND = MnBiomeTags.get().tag("is_underground");
    public static final TagKey<Biome> IS_CAVE = MnBiomeTags.get().tag("is_cave");
    public static final TagKey<Biome> HAS_FORGOTTEN_LIBRARY = MnBiomeTags.get().structure("forgotten_library");
    public static final TagKey<Biome> HAS_RED_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/red");
    public static final TagKey<Biome> HAS_GREEN_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/green");
    public static final TagKey<Biome> HAS_CYAN_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/cyan");
    public static final TagKey<Biome> HAS_ORANGE_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/orange");
    public static final TagKey<Biome> HAS_PINK_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/pink");
    public static final TagKey<Biome> HAS_LIGHT_PINK_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/light_pink");
    public static final TagKey<Biome> HAS_WHITE_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/white");
    public static final TagKey<Biome> HAS_BLUE_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/blue");
    public static final TagKey<Biome> HAS_PURPLE_NIGHTSTAG = MnBiomeTags.get().tag("nightstag/purple");
    public static final TagKey<Biome> SPAWNS_RIFTS = MnBiomeTags.get().tag("spawns_rifts");
    public static final TagKey<Biome> NO_NIGHTSHADE_SPAWNING = MnBiomeTags.get().tag("no_nightshade_spawning");

    public static MnBiomeTags get() {
        return INSTANCE;
    }

    public void applyAppenders() {
        this.appender(IS_UNDERGROUND).childOf(new TagKey[]{Tags.Biomes.IS_UNDERGROUND});
        this.appender(IS_CAVE).childOf(new TagKey[]{IS_UNDERGROUND, Tags.Biomes.IS_CAVE});
        this.appender(IS_EVIL).add(new ResourceKey[]{MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.MALEVOLENT_FOREST});
        this.appender(HAS_FORGOTTEN_LIBRARY).add(new ResourceKey[]{MnBiomes.CAVERNS, MnBiomes.FUNGAL_CAVERNS});
        this.appender(HAS_RED_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.MALEVOLENT_FOREST, MnBiomes.MALIGNANT_GRASSLAND});
        this.appender(HAS_GREEN_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.WARPED_FIELDS, MnBiomes.FUNGI_FOREST, MnBiomes.DEAD_FOREST, MnBiomes.DECEITFUL_MARSH, MnBiomes.DECEITFUL_SWAMP});
        this.appender(HAS_CYAN_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.VIGILANT_FOREST, MnBiomes.VIGILANT_GLADE, MnBiomes.TOWERING_VIGILANT_FOREST, MnBiomes.WARPED_FIELDS, MnBiomes.FUNGI_FOREST, MnBiomes.RUNEBUSH_GROVE});
        this.appender(HAS_ORANGE_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.MALEVOLENT_FOREST, MnBiomes.MALIGNANT_GRASSLAND, MnBiomes.DECEITFUL_MARSH, MnBiomes.DECEITFUL_SWAMP});
        this.appender(HAS_PINK_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.CRYSTAL_SPIRES});
        this.appender(HAS_LIGHT_PINK_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.CRYSTAL_SPIRES});
        this.appender(HAS_WHITE_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.VIGILANT_FOREST, MnBiomes.VIGILANT_GLADE, MnBiomes.TOWERING_VIGILANT_FOREST, MnBiomes.NIGHT_PLAINS, MnBiomes.DEAD_FOREST, MnBiomes.MALEVOLENT_FOREST, MnBiomes.MALIGNANT_GRASSLAND});
        this.appender(HAS_BLUE_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.VIGILANT_FOREST, MnBiomes.VIGILANT_GLADE, MnBiomes.TOWERING_VIGILANT_FOREST, MnBiomes.WARPED_FIELDS, MnBiomes.FUNGI_FOREST, MnBiomes.RUNEBUSH_GROVE});
        this.appender(HAS_PURPLE_NIGHTSTAG).add(new ResourceKey[]{MnBiomes.VIGILANT_FOREST, MnBiomes.VIGILANT_GLADE, MnBiomes.TOWERING_VIGILANT_FOREST, MnBiomes.NIGHT_PLAINS, MnBiomes.FUNGI_FOREST});
        this.appender(SPAWNS_RIFTS).add(new TagKey[]{BiomeTags.f_215817_});
        this.appender(NO_NIGHTSHADE_SPAWNING).add(new ResourceKey[]{Biomes.f_48215_});
    }

    private TagKey<Biome> structure(String id) {
        return this.tag("has_structure/" + id);
    }

    private MnBiomeTags() {
        super("midnight", TagRegistry.get((RegistryInfo)RegistryDirectory.BIOME));
    }
}

