/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.manager;

import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.common.world.biome.effects.MidnightBiomeModifier;
import com.crypticmushroom.minecraft.registry.util.ReferenceMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MidnightBiomeModifierManager {
    protected final ReferenceMap<Biome, MidnightBiomeModifier> modifiers = new ReferenceMap();

    public static MidnightBiomeModifierManager get(LevelReader level) {
        return MidnightBiomeModifierManager.get(level.m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER);
    }

    public static MidnightBiomeModifierManager get(LogicalSide side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case LogicalSide.CLIENT -> Client.get();
            case LogicalSide.SERVER -> Server.get();
        };
    }

    public final void reset() {
        this.modifiers.reset();
    }

    public Map<ResourceLocation, MidnightBiomeModifier> getAll() {
        return Collections.unmodifiableMap(this.modifiers);
    }

    public MidnightBiomeModifier get(@Nullable ResourceKey<Biome> biome) {
        return this.get(biome != null ? biome.m_135782_() : null);
    }

    public MidnightBiomeModifier get(@Nullable Holder<Biome> biome) {
        if (biome == null) {
            return this.get((ResourceLocation)null);
        }
        return this.get(biome.m_203376_() == Holder.Kind.REFERENCE ? ((ResourceKey)biome.m_203543_().orElseThrow(() -> new NullPointerException("Failed to unwrap biome key from reference holder!"))).m_135782_() : null);
    }

    public MidnightBiomeModifier get(@Nullable ResourceLocation id) {
        return (MidnightBiomeModifier)this.modifiers.getOrDefault((Object)id, (Object)MidnightBiomeModifier.DEFAULT);
    }

    public static final class Client
    extends MidnightBiomeModifierManager {
        @Deprecated
        public static Client get() {
            return MidnightClient.get().getBiomeModifierManager();
        }

        public void add(ResourceLocation biome, MidnightBiomeModifier modifier) {
            this.modifiers.put(biome, (Object)modifier);
        }
    }

    public static final class Server
    extends MidnightBiomeModifierManager {
        private static final Server INSTANCE = new Server();

        public static Server get() {
            return INSTANCE;
        }

        public void add(Holder<Biome> biome, MidnightBiomeModifier modifier) {
            this.modifiers.put(biome, (Object)modifier);
        }

        private Server() {
        }
    }
}

