/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.structure.poolelement;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SingleWithRandomFeaturePoolElement
extends SinglePoolElement {
    public static final Codec<SingleWithRandomFeaturePoolElement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SingleWithRandomFeaturePoolElement.m_210465_(), (App)SingleWithRandomFeaturePoolElement.m_210462_(), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(poolElement -> poolElement.feature), (App)IntProvider.f_146531_.fieldOf("count").forGetter(poolElement -> poolElement.count), (App)SingleWithRandomFeaturePoolElement.m_210538_(), (App)Codec.BOOL.fieldOf("generate_bounding_box").forGetter(poolElement -> poolElement.debugEnabled)).apply((Applicative)instance, SingleWithRandomFeaturePoolElement::new));
    private final Holder<PlacedFeature> feature;
    private final IntProvider count;
    private final boolean debugEnabled;
    private boolean hasGeneratedFeature;

    protected SingleWithRandomFeaturePoolElement(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> processors, Holder<PlacedFeature> feature, IntProvider featureCount, StructureTemplatePool.Projection projection, boolean generateBoundingBox) {
        super(template, processors, projection);
        this.feature = feature;
        this.count = featureCount;
        this.debugEnabled = generateBoundingBox;
        this.hasGeneratedFeature = false;
    }

    public boolean m_213695_(StructureTemplateManager strucManager, WorldGenLevel level, StructureManager strucFeatureManager, ChunkGenerator chunkGen, BlockPos startPos, BlockPos centrePos, Rotation rot, BoundingBox chunkBoundingBox, RandomSource rand, boolean keepJigsaws) {
        StructurePlaceSettings placeSettings;
        StructureTemplate template = this.m_227299_(strucManager);
        if (!template.m_230328_((ServerLevelAccessor)level, startPos, centrePos, placeSettings = this.m_207169_(rot, chunkBoundingBox, keepJigsaws), rand, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((ServerLevelAccessor)level, (BlockPos)startPos, (BlockPos)centrePos, (StructurePlaceSettings)placeSettings, (List)this.m_227324_(strucManager, startPos, rot, false), (StructureTemplate)template)) {
            this.m_227329_((LevelAccessor)level, blockInfo, startPos, rot, rand, chunkBoundingBox);
        }
        BoundingBox bb = template.m_74633_(placeSettings, startPos);
        if (this.debugEnabled) {
            level.m_7731_(new BlockPos(bb.m_162395_(), bb.m_162396_(), bb.m_162398_()), ((Block)MnBlocks.ROUXE_ROCK.get()).m_49966_(), 1);
            level.m_7731_(new BlockPos(bb.m_162395_(), bb.m_162400_(), bb.m_162398_()), ((Block)MnBlocks.VIRILUX_BLOCK.get()).m_49966_(), 1);
            level.m_7731_(new BlockPos(bb.m_162395_(), bb.m_162396_(), bb.m_162401_()), ((Block)MnBlocks.VIRILUX_BLOCK.get()).m_49966_(), 1);
            level.m_7731_(new BlockPos(bb.m_162395_(), bb.m_162400_(), bb.m_162401_()), ((Block)MnBlocks.VIRILUX_BLOCK.get()).m_49966_(), 1);
            level.m_7731_(new BlockPos(bb.m_162399_(), bb.m_162396_(), bb.m_162398_()), ((Block)MnBlocks.VIRILUX_BLOCK.get()).m_49966_(), 1);
            level.m_7731_(new BlockPos(bb.m_162399_(), bb.m_162396_(), bb.m_162401_()), ((Block)MnBlocks.VIRILUX_BLOCK.get()).m_49966_(), 1);
            level.m_7731_(new BlockPos(bb.m_162399_(), bb.m_162400_(), bb.m_162398_()), ((Block)MnBlocks.VIRILUX_BLOCK.get()).m_49966_(), 1);
            level.m_7731_(new BlockPos(bb.m_162399_(), bb.m_162400_(), bb.m_162401_()), ((Block)MnBlocks.ROUXE_ROCK.get()).m_49966_(), 1);
        }
        if (!this.hasGeneratedFeature) {
            for (int i = 0; i < this.count.m_214085_(rand); ++i) {
                int x = rand.m_188503_(bb.m_162399_() - bb.m_162395_()) + bb.m_162395_();
                int y = rand.m_188503_(bb.m_162400_() - bb.m_162396_()) + bb.m_162396_();
                int z = rand.m_188503_(bb.m_162401_() - bb.m_162398_()) + bb.m_162398_();
                BlockPos featurePos = new BlockPos(x, y, z);
                ((PlacedFeature)this.feature.m_203334_()).m_226357_(level, chunkGen, rand, featurePos);
                this.hasGeneratedFeature = true;
            }
        }
        return true;
    }

    public String toString() {
        return "Template[" + this.f_210411_ + "], Feature[" + this.feature + "]";
    }

    private StructureTemplate m_227299_(StructureTemplateManager structureManager) {
        return (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureTemplateManager)structureManager).m_230359_(arg_0), Function.identity());
    }
}

