/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.processor;

import com.crypticmushroom.minecraft.midnight.common.registry.MnStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class BlockPatchProcessor
extends StructureProcessor {
    public static final Codec<BlockPatchProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)-1.0, (double)1.0).fieldOf("threshold").forGetter(processor -> processor.threshold), (App)Codec.INT.fieldOf("scale").forGetter(processor -> processor.scale), (App)BlockStateProvider.f_68747_.fieldOf("state_provider").forGetter(processor -> processor.stateProvider)).apply((Applicative)instance, BlockPatchProcessor::new));
    private final double threshold;
    private final int scale;
    private final BlockStateProvider stateProvider;

    public BlockPatchProcessor(double threshold, int scale, BlockStateProvider stateProvider) {
        this.threshold = threshold;
        this.scale = scale;
        this.stateProvider = stateProvider;
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos posA, BlockPos posB, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoWorld, StructurePlaceSettings settings, StructureTemplate template) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        NormalNoise noise = NormalNoise.m_230504_((RandomSource)rand, (int)(-this.scale), (double[])new double[]{1.0});
        double noiseValue = noise.m_75380_((double)blockInfoWorld.f_74675_().m_123341_(), (double)blockInfoWorld.f_74675_().m_123342_(), (double)blockInfoWorld.f_74675_().m_123343_()) + 1.0 / (double)blockInfoLocal.f_74675_().m_123342_();
        if (!blockInfoWorld.f_74676_().m_60795_() && noiseValue < this.threshold) {
            BlockState state = !blockInfoWorld.f_74676_().m_60838_((BlockGetter)level, blockInfoWorld.f_74675_()) ? Blocks.f_50016_.m_49966_() : this.stateProvider.m_213972_((RandomSource)rand, blockInfoWorld.f_74675_());
            return new StructureTemplate.StructureBlockInfo(blockInfoWorld.f_74675_(), state, blockInfoWorld.f_74677_());
        }
        return blockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)MnStructureProcessorTypes.NOISE_PATCH_PROCESSOR.get();
    }
}

