/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.util;

import net.minecraft.util.Mth;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;

@Deprecated
public final class ColorUtil {
    public static void applyColorF(TriConsumer<Float, Float, Float> action, int color) {
        action.accept((Object)Float.valueOf(ColorUtil.redf(color)), (Object)Float.valueOf(ColorUtil.greenf(color)), (Object)Float.valueOf(ColorUtil.bluef(color)));
    }

    public static <T> T applyColorF(TriFunction<Float, Float, Float, T> action, int color) {
        return (T)action.apply((Object)Float.valueOf(ColorUtil.redf(color)), (Object)Float.valueOf(ColorUtil.greenf(color)), (Object)Float.valueOf(ColorUtil.bluef(color)));
    }

    public static int redi(int rgb) {
        return rgb >>> 16 & 0xFF;
    }

    public static int greeni(int rgb) {
        return rgb >>> 8 & 0xFF;
    }

    public static int bluei(int rgb) {
        return rgb & 0xFF;
    }

    public static int alphai(int rgba) {
        return rgba >>> 24 & 0xFF;
    }

    public static double redd(int rgb) {
        return (double)ColorUtil.redi(rgb) / 255.0;
    }

    public static double greend(int rgb) {
        return (double)ColorUtil.greeni(rgb) / 255.0;
    }

    public static double blued(int rgb) {
        return (double)ColorUtil.bluei(rgb) / 255.0;
    }

    public static double alphad(int rgba) {
        return (double)ColorUtil.alphai(rgba) / 255.0;
    }

    public static float redf(int rgb) {
        return (float)ColorUtil.redi(rgb) / 255.0f;
    }

    public static float greenf(int rgb) {
        return (float)ColorUtil.greeni(rgb) / 255.0f;
    }

    public static float bluef(int rgb) {
        return (float)ColorUtil.bluei(rgb) / 255.0f;
    }

    public static float alphaf(int rgba) {
        return (float)ColorUtil.alphai(rgba) / 255.0f;
    }

    public static int rgb(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int rgba(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int rgba(int r, int g, int b) {
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int rgb(float r, float g, float b) {
        return ColorUtil.rgb((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static int rgba(float r, float g, float b, float a) {
        return ColorUtil.rgba((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int rgba(float r, float g, float b) {
        return ColorUtil.rgba((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static int rgb(double r, double g, double b) {
        return ColorUtil.rgb((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public static int rgba(double r, double g, double b, double a) {
        return ColorUtil.rgba((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0), (int)(a * 255.0));
    }

    public static int rgba(double r, double g, double b) {
        return ColorUtil.rgba((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public static int opaque(int rgb) {
        return 0xFF000000 | rgb & 0xFFFFFF;
    }

    public static int withAlpha(int rgb, int a) {
        return (a & 0xFF) << 24 | rgb & 0xFFFFFF;
    }

    public static int withAlpha(int rgb, float a) {
        return ColorUtil.withAlpha(rgb, (int)(a * 255.0f));
    }

    public static int withAlpha(int rgb, double a) {
        return ColorUtil.withAlpha(rgb, (int)(a * 255.0));
    }

    public static int rgb(int rgba) {
        return rgba & 0xFFFFFF;
    }

    public static int hsv(float h, float s, float v) {
        float ga;
        float ra;
        float c = v * s;
        float x = c * (1.0f - Math.abs((h %= 360.0f) / 60.0f % 2.0f - 1.0f));
        int hi = (int)(h / 60.0f);
        float ba = switch (hi) {
            default -> {
                ra = c;
                ga = x;
                yield 0.0f;
            }
            case 1 -> {
                ra = x;
                ga = c;
                yield 0.0f;
            }
            case 2 -> {
                ra = 0.0f;
                ga = c;
                yield x;
            }
            case 3 -> {
                ra = 0.0f;
                ga = x;
                yield c;
            }
            case 4 -> {
                ra = x;
                ga = 0.0f;
                yield c;
            }
            case 5 -> {
                ra = c;
                ga = 0.0f;
                yield x;
            }
        };
        float m = v - c;
        float r = ra + m;
        float g = ga + m;
        float b = ba + m;
        return ColorUtil.rgb(r, g, b);
    }

    public static int hsva(float h, float s, float v, float a) {
        return ColorUtil.withAlpha(ColorUtil.hsv(h, s, v), a);
    }

    public static int hsva(float h, float s, float v) {
        return ColorUtil.opaque(ColorUtil.hsv(h, s, v));
    }

    public static int hsv(double h, double s, double v) {
        return ColorUtil.hsv((float)h, (float)s, (float)v);
    }

    public static int hsva(double h, double s, double v, double a) {
        return ColorUtil.hsva((float)h, (float)s, (float)v, (float)a);
    }

    public static int hsva(double h, double s, double v) {
        return ColorUtil.hsva((float)h, (float)s, (float)v);
    }

    public static float greyf(int rgb) {
        return (ColorUtil.redf(rgb) + ColorUtil.greenf(rgb) + ColorUtil.bluef(rgb)) / 3.0f;
    }

    public static double greyd(int rgb) {
        return (ColorUtil.redd(rgb) + ColorUtil.greend(rgb) + ColorUtil.blued(rgb)) / 3.0;
    }

    public static int greyi(int rgb) {
        return (ColorUtil.redi(rgb) + ColorUtil.greeni(rgb) + ColorUtil.bluei(rgb)) / 3;
    }

    public static float cie1931yf(int rgb) {
        return (2126.0f * ColorUtil.redf(rgb) + 7152.0f * ColorUtil.greenf(rgb) + 722.0f * ColorUtil.bluef(rgb)) / 10000.0f;
    }

    public static double cie1931yd(int rgb) {
        return (2126.0 * ColorUtil.redd(rgb) + 7152.0 * ColorUtil.greend(rgb) + 722.0 * ColorUtil.blued(rgb)) / 10000.0;
    }

    public static int cie1931yi(int rgb) {
        return (2126 * ColorUtil.redi(rgb) + 7152 * ColorUtil.greeni(rgb) + 722 * ColorUtil.bluei(rgb)) / 10000;
    }

    public static int grey(int tint) {
        return ColorUtil.rgb(tint, tint, tint);
    }

    public static int greya(int tint, int a) {
        return ColorUtil.rgba(tint, tint, tint, a);
    }

    public static int greya(int tint) {
        return ColorUtil.rgba(tint, tint, tint);
    }

    public static int grey(float tint) {
        return ColorUtil.rgb(tint, tint, tint);
    }

    public static int greya(float tint, float a) {
        return ColorUtil.rgba(tint, tint, tint, a);
    }

    public static int greya(float tint) {
        return ColorUtil.rgba(tint, tint, tint);
    }

    public static int grey(double tint) {
        return ColorUtil.rgb(tint, tint, tint);
    }

    public static int greya(double tint, double a) {
        return ColorUtil.rgba(tint, tint, tint, a);
    }

    public static int greya(double tint) {
        return ColorUtil.rgba(tint, tint, tint);
    }

    public static int inverse(int rgb) {
        int a = rgb >>> 24 & 0xFF;
        int r = rgb >>> 16 & 0xFF;
        int g = rgb >>> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = 255 - r;
        g = 255 - g;
        b = 255 - b;
        return ColorUtil.rgba(r, g, b, a);
    }

    public static int darker(int rgb, float amount) {
        if (amount < 0.0f) {
            ColorUtil.lighter(rgb, -amount);
        }
        float a = ColorUtil.alphaf(rgb);
        float r = ColorUtil.redf(rgb);
        float g = ColorUtil.greenf(rgb);
        float b = ColorUtil.bluef(rgb);
        float mul = 1.0f - amount;
        return ColorUtil.rgba(r *= mul, g *= mul, b *= mul, a);
    }

    public static int lighter(int rgb, float amount) {
        if (amount < 0.0f) {
            ColorUtil.darker(rgb, -amount);
        }
        float a = ColorUtil.alphaf(rgb);
        float r = 1.0f - ColorUtil.redf(rgb);
        float g = 1.0f - ColorUtil.greenf(rgb);
        float b = 1.0f - ColorUtil.bluef(rgb);
        float mul = 1.0f - amount;
        return ColorUtil.rgba(1.0f - (r *= mul), 1.0f - (g *= mul), 1.0f - (b *= mul), a);
    }

    public static int saturate(int rgb, float amount) {
        amount += 1.0f;
        float hue = ColorUtil.huef(rgb);
        float sat = ColorUtil.saturationf(rgb);
        float val = ColorUtil.valuef(rgb);
        float a = ColorUtil.alphaf(rgb);
        return ColorUtil.hsva(hue, sat * (amount /= 2.0f), val, a);
    }

    public static int saturate(int rgb, double amount) {
        return ColorUtil.saturate(rgb, (float)amount);
    }

    public static int darker(int rgb, double amount) {
        return ColorUtil.darker(rgb, (float)amount);
    }

    public static int lighter(int rgb, double amount) {
        return ColorUtil.lighter(rgb, (float)amount);
    }

    public static int darker(int rgb, int amount) {
        return ColorUtil.darker(rgb, (float)amount / 255.0f);
    }

    public static int lighter(int rgb, int amount) {
        return ColorUtil.lighter(rgb, (float)amount / 255.0f);
    }

    public static int add(int a, int b) {
        return ColorUtil.rgba(Mth.m_14036_((float)(ColorUtil.redf(a) + ColorUtil.redf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.greenf(a) + ColorUtil.greenf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.bluef(a) + ColorUtil.bluef(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.alphaf(a) + ColorUtil.alphaf(b)), (float)0.0f, (float)1.0f));
    }

    public static int sub(int a, int b) {
        return ColorUtil.rgba(Mth.m_14036_((float)(ColorUtil.redf(a) - ColorUtil.redf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.greenf(a) - ColorUtil.greenf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.bluef(a) - ColorUtil.bluef(b)), (float)0.0f, (float)1.0f), Math.max(ColorUtil.alphaf(a), ColorUtil.alphaf(b)));
    }

    public static int subAlpha(int a, int b) {
        return ColorUtil.rgba(Mth.m_14036_((float)(ColorUtil.redf(a) - ColorUtil.redf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.greenf(a) - ColorUtil.greenf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.bluef(a) - ColorUtil.bluef(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.alphaf(a) - ColorUtil.alphaf(b)), (float)0.0f, (float)1.0f));
    }

    public static int mul(int a, int b) {
        return ColorUtil.rgba(Mth.m_14036_((float)(ColorUtil.redf(a) * ColorUtil.redf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.greenf(a) * ColorUtil.greenf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.bluef(a) * ColorUtil.bluef(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.alphaf(a) * ColorUtil.alphaf(b)), (float)0.0f, (float)1.0f));
    }

    public static int mul(int a, float val) {
        return ColorUtil.rgba(Mth.m_14036_((float)(ColorUtil.redf(a) * val), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.greenf(a) * val), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.bluef(a) * val), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.alphaf(a) * val), (float)0.0f, (float)1.0f));
    }

    public static int div(int a, int b) {
        return ColorUtil.rgba(Mth.m_14036_((float)(ColorUtil.redf(a) / ColorUtil.redf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.greenf(a) / ColorUtil.greenf(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.bluef(a) / ColorUtil.bluef(b)), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.alphaf(a) / ColorUtil.alphaf(b)), (float)0.0f, (float)1.0f));
    }

    public static int div(int a, float val) {
        return ColorUtil.rgba(Mth.m_14036_((float)(ColorUtil.redf(a) / val), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.greenf(a) / val), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.bluef(a) / val), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(ColorUtil.alphaf(a) / val), (float)0.0f, (float)1.0f));
    }

    public static int darken(int a, int b) {
        return ColorUtil.rgba(Math.min(ColorUtil.redf(a), ColorUtil.redf(b)), Math.min(ColorUtil.greenf(a), ColorUtil.greenf(b)), Math.min(ColorUtil.bluef(a), ColorUtil.bluef(b)), Math.min(ColorUtil.alphaf(a), ColorUtil.alphaf(b)));
    }

    public static int lighten(int a, int b) {
        return ColorUtil.rgba(Math.max(ColorUtil.redf(a), ColorUtil.redf(b)), Math.max(ColorUtil.greenf(a), ColorUtil.greenf(b)), Math.max(ColorUtil.bluef(a), ColorUtil.bluef(b)), Math.max(ColorUtil.alphaf(a), ColorUtil.alphaf(b)));
    }

    public static int darkest(int a, int b) {
        return ColorUtil.greyf(a) < ColorUtil.greyf(b) ? a : b;
    }

    public static int lightest(int a, int b) {
        return ColorUtil.greyf(a) > ColorUtil.greyf(b) ? a : b;
    }

    public static int darkestCIE1931(int a, int b) {
        return ColorUtil.cie1931yf(a) < ColorUtil.cie1931yf(b) ? a : b;
    }

    public static int lightestCIE1931(int a, int b) {
        return ColorUtil.cie1931yf(a) > ColorUtil.cie1931yf(b) ? a : b;
    }

    public static int darkestRed(int a, int b) {
        return ColorUtil.redf(a) < ColorUtil.redf(b) ? a : b;
    }

    public static int lightestRed(int a, int b) {
        return ColorUtil.redf(a) > ColorUtil.redf(b) ? a : b;
    }

    public static int darkestGreen(int a, int b) {
        return ColorUtil.greenf(a) < ColorUtil.greenf(b) ? a : b;
    }

    public static int lightestGreen(int a, int b) {
        return ColorUtil.greenf(a) > ColorUtil.greenf(b) ? a : b;
    }

    public static int darkestBlue(int a, int b) {
        return ColorUtil.bluef(a) < ColorUtil.bluef(b) ? a : b;
    }

    public static int lightestBlue(int a, int b) {
        return ColorUtil.bluef(a) > ColorUtil.bluef(b) ? a : b;
    }

    public static int overlay(int a, int b) {
        return ColorUtil.interpolate(a, b, ColorUtil.alphaf(b));
    }

    public static int interpolate(int a, int b, float t) {
        return ColorUtil.rgba(Mth.m_14179_((float)t, (float)ColorUtil.redf(a), (float)ColorUtil.redf(b)), Mth.m_14179_((float)t, (float)ColorUtil.greenf(a), (float)ColorUtil.greenf(b)), Mth.m_14179_((float)t, (float)ColorUtil.bluef(a), (float)ColorUtil.bluef(b)), Mth.m_14179_((float)t, (float)ColorUtil.alphaf(a), (float)ColorUtil.alphaf(b)));
    }

    public static int interpolate(int a, int b, double t) {
        return ColorUtil.interpolate(a, b, (float)t);
    }

    public static int interpolate(int a, int b, int t) {
        return ColorUtil.interpolate(a, b, (float)t / 255.0f);
    }

    public static int noTranslucency(int color, float threshold) {
        return ColorUtil.withAlpha(color, ColorUtil.alphaf(color) < threshold ? 0.0f : 1.0f);
    }

    public static int noTranslucency(int color, int threshold) {
        return ColorUtil.withAlpha(color, ColorUtil.alphai(color) < threshold ? 0 : 255);
    }

    public static int noTranslucency(int color, double threshold) {
        return ColorUtil.withAlpha(color, ColorUtil.alphad(color) < threshold ? 0.0 : 1.0);
    }

    public static float valuef(int color) {
        float r = ColorUtil.redf(color);
        float g = ColorUtil.greenf(color);
        float b = ColorUtil.bluef(color);
        return Math.max(r, Math.max(g, b));
    }

    public static double valued(int color) {
        double r = ColorUtil.redd(color);
        double g = ColorUtil.greend(color);
        double b = ColorUtil.blued(color);
        return Math.max(r, Math.max(g, b));
    }

    public static float lightnessf(int color) {
        float r = ColorUtil.redf(color);
        float g = ColorUtil.greenf(color);
        float b = ColorUtil.bluef(color);
        float cmax = Math.max(r, Math.max(g, b));
        float cmin = Math.min(r, Math.min(g, b));
        return (cmax + cmin) / 2.0f;
    }

    public static double lightnessd(int color) {
        double r = ColorUtil.redd(color);
        double g = ColorUtil.greend(color);
        double b = ColorUtil.blued(color);
        double cmax = Math.max(r, Math.max(g, b));
        double cmin = Math.min(r, Math.min(g, b));
        return (cmax + cmin) / 2.0;
    }

    public static float saturationf(int color) {
        float r = ColorUtil.redf(color);
        float g = ColorUtil.greenf(color);
        float b = ColorUtil.bluef(color);
        float cmax = Math.max(r, Math.max(g, b));
        float cmin = Math.min(r, Math.min(g, b));
        float delta = cmax - cmin;
        return cmax == 0.0f ? 0.0f : delta / cmax;
    }

    public static double saturationd(int color) {
        double r = ColorUtil.redd(color);
        double g = ColorUtil.greend(color);
        double b = ColorUtil.blued(color);
        double cmax = Math.max(r, Math.max(g, b));
        double cmin = Math.min(r, Math.min(g, b));
        double delta = cmax - cmin;
        return cmax == 0.0 ? 0.0 : delta / cmax;
    }

    public static float huef(int color) {
        float cmin;
        float b;
        float g;
        float r = ColorUtil.redf(color);
        float cmax = Math.max(r, Math.max(g = ColorUtil.greenf(color), b = ColorUtil.bluef(color)));
        float delta = cmax - (cmin = Math.min(r, Math.min(g, b)));
        if (delta == 0.0f) {
            return 0.0f;
        }
        if (cmax == r) {
            return (g - b) / delta % 6.0f * 60.0f;
        }
        if (cmax == g) {
            return ((b - r) / delta + 2.0f) * 60.0f;
        }
        return ((r - g) / delta + 4.0f) * 60.0f;
    }

    public static double hued(int color) {
        double cmin;
        double b;
        double g;
        double r = ColorUtil.redd(color);
        double cmax = Math.max(r, Math.max(g = ColorUtil.greend(color), b = ColorUtil.blued(color)));
        double delta = cmax - (cmin = Math.min(r, Math.min(g, b)));
        if (delta == 0.0) {
            return 0.0;
        }
        if (cmax == r) {
            return (g - b) / delta % 6.0 * 60.0;
        }
        if (cmax == g) {
            return ((b - r) / delta + 2.0) * 60.0;
        }
        return ((r - g) / delta + 4.0) * 60.0;
    }

    public static int hsl(float h, float s, float l) {
        float ga;
        float ra;
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs((h %= 360.0f) / 60.0f % 2.0f - 1.0f));
        int hi = (int)(h / 60.0f);
        float ba = switch (hi) {
            default -> {
                ra = c;
                ga = x;
                yield 0.0f;
            }
            case 1 -> {
                ra = x;
                ga = c;
                yield 0.0f;
            }
            case 2 -> {
                ra = 0.0f;
                ga = c;
                yield x;
            }
            case 3 -> {
                ra = 0.0f;
                ga = x;
                yield c;
            }
            case 4 -> {
                ra = x;
                ga = 0.0f;
                yield c;
            }
            case 5 -> {
                ra = c;
                ga = 0.0f;
                yield x;
            }
        };
        float m = l - c / 2.0f;
        float r = ra + m;
        float g = ga + m;
        float b = ba + m;
        return ColorUtil.rgb(r, g, b);
    }

    public static int hsla(float h, float s, float l, float a) {
        return ColorUtil.withAlpha(ColorUtil.hsl(h, s, l), a);
    }

    public static int hsla(float h, float s, float l) {
        return ColorUtil.opaque(ColorUtil.hsl(h, s, l));
    }

    public static int hsl(double h, double s, double l) {
        return ColorUtil.hsl((float)h, (float)s, (float)l);
    }

    public static int hsla(double h, double s, double l, double a) {
        return ColorUtil.hsla((float)h, (float)s, (float)l, (float)a);
    }

    public static int hsla(double h, double s, double l) {
        return ColorUtil.hsla((float)h, (float)s, (float)l);
    }

    public static int cmyk(float c, float m, float y, float k) {
        return ColorUtil.rgb((1.0f - c) * (1.0f - k), (1.0f - m) * (1.0f - k), (1.0f - y) * (1.0f - k));
    }

    public static int cmyka(float c, float m, float y, float k, float a) {
        return ColorUtil.withAlpha(ColorUtil.cmyk(c, m, y, k), a);
    }

    public static int cmyka(float c, float m, float y, float k) {
        return ColorUtil.opaque(ColorUtil.cmyk(c, m, y, k));
    }

    public static int cmyk(double c, double m, double y, double k) {
        return ColorUtil.cmyk((float)c, (float)m, (float)y, (float)k);
    }

    public static int cmyka(double c, double m, double y, double k, double a) {
        return ColorUtil.cmyka((float)c, (float)m, (float)y, (float)k, (float)a);
    }

    public static int cmyka(double c, double m, double y, double k) {
        return ColorUtil.cmyka((float)c, (float)m, (float)y, (float)k);
    }

    public static float keyf(int rgb) {
        float r = ColorUtil.redf(rgb);
        float g = ColorUtil.greenf(rgb);
        float b = ColorUtil.bluef(rgb);
        float max = Math.max(r, Math.max(g, b));
        return 1.0f - max;
    }

    public static double keyd(int rgb) {
        double r = ColorUtil.redd(rgb);
        double g = ColorUtil.greend(rgb);
        double b = ColorUtil.blued(rgb);
        double max = Math.max(r, Math.max(g, b));
        return 1.0 - max;
    }

    public static float cyanf(int rgb) {
        float r = ColorUtil.redf(rgb);
        float k = ColorUtil.keyf(rgb);
        return (1.0f - r - k) / (1.0f - k);
    }

    public static double cyand(int rgb) {
        double r = ColorUtil.redd(rgb);
        double k = ColorUtil.keyd(rgb);
        return (1.0 - r - k) / (1.0 - k);
    }

    public static float magentaf(int rgb) {
        float g = ColorUtil.greenf(rgb);
        float k = ColorUtil.keyf(rgb);
        return (1.0f - g - k) / (1.0f - k);
    }

    public static double magentad(int rgb) {
        double g = ColorUtil.greend(rgb);
        double k = ColorUtil.keyd(rgb);
        return (1.0 - g - k) / (1.0 - k);
    }

    public static float yellowf(int rgb) {
        float b = ColorUtil.bluef(rgb);
        float k = ColorUtil.keyf(rgb);
        return (1.0f - b - k) / (1.0f - k);
    }

    public static double yellowd(int rgb) {
        double b = ColorUtil.blued(rgb);
        double k = ColorUtil.keyd(rgb);
        return (1.0 - b - k) / (1.0 - k);
    }

    private static int hexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new NumberFormatException("Not a hex char: '" + c + "'");
    }

    private static int d(int s) {
        return s << 4 | s;
    }

    private static int d(int a, int b) {
        return a << 4 | b;
    }

    public static int hex(String hex) {
        if (hex.length() == 3) {
            int r = ColorUtil.d(ColorUtil.hexChar(hex.charAt(0)));
            int g = ColorUtil.d(ColorUtil.hexChar(hex.charAt(1)));
            int b = ColorUtil.d(ColorUtil.hexChar(hex.charAt(2)));
            return ColorUtil.rgb(r, g, b);
        }
        if (hex.length() == 6) {
            int r = ColorUtil.d(ColorUtil.hexChar(hex.charAt(0)), ColorUtil.hexChar(hex.charAt(1)));
            int g = ColorUtil.d(ColorUtil.hexChar(hex.charAt(2)), ColorUtil.hexChar(hex.charAt(3)));
            int b = ColorUtil.d(ColorUtil.hexChar(hex.charAt(4)), ColorUtil.hexChar(hex.charAt(5)));
            return ColorUtil.rgb(r, g, b);
        }
        throw new NumberFormatException("Color input '" + hex + "' does not have 3 or 6 hex chars");
    }

    public static int hexa(String hex) {
        if (hex.length() == 3) {
            int r = ColorUtil.d(ColorUtil.hexChar(hex.charAt(0)));
            int g = ColorUtil.d(ColorUtil.hexChar(hex.charAt(1)));
            int b = ColorUtil.d(ColorUtil.hexChar(hex.charAt(2)));
            return ColorUtil.rgba(r, g, b);
        }
        if (hex.length() == 4) {
            int r = ColorUtil.d(ColorUtil.hexChar(hex.charAt(1)));
            int g = ColorUtil.d(ColorUtil.hexChar(hex.charAt(2)));
            int b = ColorUtil.d(ColorUtil.hexChar(hex.charAt(3)));
            int a = ColorUtil.d(ColorUtil.hexChar(hex.charAt(0)));
            return ColorUtil.rgba(r, g, b, a);
        }
        if (hex.length() == 6) {
            int r = ColorUtil.d(ColorUtil.hexChar(hex.charAt(0)), ColorUtil.hexChar(hex.charAt(1)));
            int g = ColorUtil.d(ColorUtil.hexChar(hex.charAt(2)), ColorUtil.hexChar(hex.charAt(3)));
            int b = ColorUtil.d(ColorUtil.hexChar(hex.charAt(4)), ColorUtil.hexChar(hex.charAt(5)));
            return ColorUtil.rgba(r, g, b);
        }
        if (hex.length() == 8) {
            int r = ColorUtil.d(ColorUtil.hexChar(hex.charAt(2)), ColorUtil.hexChar(hex.charAt(3)));
            int g = ColorUtil.d(ColorUtil.hexChar(hex.charAt(4)), ColorUtil.hexChar(hex.charAt(5)));
            int b = ColorUtil.d(ColorUtil.hexChar(hex.charAt(6)), ColorUtil.hexChar(hex.charAt(7)));
            int a = ColorUtil.d(ColorUtil.hexChar(hex.charAt(0)), ColorUtil.hexChar(hex.charAt(1)));
            return ColorUtil.rgba(r, g, b, a);
        }
        throw new NumberFormatException("Color input '" + hex + "' does not have 3, 4, 6 or 8 hex chars");
    }

    private static float dist(float x, float y, float z) {
        return Mth.m_14116_((float)(x * x + y * y + z * z));
    }

    public static float distRGB(int a, int b) {
        return ColorUtil.dist(ColorUtil.redf(a) - ColorUtil.redf(b), ColorUtil.greenf(a) - ColorUtil.greenf(b), ColorUtil.bluef(a) - ColorUtil.bluef(b));
    }

    public static float distHSV(int a, int b) {
        return ColorUtil.dist(ColorUtil.huef(a) - ColorUtil.huef(b), ColorUtil.saturationf(a) - ColorUtil.saturationf(b), ColorUtil.valuef(a) - ColorUtil.valuef(b));
    }

    public static float distHSL(int a, int b) {
        return ColorUtil.dist(ColorUtil.huef(a) - ColorUtil.huef(b), ColorUtil.saturationf(a) - ColorUtil.saturationf(b), ColorUtil.lightnessf(a) - ColorUtil.lightnessf(b));
    }

    public static float distHSCie1931y(int a, int b) {
        return ColorUtil.dist(ColorUtil.huef(a) - ColorUtil.huef(b), ColorUtil.saturationf(a) - ColorUtil.saturationf(b), ColorUtil.cie1931yf(a) - ColorUtil.cie1931yf(b));
    }
}

