/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.registry;

import com.crypticmushroom.minecraft.midnight.common.entity.living.creature.ambient.CrystalBugEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal.DeceitfulSnapperEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal.NightstagEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal.SlinkEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal.TenevixenEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.Hunter;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.Nightshade;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.NovaEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.Rifter;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.StingerEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.misc.CorruptedPearlEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.misc.MnAreaEffectCloud;
import com.crypticmushroom.minecraft.midnight.common.entity.misc.UmbraLightningBolt;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.EboniteArrowEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.FlyingItemEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.NovaSpikeEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.ThrownBladeloop;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.ThrownBladeshroom;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.ThrownGeode;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.ThrownSporeBomb;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.ThrownStingerEgg;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.item.BladeloopItem;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.crypticmushroom.minecraft.midnight.common.registry.builder.MnEntityTypeBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public final class MnEntityTypes {
    public static final RegistryObject<EntityType<Rift>> RIFT;
    public static final RegistryObject<EntityType<MnAreaEffectCloud>> AREA_EFFECT_CLOUD;
    public static final RegistryObject<EntityType<UmbraLightningBolt>> UMBRA_LIGHTNING_BOLT;
    public static final RegistryObject<EntityType<CorruptedPearlEntity>> CORRUPTED_PEARL;
    public static final RegistryObject<EntityType<EboniteArrowEntity>> EBONITE_ARROW;
    public static final RegistryObject<EntityType<NovaSpikeEntity>> NOVA_SPIKE;
    public static final RegistryObject<EntityType<ThrownBladeshroom>> BLADESHROOM_CAP;
    public static final RegistryObject<EntityType<ThrownStingerEgg>> STINGER_EGG;
    public static final RegistryObject<EntityType<ThrownBladeloop>> NAGRILITE_BLADELOOP;
    public static final RegistryObject<EntityType<ThrownGeode>> GEODE;
    public static final RegistryObject<EntityType<ThrownSporeBomb>> SPORE_BOMB;
    public static final RegistryObject<EntityType<CrystalBugEntity>> CRYSTAL_BUG;
    public static final RegistryObject<EntityType<SlinkEntity>> SLINK;
    public static final RegistryObject<EntityType<TenevixenEntity>> TENEVIXEN;
    public static final RegistryObject<EntityType<NightstagEntity>> NIGHTSTAG;
    public static final RegistryObject<EntityType<Rifter>> RIFTER;
    public static final RegistryObject<EntityType<Nightshade>> NIGHTSHADE;
    public static final RegistryObject<EntityType<StingerEntity>> STINGER;
    public static final RegistryObject<EntityType<NovaEntity>> NOVA;
    public static final RegistryObject<EntityType<Hunter>> HUNTER;
    public static final RegistryObject<EntityType<DeceitfulSnapperEntity>> DECEITFUL_SNAPPER;
    public static final MobType CORRUPTED;

    public static void onAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)HUNTER.get(), Hunter.attributes().m_22265_());
        event.put((EntityType)STINGER.get(), StingerEntity.attributes().m_22265_());
        event.put((EntityType)TENEVIXEN.get(), TenevixenEntity.attributes().m_22265_());
        event.put((EntityType)NIGHTSHADE.get(), Nightshade.attributes().m_22265_());
        event.put((EntityType)SLINK.get(), SlinkEntity.attributes().m_22265_());
        event.put((EntityType)NIGHTSTAG.get(), NightstagEntity.attributes().m_22265_());
        event.put((EntityType)DECEITFUL_SNAPPER.get(), DeceitfulSnapperEntity.attributes().m_22265_());
        event.put((EntityType)NOVA.get(), NovaEntity.attributes().m_22265_());
        event.put((EntityType)CRYSTAL_BUG.get(), CrystalBugEntity.attributes().m_22265_());
        event.put((EntityType)RIFTER.get(), Rifter.attributes().m_22265_());
    }

    public static void onSpawnPlacementRegistration(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)NIGHTSTAG.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, NightstagEntity::spawnConditions, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)RIFTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MnEntityTypes::checkMnMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)NIGHTSHADE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MnEntityTypes::checkMnMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)STINGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MnEntityTypes::checkMnMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)NOVA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MnEntityTypes::checkMnMonsterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static boolean checkMnMonsterSpawnRules(EntityType<? extends Mob> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && MnEntityTypes.isDarkEnoughToSpawn(level, pos, random, true) && Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random, boolean ignoreSkylight) {
        if (!MnDimensions.THE_MIDNIGHT.is((Level)level.m_6018_())) {
            return Monster.m_219009_((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)random);
        }
        DimensionType dimensiontype = level.m_6042_();
        int monsterBlockLightCap = dimensiontype.m_223570_();
        if (monsterBlockLightCap >= 15 || level.m_45517_(LightLayer.BLOCK, pos) <= monsterBlockLightCap) {
            if (ignoreSkylight) {
                return true;
            }
            return level.m_46803_(pos) <= dimensiontype.m_223569_().m_214085_(random);
        }
        return false;
    }

    static {
        CORRUPTED = new MobType();
        RIFT = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder(new EntityType.EntityFactory<Rift>(){

            public Rift create(EntityType<Rift> entityType, Level level) {
                return new Rift(entityType, level);
            }
        }).id("rift")).localizedName("Rift")).category(MobCategory.MISC)).sized(2.25f, 4.0f, 0.3f).build();
        AREA_EFFECT_CLOUD = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new MnAreaEffectCloud((EntityType<? extends AreaEffectCloud>)entityType, level)).id("area_effect_cloud")).localizedName("Area Effect Cloud")).category(MobCategory.MISC)).build();
        UMBRA_LIGHTNING_BOLT = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new UmbraLightningBolt((EntityType<? extends UmbraLightningBolt>)entityType, level)).id("umbra_lightning_bolt")).localizedName("Umbra Lightning")).category(MobCategory.MISC)).build();
        CORRUPTED_PEARL = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new CorruptedPearlEntity((EntityType<? extends CorruptedPearlEntity>)entityType, level)).id("corrupted_pearl")).localizedName("Corrupted Pearl")).category(MobCategory.MISC)).sized(0.25f, 0.25f)).build();
        EBONITE_ARROW = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((type, level) -> new EboniteArrowEntity((EntityType<? extends AbstractArrow>)type, level)).id("ebonite_arrow")).localizedName("Ebonite Arrow")).category(MobCategory.MISC)).sized(0.5f, 0.5f)).build();
        GEODE = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((type, level) -> new ThrownGeode((EntityType<? extends ThrownGeode>)type, level)).id("thrown_geode")).localizedName("Thrown Geode")).category(MobCategory.MISC)).sized(0.25f, 0.25f)).build();
        BLADESHROOM_CAP = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new ThrownBladeshroom((EntityType<? extends ThrownBladeshroom>)entityType, level)).id("bladeshroom_cap")).localizedName("Bladeshroom Cap")).category(MobCategory.MISC)).build();
        STINGER_EGG = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((type, level) -> new ThrownStingerEgg((EntityType<? extends ThrownStingerEgg>)type, level)).id("thrown_stinger_egg")).localizedName("Thrown Stinger Egg")).category(MobCategory.MISC)).sized(0.25f, 0.25f)).build();
        NAGRILITE_BLADELOOP = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new ThrownBladeloop(level, (BladeloopItem)((Object)((Object)MnItems.NAGRILITE_BLADELOOP.get())))).id("nagrilite_bladeloop")).localizedName("Nagrilite Bladeloop")).category(MobCategory.MISC)).sized(0.5f, 0.5f)).build();
        NOVA_SPIKE = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new NovaSpikeEntity((EntityType<? extends ThrowableProjectile>)entityType, level)).id("nova_spike")).localizedName("Nova Spike")).category(MobCategory.MISC)).build();
        SPORE_BOMB = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((type, level) -> new ThrownSporeBomb((EntityType<? extends FlyingItemEntity>)type, level)).localizedName("Spore Bomb")).id("spore_bomb")).category(MobCategory.MISC)).sized(0.25f, 0.25f)).build();
        HUNTER = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new Hunter((EntityType<? extends Hunter>)entityType, level)).id("hunter")).localizedName("Hunter")).category(MobCategory.MONSTER)).sized(1.3f, 0.65f)).build();
        STINGER = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new StingerEntity((EntityType<? extends StingerEntity>)entityType, level)).id("stinger")).localizedName("Stinger")).category(MobCategory.MONSTER)).sized(1.15f, 0.45f)).build();
        TENEVIXEN = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new TenevixenEntity((EntityType<? extends TenevixenEntity>)entityType, level)).id("tenevixen")).localizedName("Tenevixen")).category(MobCategory.CREATURE)).build();
        NIGHTSHADE = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new Nightshade((EntityType<? extends Nightshade>)entityType, level)).id("nightshade")).localizedName("Nightshade")).category(MobCategory.MONSTER)).sized(0.75f, 3.0f)).build();
        SLINK = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new SlinkEntity((EntityType<? extends SlinkEntity>)entityType, level)).id("slink")).localizedName("Slink")).category(MobCategory.CREATURE)).build();
        NIGHTSTAG = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((type, level) -> new NightstagEntity((EntityType<? extends NightstagEntity>)type, level)).id("nightstag")).localizedName("Nightstag")).category(MobCategory.CREATURE)).sized(0.9f, 1.87f)).build();
        DECEITFUL_SNAPPER = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new DeceitfulSnapperEntity((EntityType<? extends DeceitfulSnapperEntity>)entityType, level)).id("deceitful_snapper")).localizedName("Deceitful Snapper")).category(MobCategory.MONSTER)).sized(1.0f, 1.0f)).build();
        NOVA = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new NovaEntity((EntityType<? extends NovaEntity>)entityType, level)).id("nova")).localizedName("Nova")).category(MobCategory.MONSTER)).sized(2.0f, 2.0f)).build();
        CRYSTAL_BUG = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new CrystalBugEntity((EntityType<? extends CrystalBugEntity>)entityType, level)).id("crystal_bug")).localizedName("Crystal Bug")).category(MobCategory.AMBIENT)).sized(0.5f, 0.5f)).build();
        RIFTER = ((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)((MnEntityTypeBuilder)new MnEntityTypeBuilder((entityType, level) -> new Rifter((EntityType<? extends Rifter>)entityType, level)).id("rifter")).localizedName("Rifter")).category(MobCategory.MONSTER)).sized(0.65f, 2.3f)).build();
    }
}

