/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.registry;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.world.biome.effects.MidnightBiomeModifier;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBiomeTags;
import com.crypticmushroom.minecraft.registry.builder.CodecTypeBuilder;
import com.crypticmushroom.minecraft.registry.directory.RegistryDirectory;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.NotHolderSet;

public final class MnBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_NIGHTSHADES = MnBiomeModifiers.key("add_nightshades");

    private static ResourceKey<BiomeModifier> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Midnight.id(name));
    }

    public static void bootstrap(BootstapContext<BiomeModifier> ctx) {
        HolderGetter biomes = ctx.m_255420_(Registries.f_256952_);
        ctx.m_255272_(ADD_NIGHTSHADES, (Object)ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)new AndHolderSet(List.of(biomes.m_254956_(BiomeTags.f_215817_), MnBiomeModifiers.not(ctx, RegistryDirectory.BIOME.getKey(), biomes.m_254956_(MnBiomeTags.NO_NIGHTSHADE_SPAWNING)))), (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)MnEntityTypes.NIGHTSHADE.get(), 10, 1, 1)));
    }

    private static <T> NotHolderSet<T> not(BootstapContext<BiomeModifier> context, ResourceKey<? extends Registry<T>> key, HolderSet<T> set) {
        return new NotHolderSet(new ForgeDidNotMakeTheirHolderSetDatagennable(key, context.m_255420_(key)), set);
    }

    private static final class ForgeDidNotMakeTheirHolderSetDatagennable<T>
    extends Record
    implements HolderLookup.RegistryLookup<T> {
        private final ResourceKey<? extends Registry<T>> key;
        private final HolderGetter<T> getter;

        private ForgeDidNotMakeTheirHolderSetDatagennable(ResourceKey<? extends Registry<T>> key, HolderGetter<T> getter) {
            this.key = key;
            this.getter = getter;
        }

        public Lifecycle m_254883_() {
            return Lifecycle.stable();
        }

        public Stream<Holder.Reference<T>> m_214062_() {
            throw new IllegalStateException();
        }

        public Stream<HolderSet.Named<T>> m_214063_() {
            throw new IllegalStateException();
        }

        public Optional<Holder.Reference<T>> m_254902_(ResourceKey<T> resourceKey) {
            return this.getter.m_254902_(resourceKey);
        }

        public Optional<HolderSet.Named<T>> m_254901_(TagKey<T> tag) {
            return this.getter.m_254901_(tag);
        }

        public boolean m_254921_(HolderOwner<T> pOwner) {
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ForgeDidNotMakeTheirHolderSetDatagennable.class, "key;getter", "key", "getter"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ForgeDidNotMakeTheirHolderSetDatagennable.class, "key;getter", "key", "getter"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ForgeDidNotMakeTheirHolderSetDatagennable.class, "key;getter", "key", "getter"}, this, o);
        }

        public ResourceKey<? extends Registry<T>> m_254879_() {
            return this.key;
        }

        public HolderGetter<T> getter() {
            return this.getter;
        }
    }

    public static final class Serializers {
        public static final RegistryObject<Codec<MidnightBiomeModifier>> MIDNIGHT_BIOME = ((CodecTypeBuilder)new CodecTypeBuilder(RegistryDirectory.BIOME_MODIFIER_SERIALIZER, () -> RecordCodecBuilder.create(c -> c.group((App)Biome.f_47431_.fieldOf("biome").forGetter(MidnightBiomeModifier::getBiome), (App)Codec.INT.fieldOf("night_grass_color").orElse((Object)5270648).forGetter(MidnightBiomeModifier::getNightGrassColor), (App)Codec.INT.fieldOf("shadowroot_leaves_color").orElse((Object)3813716).forGetter(MidnightBiomeModifier::getShadowrootLeavesColor), (App)Codec.FLOAT.fieldOf("fog_distance").orElse((Object)Float.valueOf(8.0f)).forGetter(MidnightBiomeModifier::getFogDistance)).apply((Applicative)c, c.stable(MidnightBiomeModifier::new)))).id("biome_effects")).build();
    }
}

