/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.particle;

import com.crypticmushroom.minecraft.midnight.common.registry.builder.MnParticleTypeBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleParticleWithOneInt
implements ParticleOptions {
    private static final ParticleOptions.Deserializer<SimpleParticleWithOneInt> DESERIALIZER = new ParticleOptions.Deserializer<SimpleParticleWithOneInt>(){

        private int attemptRead(StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return reader.readInt();
        }

        public SimpleParticleWithOneInt fromCommand(ParticleType<SimpleParticleWithOneInt> particleType, StringReader reader) throws CommandSyntaxException {
            return new SimpleParticleWithOneInt(particleType, this.attemptRead(reader));
        }

        public SimpleParticleWithOneInt fromNetwork(ParticleType<SimpleParticleWithOneInt> particleType, FriendlyByteBuf buffer) {
            return new SimpleParticleWithOneInt(particleType, buffer.readInt());
        }
    };
    private final ParticleType<SimpleParticleWithOneInt> type;
    public final int oneInt;

    private static Codec<SimpleParticleWithOneInt> codec(ParticleType<SimpleParticleWithOneInt> type) {
        return RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("oneInt").forGetter(o -> o.oneInt)).apply((Applicative)codec, i -> new SimpleParticleWithOneInt(type, (int)i)));
    }

    public static MnParticleTypeBuilder.TypeHolder<SimpleParticleWithOneInt> create() {
        return new MnParticleTypeBuilder.TypeHolder<SimpleParticleWithOneInt>(() -> DESERIALIZER, SimpleParticleWithOneInt::codec);
    }

    public SimpleParticleWithOneInt(ParticleType<SimpleParticleWithOneInt> type, int oneInt) {
        this.type = type;
        this.oneInt = oneInt;
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.oneInt);
    }

    public String m_5942_() {
        return String.format("%s %2d", ForgeRegistries.PARTICLE_TYPES.getKey(this.type), this.oneInt);
    }
}

