/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.network.capability;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.capability.IPersistentCapability;
import com.crypticmushroom.minecraft.midnight.common.capability.entity.BaseMnEntity;
import com.crypticmushroom.minecraft.midnight.common.network.MnNetwork;
import com.crypticmushroom.minecraft.midnight.common.network.MnPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class SyncEntityPacket<E extends Entity, C extends BaseMnEntity<E> & IPersistentCapability<C>>
implements MnPacket {
    protected final CompoundTag tag;
    private final int entityId;

    public SyncEntityPacket(C entity) {
        this(((IPersistentCapability)entity).save(new CompoundTag()), entity.getEntity().m_19879_());
    }

    public SyncEntityPacket(CompoundTag tag, E entity) {
        this(tag, entity.m_19879_());
    }

    public SyncEntityPacket(CompoundTag tag, int entityId) {
        this.tag = tag;
        this.entityId = entityId;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.tag);
        buffer.writeInt(this.entityId);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            try {
                this.loadEntity(Minecraft.m_91087_().f_91073_.m_6815_(this.entityId));
            }
            catch (Exception e) {
                Midnight.LOGGER.debug(MnNetwork.NETWORK_MARKER, "Attempted to read handle a Midnight entity packet for the incorrect type! This is not good.", (Throwable)e);
            }
        });
        MnPacket.super.handle(context);
    }

    protected abstract void loadEntity(E var1);
}

