/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.rift;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.entity.animation.ToggledAnimationState;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.RiftAttachment;
import com.crypticmushroom.minecraft.midnight.common.network.MnNetwork;
import com.crypticmushroom.minecraft.midnight.common.network.level.RiftBridgeMessage;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.util.BitFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class RiftBridge {
    public final ToggledAnimationState open = new ToggledAnimationState(20);
    public final ToggledAnimationState unstable = new ToggledAnimationState(110);
    public boolean used;
    public boolean exists = true;
    private final int id;
    private RiftAttachment attachment;
    private boolean sentOpen;
    private boolean sentUnstable;
    private boolean sentUsed;
    private int ticks;
    private int prevOpenTimer;
    private int prevUnstableTimer;
    private final Tracker tracker = new Tracker();
    private final Rift.Reference source = new Rift.Reference();
    private final Rift.Reference target = new Rift.Reference();

    public RiftBridge(int id, RiftAttachment attachment) {
        this.id = id;
        this.attachment = attachment;
        this.open.set(true);
    }

    public void tickTimers() {
        this.prevOpenTimer = this.open.getTimer();
        this.prevUnstableTimer = this.unstable.getTimer();
        ++this.ticks;
        if (this.open.get()) {
            this.open.setRate(1);
        } else {
            this.open.setRate(2);
        }
        this.open.update();
        this.unstable.update();
    }

    public boolean tickState() {
        Rift source;
        this.tracker.update();
        this.trySpawnEndpoint((ResourceKey<Level>)Level.f_46428_);
        this.trySpawnEndpoint(MnDimensions.THE_MIDNIGHT.get());
        if (this.unstable.get()) {
            if (this.unstable.getTimer() >= 110 && this.open.get()) {
                this.open.set(false);
            }
        } else if (this.ticks > 4000) {
            this.unstable.set(true);
        }
        if ((source = this.getSource()) != null && !source.m_6084_()) {
            return true;
        }
        Rift target = this.getTarget();
        return target != null && !target.m_6084_() || !this.open.get() && this.open.getTimer() <= 0;
    }

    private void trySpawnEndpoint(ResourceKey<Level> endpointDimension) {
        ServerLevel world;
        Rift.Reference endpointReference = this.getEndpointReference(endpointDimension);
        if (!endpointReference.hasReference() && (world = Midnight.getMinecraftServer().m_129880_(endpointDimension)) != null && world.m_46749_(this.attachment.pos())) {
            this.spawnRiftEntity(world);
        }
    }

    private void spawnRiftEntity(ServerLevel level) {
        Rift rift = (Rift)((EntityType)MnEntityTypes.RIFT.get()).m_20615_((Level)level);
        if (rift != null) {
            rift.acceptBridge(this);
            this.attachment.fixedToSurface(level).apply(rift);
            level.m_46865_(rift.m_20183_());
            level.m_7967_((Entity)rift);
        }
    }

    public Rift computeEndpoint(ResourceKey<Level> endpointDimension) {
        Rift rift;
        Runnable spawn = () -> {
            MinecraftServer server = Midnight.getMinecraftServer();
            this.spawnRiftEntity(server.m_129880_(endpointDimension));
        };
        Rift.Reference endpointReference = this.getEndpointReference(endpointDimension);
        if (!endpointReference.hasReference()) {
            spawn.run();
        }
        if ((rift = endpointReference.compute()) == null) {
            spawn.run();
        }
        return endpointReference.get();
    }

    public boolean isEndpointLoaded(ResourceKey<Level> endpointDimension) {
        ServerLevel world = Midnight.getMinecraftServer().m_129880_(endpointDimension);
        return world != null && world.m_46749_(this.attachment.pos());
    }

    public void writeState(FriendlyByteBuf buffer) {
        buffer.writeByte((int)new BitFlags().withBit(0, this.open.get()).withBit(1, this.unstable.get()).withBit(2, this.used).toInner());
        buffer.writeInt((this.ticks & 0xFFFF) << 16 | (this.open.getTimer() & 0xFF) << 8 | this.unstable.getTimer() & 0xFF);
    }

    public void handleState(FriendlyByteBuf buffer) {
        BitFlags flags = new BitFlags(buffer.readByte());
        this.open.set(flags.getBit(0));
        this.unstable.set(flags.getBit(1));
        this.used = flags.getBit(2);
        long packedTimers = buffer.readUnsignedInt();
        this.ticks = (int)(packedTimers >> 16 & 0xFFFFL);
        this.open.setTimer((int)(packedTimers >> 8 & 0xFFL));
        this.unstable.setTimer((int)(packedTimers & 0xFFL));
    }

    public void clearDirt() {
        this.sentOpen = this.open.get();
        this.sentUnstable = this.unstable.get();
        this.sentUsed = this.used;
    }

    public boolean isDirty() {
        return this.sentOpen != this.open.get() || this.sentUnstable != this.unstable.get() || this.sentUsed != this.used;
    }

    public int getId() {
        return this.id;
    }

    public void setAttachment(RiftAttachment attachment) {
        this.attachment = attachment;
    }

    public RiftAttachment getAttachment() {
        return this.attachment;
    }

    public float getOpenAnimation(float partialTicks) {
        return (float)this.prevOpenTimer + (float)(this.open.getTimer() - this.prevOpenTimer) * partialTicks;
    }

    public float getUnstableAnimation(float partialTicks) {
        return (float)this.prevUnstableTimer + (float)(this.unstable.getTimer() - this.prevUnstableTimer) * partialTicks;
    }

    public int getTimeUntilClose() {
        if (this.unstable.get()) {
            return 0;
        }
        return Math.max(4000 - this.ticks, 0);
    }

    public void accept(Rift rift) {
        ResourceKey endpointDimension = rift.m_9236_().m_46472_();
        this.getEndpointReference((ResourceKey<Level>)endpointDimension).set(rift);
    }

    private Rift.Reference getEndpointReference(ResourceKey<Level> endpointDimension) {
        return MnDimensions.THE_MIDNIGHT.get().equals(endpointDimension) ? this.target : this.source;
    }

    public void close() {
        this.used = true;
        this.unstable.set(true);
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    @Nullable
    public Rift getSource() {
        return this.source.get();
    }

    @Nullable
    public Rift getTarget() {
        return this.target.get();
    }

    public void remove() {
        this.exists = false;
        this.prevOpenTimer = this.open.getTimer();
        this.prevUnstableTimer = this.unstable.getTimer();
    }

    public CompoundTag serialize(CompoundTag nbt) {
        nbt.m_128405_("id", this.id);
        nbt.m_128365_("attachment", (Tag)this.attachment.save(new CompoundTag()));
        nbt.m_128365_("open", (Tag)this.open.save(new CompoundTag()));
        nbt.m_128365_("unstable", (Tag)this.unstable.save(new CompoundTag()));
        nbt.m_128379_("used", this.used);
        nbt.m_128405_("ticks", this.ticks);
        nbt.m_128365_("source", (Tag)this.source.save(new CompoundTag()));
        nbt.m_128365_("target", (Tag)this.target.save(new CompoundTag()));
        return nbt;
    }

    public static RiftBridge deserialize(CompoundTag nbt) {
        int id = nbt.m_128451_("id");
        RiftAttachment attachment = RiftAttachment.load(nbt.m_128469_("attachment"));
        RiftBridge bridge = new RiftBridge(id, attachment);
        bridge.open.load(nbt.m_128469_("open"));
        bridge.unstable.load(nbt.m_128469_("unstable"));
        bridge.used = nbt.m_128471_("used");
        bridge.ticks = nbt.m_128451_("ticks");
        bridge.source.load(nbt.m_128469_("source"));
        bridge.target.load(nbt.m_128469_("target"));
        return bridge;
    }

    public String toString() {
        return "RiftBridge{open=" + this.open + ", unstable=" + this.unstable + ", exists=" + this.exists + ", id=" + this.id + "}";
    }

    public class Tracker {
        private final Set<ServerPlayer> currentTrackingPlayers = new HashSet<ServerPlayer>();

        public void update() {
            if (RiftBridge.this.isDirty() && !this.currentTrackingPlayers.isEmpty()) {
                this.sendToTracking(new RiftBridgeMessage.State(RiftBridge.this));
                RiftBridge.this.clearDirt();
            }
            Collection<ServerPlayer> trackingPlayers = this.collectTrackingPlayers();
            for (ServerPlayer player : trackingPlayers) {
                if (this.currentTrackingPlayers.contains(player)) continue;
                MnNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RiftBridgeMessage.Create(RiftBridge.this));
            }
            for (ServerPlayer player : this.currentTrackingPlayers) {
                if (trackingPlayers.contains(player)) continue;
                MnNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RiftBridgeMessage.Remove(RiftBridge.this));
            }
            this.currentTrackingPlayers.clear();
            this.currentTrackingPlayers.addAll(trackingPlayers);
        }

        public <M> void sendToTracking(M message) {
            for (ServerPlayer player : this.currentTrackingPlayers) {
                MnNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), message);
            }
        }

        private Collection<ServerPlayer> collectTrackingPlayers() {
            Rift target;
            ArrayList<ServerPlayer> trackingPlayers = new ArrayList<ServerPlayer>();
            Rift source = RiftBridge.this.getSource();
            if (source != null) {
                this.collectTrackingPlayers(trackingPlayers, source);
            }
            if ((target = RiftBridge.this.getTarget()) != null) {
                this.collectTrackingPlayers(trackingPlayers, target);
            }
            return trackingPlayers;
        }

        private void collectTrackingPlayers(Collection<ServerPlayer> trackingPlayers, Rift target) {
            if (target.m_9236_().f_46443_) {
                return;
            }
            ChunkMap.TrackedEntity tracker = (ChunkMap.TrackedEntity)((ServerLevel)target.m_9236_()).m_7726_().f_8325_.f_140150_.get(target.m_19879_());
            if (tracker != null) {
                tracker.f_140475_.stream().map(ServerPlayerConnection::m_142253_).distinct().forEach(trackingPlayers::add);
            }
        }
    }
}

