/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.rift;

import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public record RiftAttachment(BlockPos pos, float yaw) {
    public static RiftAttachment read(FriendlyByteBuf buffer) {
        return new RiftAttachment(buffer.m_130135_(), buffer.readFloat());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeFloat(this.yaw);
    }

    public RiftAttachment fixedToSurface(ServerLevel level) {
        ChunkAccess chunk = level.m_46819_(this.pos.m_123341_(), this.pos.m_123343_(), ChunkStatus.f_62324_);
        int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, this.pos.m_123341_(), this.pos.m_123343_());
        BlockPos surfacePos = new BlockPos(this.pos.m_123341_(), height + 1, this.pos.m_123343_());
        return new RiftAttachment(surfacePos, this.yaw);
    }

    public void apply(Rift rift) {
        rift.m_19890_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.5, (double)this.pos.m_123343_() + 0.5, this.yaw, 0.0f);
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128405_("x", this.pos.m_123341_());
        nbt.m_128405_("y", this.pos.m_123342_());
        nbt.m_128405_("z", this.pos.m_123343_());
        nbt.m_128350_("yaw", this.yaw);
        return nbt;
    }

    public static RiftAttachment load(CompoundTag nbt) {
        BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
        float yaw = nbt.m_128457_("yaw");
        return new RiftAttachment(pos, yaw);
    }
}

