/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.projectile;

import com.crypticmushroom.minecraft.midnight.common.advancement.MnCriteriaTriggers;
import com.crypticmushroom.minecraft.midnight.common.entity.projectile.FlyingItemEntity;
import com.crypticmushroom.minecraft.midnight.common.misc.MnLootParameterSets;
import com.crypticmushroom.minecraft.midnight.common.misc.MnLootTables;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBlockTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ThrownGeode
extends FlyingItemEntity {
    public ThrownGeode(EntityType<? extends ThrownGeode> type, Level level) {
        super(type, level);
    }

    public ThrownGeode(Level level) {
        super((EntityType<? extends FlyingItemEntity>)((EntityType)MnEntityTypes.GEODE.get()), level);
    }

    public ThrownGeode(double x, double y, double z, Level level) {
        super((EntityType<? extends FlyingItemEntity>)((EntityType)MnEntityTypes.GEODE.get()), x, y, z, level);
    }

    public ThrownGeode(LivingEntity thrower, Level level) {
        super((EntityType<? extends FlyingItemEntity>)((EntityType)MnEntityTypes.GEODE.get()), thrower, level);
    }

    public static boolean canBreakGeodeOn(BlockState state) {
        return !state.m_204336_(MnBlockTags.MUST_NEVER_BREAK_GEODES) && state.m_204336_(MnBlockTags.CAN_BREAK_GEODES);
    }

    protected Item m_7881_() {
        return (Item)MnItems.GEODE.get();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        result.m_82443_().m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7846_());
        this.m_9236_().m_7967_((Entity)itemEntity);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockState state = this.m_9236_().m_8055_(result.m_82425_());
        SoundEvent sound = state.getSoundType((LevelReader)this.m_9236_(), result.m_82425_(), null).m_56778_();
        float pitch = state.getSoundType((LevelReader)this.m_9236_(), result.m_82425_(), null).m_56774_();
        float volume = 1.0f;
        boolean shouldBreak = ThrownGeode.canBreakGeodeOn(state);
        if (shouldBreak) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            sound = (SoundEvent)MnSoundEvents.ENTITY_GEODE_BREAK.get();
            pitch = this.f_19796_.m_188501_() * 0.3f + 0.85f;
            MinecraftServer server = this.m_9236_().m_7654_();
            if (server != null) {
                LootTable loot = server.m_278653_().m_278676_(MnLootTables.GAMEPLAY_GEODE);
                LootParams.Builder ctxbuilder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81461_, (Object)state);
                ObjectArrayList stacks = loot.m_287195_(ctxbuilder.m_287235_(MnLootParameterSets.GEODE));
                for (ItemStack stack : stacks) {
                    this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
                }
            }
        } else {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7846_());
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_19749_() instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, volume, pitch);
        Entity entity = this.m_19749_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            if (!this.m_9236_().f_46443_) {
                MnCriteriaTriggers.GEODE_HIT_BLOCK_TRIGGER.trigger(serverplayer, shouldBreak);
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_7822_(byte status) {
        if (status == 3) {
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * 0.08, (this.f_19796_.m_188500_() - 0.5) * 0.08, (this.f_19796_.m_188500_() - 0.5) * 0.08);
            }
        }
    }
}

