/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.misc;

import com.crypticmushroom.minecraft.midnight.common.entity.misc.SignallingItemEntity;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CorruptedPearlEntity
extends SignallingItemEntity {
    public CorruptedPearlEntity(EntityType<? extends CorruptedPearlEntity> entityType, Level level) {
        super(entityType, level);
    }

    public CorruptedPearlEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends SignallingItemEntity>)((EntityType)MnEntityTypes.CORRUPTED_PEARL.get()), level, x, y, z);
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)MnItems.CORRUPTED_PEARL.get();
    }

    @Override
    protected int getLifeTime() {
        return 240;
    }

    @Override
    protected void onDiscard() {
        this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f);
    }

    @Override
    protected void onItemDeath(ServerLevel level) {
        double x = this.m_20182_().m_7096_();
        double y = this.m_20182_().m_7098_();
        double z = this.m_20182_().m_7094_();
        for (int count = 0; count < 8; ++count) {
            level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)MnItems.CORRUPTED_PEARL.get())), x, y, z, 0, this.f_19796_.m_188583_() * 0.15, this.f_19796_.m_188500_() * 0.2, this.f_19796_.m_188583_() * 0.15, 1.0);
        }
        for (double d20 = 0.0; d20 < Math.PI * 2; d20 += 0.15707963267948966) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)MnParticleTypes.TENDRIL_POLLEN.get()), x + Math.cos(d20) * 5.0, y - 0.4, z + Math.sin(d20) * 5.0, 0, Math.cos(d20) * -5.0, 0.0, Math.sin(d20) * -5.0, 1.0);
            level.m_8767_((ParticleOptions)((SimpleParticleType)MnParticleTypes.TENDRIL_POLLEN.get()), x + Math.cos(d20) * 5.0, y - 0.4, z + Math.sin(d20) * 5.0, 0, Math.cos(d20) * -7.0, 0.0, Math.sin(d20) * -7.0, 1.0);
        }
    }

    @Override
    protected Vec3 getMovement(double vecX, double vecY, double vecZ) {
        double dX = this.tx - vecX;
        double dY = this.ty - vecY;
        double dZ = this.tz - vecZ;
        float dist = (float)Math.sqrt(dX * dX + dZ * dZ);
        float horizontalAngle = (float)Mth.m_14136_((double)dZ, (double)dX);
        float verticalAngle = (float)Mth.m_14136_((double)dist, (double)dY);
        double speed = 0.5;
        return new Vec3(Math.cos(horizontalAngle) * speed, Math.cos(verticalAngle) * speed, Math.sin(horizontalAngle) * speed);
    }

    @Override
    protected void spawnParticles(Vec3 vec3, double x, double y, double z) {
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, x - vec3.f_82479_ * 0.25, y - vec3.f_82480_ * 0.25, z - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
        } else {
            this.m_9236_().m_7106_((ParticleOptions)MnParticleTypes.TENDRIL_POLLEN.get(), x - vec3.f_82479_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, this.m_20186_(), z - vec3.f_82481_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
    }

    @Override
    protected boolean shouldDiscard(float dist) {
        return dist < 3.0f || !this.m_9236_().m_8055_(this.m_20183_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_()).m_83281_();
    }

    @Override
    protected boolean shouldItemSurvive() {
        return false;
    }
}

