/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.monster;

import com.crypticmushroom.minecraft.midnight.common.entity.animation.AnimationHelper;
import com.crypticmushroom.minecraft.midnight.common.entity.behaviour.ApplyAttributeModifierBehaviour;
import com.crypticmushroom.minecraft.midnight.common.entity.behaviour.SetRandomWalkTargetNearRift;
import com.crypticmushroom.minecraft.midnight.common.entity.behaviour.SetWalkTargetToNearbyRift;
import com.crypticmushroom.minecraft.midnight.common.entity.behaviour.TargetRideAttack;
import com.crypticmushroom.minecraft.midnight.common.entity.living.ai.BrainActivityGroupMap;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.INativeRiftTraveler;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.entity.sensor.NearbyRiftsSensor;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBrainUtil;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMemoryTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.ReactToUnreachableTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Rifter
extends Monster
implements GeoEntity,
SmartBrainOwner<Rifter>,
INativeRiftTraveler {
    public static final float HOME_SCALE_MODIFIER = 1.4f;
    private static final UUID HOME_MODIFIERS_UUID = UUID.fromString("3b8cda1f-c11d-478b-98b1-6144940c7ba1");
    private static final AttributeModifier HOME_SPEED_MODIFIER = new AttributeModifier(HOME_MODIFIERS_UUID, "home_speed_modifier", 0.15, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier HOME_ARMOR_MODIFIER = new AttributeModifier(HOME_MODIFIERS_UUID, "home_armor_modifier", 6.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier HOME_ATTACK_MODIFIER = new AttributeModifier(HOME_MODIFIERS_UUID, "home_attack_modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier HOME_KNOCKBACK_RES_MODIFIER = new AttributeModifier(HOME_MODIFIERS_UUID, "home_knockback_res_modifier", 0.2, AttributeModifier.Operation.ADDITION);
    public final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Rifter(EntityType<? extends Rifter> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new RifterMoveControl(this);
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    public List<? extends ExtendedSensor<Rifter>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> target instanceof Player || target instanceof Animal && !target.m_8077_() && target.m_21223_() <= 10.0f), new NearbyRiftsSensor().setRadius(20.0, 6.0)});
    }

    public BrainActivityGroup<Rifter> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid(), new LookAtTarget(), new MoveToWalkTarget(), ApplyAttributeModifierBehaviour.builder().addModifier(Attributes.f_22279_, HOME_SPEED_MODIFIER, Rifter::inHomeDim).addModifier(Attributes.f_22281_, HOME_ATTACK_MODIFIER, Rifter::inHomeDim).addModifier(Attributes.f_22284_, HOME_ARMOR_MODIFIER, Rifter::inHomeDim).addModifier(Attributes.f_22278_, HOME_KNOCKBACK_RES_MODIFIER, Rifter::inHomeDim).build(), MnBrainUtil.riftBasedHealOrHurt(this, e -> !MnDimensions.THE_MIDNIGHT.is(e.m_9236_()))});
    }

    public BrainActivityGroup<Rifter> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().attackablePredicate(e -> e.m_20270_((Entity)this) > 7.0f ? !e.m_6047_() : true), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTargetNearRift().setRadius(15.0, 5.0).startCondition(e -> !this.inHomeDim()), new SetRandomWalkTarget()}), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<? extends Rifter> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf(MnBrainUtil::attackTargetInvalid), new SetWalkTargetToAttackTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetRideAttack<Mob>(6).whenSuccessful((e, target) -> BrainUtils.setMemory((LivingEntity)e, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.DRAGGING_ENTITY.get()), (Object)target)).targetValidIf((e, target) -> !target.m_20159_() || !(target.m_20202_() instanceof Rifter)).startCondition(e -> !this.inHomeDim() && BrainUtils.hasMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get())) && !((List)BrainUtils.getMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()))).isEmpty()), new AnimatableMeleeAttack(6).startCondition(e -> !(e instanceof Animal))})});
    }

    public Map<Activity, BrainActivityGroup<? extends Rifter>> getAdditionalTasks() {
        return new BrainActivityGroupMap(new BrainActivityGroup(Activity.f_37992_).priority(5).onlyStartWithMemoryStatus((MemoryModuleType)MnMemoryTypes.DRAGGING_ENTITY.get(), MemoryStatus.VALUE_PRESENT).behaviours(new Behavior[]{new InvalidateMemory<LivingEntity, LivingEntity>((MemoryModuleType)MnMemoryTypes.DRAGGING_ENTITY.get()){

            protected void start(LivingEntity entity) {
                LivingEntity draggingTarget = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)this.memory);
                if (draggingTarget != null && this.customPredicate.applyAsBoolean((Object)entity, (Object)draggingTarget)) {
                    BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)this.memory);
                    BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_);
                    entity.m_20153_();
                }
            }
        }.invalidateIf(this::shouldStopDragging), new SetWalkTargetToNearbyRift(), new ReactToUnreachableTarget().reaction((entity, unreachable) -> {
            BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26370_);
            BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.DRAGGING_ENTITY.get()));
        })}));
    }

    private <E> boolean shouldStopDragging(LivingEntity entity, E memory) {
        block4: {
            block5: {
                LivingEntity target;
                if (!BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get())) || ((List)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()))).isEmpty() || !entity.m_20160_()) {
                    return true;
                }
                if (!BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.DRAGGING_ENTITY.get())) || (target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.DRAGGING_ENTITY.get()))) == null) break block4;
                if (target.m_21224_()) break block5;
                if (!(target instanceof Player)) break block4;
                Player pl = (Player)target;
                if (!pl.m_150110_().f_35934_) break block4;
            }
            return true;
        }
        return false;
    }

    public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{Activity.f_37992_, Activity.f_37988_, Activity.f_37979_});
    }

    public double m_142593_(LivingEntity target) {
        return super.m_142593_(target) + 4.0;
    }

    public boolean inHomeDim() {
        return MnDimensions.THE_MIDNIGHT.is(this.m_9236_());
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
    }

    public MobType m_6336_() {
        return MnEntityTypes.CORRUPTED;
    }

    protected Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.m_20160_()) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("GrabStart").thenLoop("Holding"));
            }
            if (AnimationHelper.isCurrentlyAnimating((AnimationController<? extends GeoAnimatable>)state.getController(), "Holding")) {
                return state.setAndContinue(RawAnimation.begin().thenPlay("GrabStop"));
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        })});
        controllers.add(new AnimationController[]{DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_STRIKE)});
    }

    public int m_21304_() {
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            return 6 - (1 + MobEffectUtil.m_19586_((LivingEntity)this));
        }
        return this.m_21023_(MobEffects.f_19599_) ? 6 + (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2 : 15;
    }

    public float m_6134_() {
        return this.inHomeDim() ? 1.4f : 1.2f;
    }

    public boolean shouldRiderFaceForward(Player player) {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean m_20152_() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            Vec3 vec = this.holdPosition();
            callback.m_20372_(passenger, vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
        }
    }

    public Vec3 m_7688_(LivingEntity entity) {
        return this.holdPosition();
    }

    private Vec3 holdPosition() {
        float mov = 0.0f;
        float dist = (!this.inHomeDim() ? 1.5f : 1.8f) + mov;
        float x = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * dist;
        float z = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * dist;
        return new Vec3(this.m_20185_() - (double)x, this.m_20186_() + (double)(-mov) + (double)0.2f, this.m_20189_() + (double)z);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MnSoundEvents.ENTITY_RIFTER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MnSoundEvents.ENTITY_RIFTER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_RIFTER_DEATH.get();
    }

    @Override
    public void onEnterRift(Rift rift) {
        this.m_20153_();
        this.m_8127_();
    }

    @Override
    public Rift.TravelEntry createTravelEntry(Rift rift) {
        return new Rift.TravelEntry((LivingEntity)this);
    }

    @Override
    public Collection<Rift.TravelEntry> getAdditionalTravelers(Rift rift) {
        return this.m_20197_().stream().filter(e -> {
            LivingEntity l;
            return e instanceof LivingEntity && !(l = (LivingEntity)e).m_213877_() && l.m_6084_();
        }).map(e -> new Rift.TravelEntry((LivingEntity)e)).toList();
    }

    public class RifterMoveControl
    extends MoveControl {
        private final Rifter rifter;

        public RifterMoveControl(Rifter mob) {
            super((Mob)mob);
            this.rifter = mob;
        }

        public void m_8126_() {
            super.m_8126_();
            if (BrainUtils.hasMemory((LivingEntity)this.rifter, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.DRAGGING_ENTITY.get()))) {
                this.rifter.m_21564_(-this.rifter.f_20902_);
            }
        }

        protected float m_24991_(float sourceAngle, float targetAngle, float maximumChange) {
            return super.m_24991_(sourceAngle, targetAngle + (float)(BrainUtils.hasMemory((LivingEntity)this.rifter, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.DRAGGING_ENTITY.get())) ? 180 : 0), maximumChange);
        }
    }
}

